--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
AlliedScouts = { Actor189, Actor216, Actor217, Actor218, Actor219 }

SovReinforcements =
{
	east =
	{
		actors = { "e1", "e1", "e1", "e1", "e1" },
		entryPath = { EastEntry.Location, EastUnload.Location + CVec.New(1, 0) },
		exitPath = { EastEntry.Location },
	},
	south =
	{
		actors = { "e4", "e4", "e1", "e1", "e1" },
		entryPath = { SouthEntry.Location, SouthUnload.Location + CVec.New(0, 1) },
		exitPath = { SouthEntry.Location }
	},
	mammoth =
	{
		actors = { "4tnk" },
		entryPath = { SouthEntry.Location, SouthUnload.Location + CVec.New(0, 1) },
		exitPath = { SouthEntry.Location }
	}
}

Village = { Church, Actor147, Actor148, Actor149, Actor150, Actor151, Actor152, Actor153 }

ActivateAIDelay = DateTime.Seconds(45)

AddEastReinforcementTrigger = function()
	Trigger.AfterDelay(DateTime.Seconds(30), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		local reinforcement = SovReinforcements.east
		Reinforcements.ReinforceWithTransport(BadGuy, "lst.reinforcement", reinforcement.actors, reinforcement.entryPath, reinforcement.exitPath)
		FillLander()
	end)
end

AddSouthReinforcementTrigger = function()
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		local reinforcement = SovReinforcements.south
		Reinforcements.ReinforceWithTransport(BadGuy, "lst.reinforcement", reinforcement.actors, reinforcement.entryPath, reinforcement.exitPath)
	end)
end

AddParadropReinforcementTrigger = function()
	Trigger.AfterDelay(DateTime.Seconds(90), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		ScriptedDrop.TargetParatroopers(ScriptedParadrop.CenterPosition, Angle.New(40))
	end)
end

ChurchAmbushTrigger = function()
	if not AmbushSwitch then
		local hiding = Reinforcements.Reinforce(Germany, { 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3' }, { ChurchAmbush.Location, AmbushMove.Location }, 0)
		Utils.Do(hiding, IdleHunt)
	end
	AmbushSwitch = true
end

Trigger.OnKilled(Church, function()
	Actor.Create("moneycrate", true, { Owner = USSR, Location = ChurchAmbush.Location })
end)

DestroyVillage = function()
	Media.PlaySpeechNotification(All, "ReinforcementsArrived")
	for i, PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(DestroyVillageObjective)
	end
	local reinforcement = SovReinforcements.mammoth
	Reinforcements.ReinforceWithTransport(BadGuy, "lst.reinforcement", reinforcement.actors, reinforcement.entryPath, reinforcement.exitPath)
end

AddRetreatTrigger = function()
	Trigger.OnEnteredProximityTrigger(Actor222.CenterPosition, WDist.FromCells(12), function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and actor.Type == "barr" then
			AlliedScouts = Utils.Where(AlliedScouts, function(scout) return not scout.IsDead end)
			local removed
			Utils.Do(AlliedScouts, function(scout)
				if scout.Type == "e1" and not removed then
					removed = true
				else
					scout.Stop()
					scout.Move(ScoutRetreat.Location, 1)
				end
			end)
			Trigger.RemoveProximityTrigger(id)
		end
		end
	end)
end

BoatAttack = function(boat)
	if boat.IsDead then
		return
	else
		boat.AttackMove(BoatRally.Location)
	end
end

Tick = function()
	BadGuySpread()
	Greece.Cash = 1000

	if Greece.HasNoRequiredUnits() and Germany.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillAll)
		end
	end

	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(100) then
		Greece.MarkCompletedObjective(BeatUSSR)
	end
	end
end

FillLander = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Lander = BadGuy.GetActorsByType("lst.reinforcement")
		Lander.Owner = BadGuy
		for i, PID in pairs (CoopPlayers) do
		if PID ~= USSR then
	    ExtraMCV = Actor.Create("mcv", false, { Owner = PID })    
		Lander[1].LoadPassenger(ExtraMCV)
		end
		end
	end)
end

BadGuySpread  = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "lst.reinforcement" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
end

USSRSpread  = function()
	P1Units = USSR.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "lst.reinforcement" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("slntsrvc.vqa")
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Germany = Player.GetPlayer("Germany")
	Greece = Player.GetPlayer("Greece")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	Media.PlayMovieFullscreen("soviet8.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	USSRSpread()

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4, ExtraMine5, ExtraMine6, ExtraMine7, ExtraMine8, ExtraMine9, ExtraMine10}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Greece.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = Greece })
	CopyUnit.Scatter()
	end
	end
	
	EnemyUnits = Germany.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = Germany })
	CopyUnit.Scatter()
	end
	end	

	InitObjectives(USSR)
	for i, PID in pairs (CoopPlayers) do
	KillAll = AddPrimaryObjective(PID, "destroy-allied-units-structures")
	DestroyVillageObjective = AddSecondaryObjective(PID, "destroy-allied-sympathizers-village")
	end
	BeatUSSR = AddPrimaryObjective(Greece, "")

	AddEastReinforcementTrigger()
	AddSouthReinforcementTrigger()
	AddParadropReinforcementTrigger()
	AddRetreatTrigger()

	ScriptedDrop = Actor.Create("scripteddrop", false, { Owner = BadGuy })

	OnAnyDamaged(Village, ChurchAmbushTrigger)

	Trigger.OnAllRemovedFromWorld(Village, DestroyVillage)

	Camera.Position = SovietBase.CenterPosition

	Trigger.AfterDelay(ActivateAIDelay, ActivateAI)
	Trigger.AfterDelay(DateTime.Minutes(2), function() BoatAttack(Boat1) end)
	Trigger.AfterDelay(DateTime.Minutes(5), function() BoatAttack(Boat2) end)
	Trigger.AfterDelay(DateTime.Minutes(7), function() BoatAttack(Boat3) end)
	Trigger.AfterDelay(DateTime.Minutes(10), function() BoatAttack(Boat4) end)
	Trigger.AfterDelay(DateTime.Minutes(12), function() BoatAttack(Boat5) end)
	Trigger.AfterDelay(DateTime.Minutes(14), function() BoatAttack(Boat6) end)
	Trigger.AfterDelay(DateTime.Minutes(15), function() BoatAttack(Boat7) end)
end
