--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
CameraTriggerArea = { CPos.New(42, 45), CPos.New(43, 45), CPos.New(44, 45), CPos.New(45, 45), CPos.New(46, 45), CPos.New(47, 45), CPos.New(48, 45), CPos.New(48, 56), CPos.New(48, 57), CPos.New(48, 58), CPos.New(48, 59), CPos.New(40, 63), CPos.New(41, 63), CPos.New(42, 63), CPos.New(43, 63), CPos.New(44, 63), CPos.New(45, 63), CPos.New(46, 63), CPos.New(47, 63) }
PassingBridgeLocation = { CPos.New(59, 56), CPos.New(60, 56) }

CmdAtk = { Attacker1, Attacker2, Attacker3, Attacker4 }
FleeingUnits = { Fleeing1, Fleeing2 }
HuntingUnits = { Hunter1, Hunter2, Hunter3, Hunter4 }

AttackWaypoints = { AttackWaypoint1, AttackWaypoint2 }
AttackGroup = { }
AttackGroupSize = 3
AlliedInfantry = { "e1", "e1", "e3" }

SendAttackGroup = function()
	if #AttackGroup < AttackGroupSize then
		return
	end

	local way = Utils.Random(AttackWaypoints)
	Utils.Do(AttackGroup, function(unit)
		if not unit.IsDead then
			unit.AttackMove(way.Location)
			Trigger.OnIdle(unit, unit.Hunt)
		end
	end)

	AttackGroup = { }
end

ProduceInfantry = function()
	if Tent.IsDead then
		return
	end

	Greece.Build({ Utils.Random(AlliedInfantry) }, function(units)
	
		LastBuiltUnit = units[1]
		ProductionMultiplier()
		
		table.insert(AttackGroup, units[1])
		SendAttackGroup()
		Trigger.AfterDelay(DateTime.Seconds(10), ProduceInfantry)
	end)
end

ProductionMultiplier = function(unit)
	for m=1,EProMultiplier do
	CopyUnit = Actor.Create(LastBuiltUnit.Type, true, { Location = LastBuiltUnit.Location, Owner = LastBuiltUnit.Owner })
	CopyUnit.Scatter()
	table.insert(AttackGroup, CopyUnit)
	end
end

BadGuySpread  = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

USSRSpread  = function()
	P1Units = USSR.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
	if #CoopPlayers > 1 and CurrentPlayer == USSR then
	CoopCurrent = CoopCurrent + 1
	CurrentPlayer = CoopPlayers[CoopCurrent]
	end
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("spotter.vqa")
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Greece = Player.GetPlayer("Greece")
	Neutral = Player.GetPlayer("Neutral")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	Media.PlayMovieFullscreen("soviet2.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	USSRSpread()

	ConstructionVehicleReinforcements = { "mcv" }
	ConstructionVehiclePath = { CommandCenter.Location+CVec.New (2,2), CommandCenter.Location+CVec.New (2,2) }
	for i, PID in pairs (CoopPlayers) do
	if i ~= 1 then
	Reinforcements.Reinforce(PID, ConstructionVehicleReinforcements, ConstructionVehiclePath)
--	MCVs = Actor.Create("mcv", true, { Location = PlayerBase.Location, Owner = PID })
--	MCVs.Scatter()
	end
	end

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = Greece.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = Greece })
	CopyUnit.Scatter()
	end
	end


	InitObjectives(USSR)
	
	for i, PID in pairs (CoopPlayers) do
	CommandCenterIntact = AddPrimaryObjective(PID, "protect-command-center")
	DestroyAllAllied = AddPrimaryObjective(PID, "destroy-allied-units-structures")
	end

	Camera.Position	= CameraWaypoint.CenterPosition

	Trigger.OnKilled(CommandCenter, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CommandCenterIntact)
		end
	end)

	Trigger.AfterDelay(0, function()
		local buildings = Utils.Where(Map.ActorsInWorld, function(self) return self.Owner == Greece and self.HasProperty("StartBuildingRepairs") end)
		Utils.Do(buildings, function(actor)
			Trigger.OnDamaged(actor, function(building, attacker)
				if building.Owner == Greece and building.Health < building.MaxHealth * 0.8 then
					building.StartBuildingRepairs()
					if attacker.Type ~= "yak" and not AlreadyHunting then
						AlreadyHunting = true
						Utils.Do(Greece.GetGroundAttackers(), function(unit)
							Trigger.OnIdle(unit, unit.Hunt)
						end)
					end
				end
			end)
		end)

		-- Find the bridge actors
		BridgePart1 = Map.ActorsInBox(Box1.CenterPosition, Box2.CenterPosition, function(self) return self.Type == "br1" end)[1]
		BridgePart2 = Map.ActorsInBox(Box1.CenterPosition, Box2.CenterPosition, function(self) return self.Type == "br2" end)[1]
	end)

	-- Discover the area around the bridge exposing the two german soldiers
	-- When the two infantry near the bridge are discovered move them across the bridge to waypoint4
	-- in the meanwhile one USSR soldier hunts them down
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Actor.Create("camera", true, { Owner = USSR, Location = Box1.Location })

		Utils.Do(FleeingUnits, function(unit)
			unit.Move(RifleRetreat.Location)
		end)
		Follower.AttackMove(RifleRetreat.Location)
	end)

	-- To make it look more smooth we will blow up the bridge when the barrel closest to it blows up
	Trigger.OnAnyKilled({ BridgeBarrel1, BridgeBarrel2 }, function()
		-- Destroy the bridge
		if not BridgePart1.IsDead then
			BridgePart1.Kill()
		end
		if not BridgePart2.IsDead then
			BridgePart2.Kill()
		end
	end)

	-- If player passes over the bridge, blow up the barrel and destroy the bridge
	Trigger.OnEnteredFootprint(PassingBridgeLocation, function(unit, id)
		for i, PID in pairs (CoopPlayers) do
		if unit.Owner == PID then
			Trigger.RemoveFootprintTrigger(id)

			-- Also don't if the bridge is already dead
			if BridgePart1.IsDead and BridgePart2.IsDead then
				return
			end

			-- Don't "shoot" at the barrels if there is no-one to shoot
			if not FleeingUnits[1].IsDead then
				FleeingUnits[1].Attack(Barrel, true, true)
			elseif not FleeingUnits[2].IsDead then
				FleeingUnits[2].Attack(Barrel, true, true)
			end
		end
		end
	end)

	-- Four infantry from the small island move towards the USSR command center and attack it after 24 Seconds
	Trigger.AfterDelay(DateTime.Seconds(23),function()
		Failsafe1.Destroy()
		Failsafe2.Destroy()
		Failsafe3.Destroy()	
	end)
	Trigger.AfterDelay(DateTime.Seconds(24), function()

		Utils.Do(CmdAtk, function(unit)
			unit.AttackMove(AttackWaypoint1.Location)
			Trigger.OnIdle(unit, unit.Hunt)
		end)
	end)

	-- Start hunting
	Hunter4.AttackMove(AttackWaypoint2.Location) -- Move the unit in the correct direction first
	Utils.Do(HuntingUnits, function(unit)
		Trigger.OnIdle(unit, unit.Hunt)
	end)

	-- When destroying the allied radar dome or the refinery drop 2 badgers with 5 grenadiers each
	Trigger.OnAnyKilled({ AlliedDome, AlliedProc }, function()
		local powerproxy = Actor.Create("powerproxy.paratroopers", true, { Owner = BadGuy })
		powerproxy.TargetParatroopers(ParadropLZ.CenterPosition, Angle.South)
		powerproxy.TargetParatroopers(ParadropLZ.CenterPosition, Angle.SouthEast)
		powerproxy.Destroy()
	end)

	Greece.Resources = 2000
	Trigger.AfterDelay(DateTime.Seconds(30), ProduceInfantry)
end

Tick = function()
	BadGuySpread()
	if Greece.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(CommandCenterIntact)
		PID.MarkCompletedObjective(DestroyAllAllied)
		end
	end

	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(10) then
		for u, PID2 in pairs (CoopPlayers) do
		PID2.MarkFailedObjective(DestroyAllAllied)
		end
	end
	end
	
	if Greece.Resources > Greece.ResourceCapacity / 2 then
		Greece.Resources = Greece.ResourceCapacity / 2
	end
end
