--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
Yaks = { "yak", "yak", "yak" }
Airfields = { Airfield1, Airfield2, Airfield3 }

InsertYaks = function()
	local i = 1
	Utils.Do(Yaks, function(yakType)
		local start = YakEntry.CenterPosition + WVec.New(0, (i - 1) * 1536, Actor.CruiseAltitude(yakType))
		local dest = StartJeep.Location + CVec.New(0, 2 * i)
		local yak = Actor.Create(yakType, true, { CenterPosition = start, Owner = USSR, Facing = (Map.CenterOfCell(dest) - start).Facing })
		yak.Move(dest)
		yak.ReturnToBase(Airfields[i])
		i = i + 1
	end)
end

JeepDemolishingBridge = function()
	StartJeep.Move(StartJeepMovePoint.Location)

	Trigger.OnEnteredFootprint({ StartJeepMovePoint.Location }, function(actor, id)
		if actor.Owner == France and not BridgeBarrel.IsDead then
			Trigger.RemoveFootprintTrigger(id)
			BridgeBarrel.Kill()
		end

		local bridge = Map.ActorsInBox(BridgeWaypoint.CenterPosition, Airfield1.CenterPosition,
			function(self) return self.Type == "bridge1" end)[1]

		if not bridge.IsDead then
			bridge.Kill()
		end
	end)
end

Paratroopers = function()
	Trigger.OnKilled(StartJeep, function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Paradrop.TargetParatroopers(StartJeepMovePoint.CenterPosition, Angle.East)
	end)

	Trigger.OnKilled(Church, function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Paradrop.TargetParatroopers(StartJeepMovePoint.CenterPosition, Angle.East)
	end)

	Trigger.OnKilled(ParaHut, function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Paradrop.TargetParatroopers(StartJeepMovePoint.CenterPosition, Angle.East)
	end)
end

PanicAttack = function()
	if not HouseDamaged then
		local panicTeam = Reinforcements.Reinforce(France, { "c3", "c6", "c9" }, { CivSpawn.Location }, 0)
		Utils.Do(panicTeam, function(a)
			a.Move(a.Location + CVec.New(-1,-1))
			a.Panic()
		end)
	end
	HouseDamaged = true
end

BadGuySpread  = function()
	P1Units = BadGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
	if #CoopPlayers > 1 and CurrentPlayer == USSR then
	CoopCurrent = CoopCurrent + 1
	CurrentPlayer = CoopPlayers[CoopCurrent]
	end
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end

PlayOpening = function()
Media.PlayMovieFullscreen("soviet1.vqa", PlayOpening2)
end

PlayOpening2 = function()
Media.PlayMovieInRadar("flare.vqa")
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	France = Player.GetPlayer("France")
	Germany = Player.GetPlayer("Germany")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	Media.PlayMovieFullscreen("prolog.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, USSR)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end

	EnemyUnits = France.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = France })
	CopyUnit.Scatter()
	end
	end

	InitObjectives(USSR)
	
	for i,PID in pairs (CoopPlayers) do
	VillageRaidObjective = AddPrimaryObjective(PID, "raze-village")
	end
	
	Trigger.OnAllRemovedFromWorld(Airfields, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(VillageRaidObjective)
		end
	end)

	JeepDemolishingBridge()

	Paradrop = Actor.Create("powerproxy.paratroopers", false, { Owner = BadGuy })
	Trigger.AfterDelay(DateTime.Seconds(2), InsertYaks)
	Paratroopers()
	Trigger.OnDamaged(HayHouse, PanicAttack)
	Trigger.OnKilled(PillboxBarrel1, function()
		if not Pillbox1.IsDead then
			Pillbox1.Kill()
		end
	end)
	Trigger.OnKilled(PillboxBarrel2, function()
		if not Pillbox2.IsDead then
			Pillbox2.Kill()
		end
	end)
end

Tick = function()
BadGuySpread()
	if France.HasNoRequiredUnits() and Germany.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(VillageRaidObjective)
		end
	end
end
