--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
AlliedBoatReinforcements = { "dd", "dd" }
TimerTicks = DateTime.Minutes(21)
ObjectiveBuildings = { Chronosphere, AlliedTechCenter }
ScientistTypes = { "chan", "chan", "chan", "chan" }
ScientistDiscoveryFootprint = { CPos.New(28, 83), CPos.New(29, 83) }
ScientistEvacuationFootprint = { CPos.New(29, 60), CPos.New(29, 61), CPos.New(29, 62), CPos.New(29, 63), CPos.New(29, 64), CPos.New(29, 65), CPos.New(29, 66) }

InitialAlliedReinforcements = function()
		for i, PID in pairs (CoopPlayers) do
		Reinforcements.Reinforce(PID, { "mcv" }, { MCVEntry.Location, MCVStop.Location })
		end
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")

		Reinforcements.Reinforce(Greece, AlliedBoatReinforcements, { DDEntry.Location, DDStop.Location })
	end)
end

CreateScientists = function()
	local scientists = Reinforcements.Reinforce(Greece, ScientistTypes, { ScientistsExit.Location })
	Utils.Do(scientists, function(s)
		s.Move(s.Location + CVec.New(0, 1))
		s.Scatter()
	end)

	local flare = Actor.Create("flare", true, { Owner = Greece, Location = DefaultCameraPosition.Location + CVec.New(-1, 0) })
	Trigger.AfterDelay(DateTime.Seconds(2), function() Media.PlaySpeechNotification(All, "SignalFlareNorth") end)

	Trigger.OnAnyKilled(scientists, function()
		Media.PlaySpeechNotification(All, "ObjectiveNotMet")
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(EvacuateScientists)
		end
	end)

	-- Add the footprint trigger in a frame end task (delay 0) to avoid crashes
	local left = #scientists
	Trigger.AfterDelay(0, function()
		local changeOwnerTrigger = Trigger.OnEnteredFootprint(ScientistEvacuationFootprint, function(a, id)
			if a.Owner == Greece and a.Type == "chan" then
				a.Owner = Germany
				a.Stop()
				a.Move(MCVEntry.Location)

				-- Constantly try to reach the exit (and thus avoid getting stuck if the path was blocked)
				Trigger.OnIdle(a, function()
					a.Move(MCVEntry.Location)
				end)
			end
		end)

		-- Use a cell trigger to destroy the scientists preventing the player from causing glitchs by blocking the path
		Trigger.OnEnteredFootprint({ MCVEntry.Location }, function(a, id)
			if a.Owner == Germany then
				a.Stop()
				a.Destroy()

				left = left - 1
				if left == 0 then
					Trigger.RemoveFootprintTrigger(id)
					Trigger.RemoveFootprintTrigger(changeOwnerTrigger)
					flare.Destroy()

					if not Greece.IsObjectiveCompleted(EvacuateScientists) and not Greece.IsObjectiveFailed(EvacuateScientists) then
						Media.PlaySpeechNotification(All, "ObjectiveMet")
						for i, PID in pairs (CoopPlayers) do
						PID.MarkCompletedObjective(EvacuateScientists)
						end
					end
				end
			end
		end)
	end)
end

DefendChronosphereCompleted = function()
	local cells = Utils.ExpandFootprint({ ChronoshiftLocation.Location }, false)
	local units = { }
	for i = 1, #cells do
		local unit = Actor.Create("2tnk", true, { Owner = Greece, Facing = Angle.North })
		units[unit] = cells[i]
	end
	Chronosphere.Chronoshift(units)
	UserInterface.SetMissionText(UserInterface.Translate("experiment-successful"), Greece.Color)

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DefendChronosphere)
		PID.MarkCompletedObjective(KeepBasePowered)
		end
	end)
end

Ticked = TimerTicks
Tick = function()
	USSR.Cash = 5000

	if USSR.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DefendChronosphere)
		PID.MarkCompletedObjective(KeepBasePowered)
		end
	end

	if Greece.HasNoRequiredUnits() then
		USSR.MarkCompletedObjective(BeatAllies)
	end

	if Ticked > 0 then
		if (Ticked % DateTime.Seconds(1)) == 0 then
			Timer = UserInterface.Translate("chronosphere-experiments-completes-in", { ["time"] = Utils.FormatTime(Ticked) })
			UserInterface.SetMissionText(Timer, TimerColor)
		end
		Ticked = Ticked - 1
	elseif Ticked == 0 and (Greece.PowerState ~= "Normal") then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(KeepBasePowered)
		end
	elseif Ticked == 0 then
		DefendChronosphereCompleted()
		Ticked = Ticked - 1
	end
end

GerSpread  = function()
	P1Units = Germany.GetActors()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "dome" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
	if #CoopPlayers > 1 and CurrentPlayer == Greece then
	CoopCurrent = CoopCurrent + 1
	CurrentPlayer = CoopPlayers[CoopCurrent]
	end
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("aagun.vqa")
end

WorldLoaded = function()
	Neutral = Player.GetPlayer("Neutral")
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	Germany = Player.GetPlayer("Germany")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	
	Media.PlayMovieFullscreen("ally8.vqa", PlayOpening)
	
	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	GerSpread()
	
	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4, ExtraMine5, ExtraMine6, ExtraMine7}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end
	
	InitObjectives(Greece)
	for i, PID in pairs (CoopPlayers) do
	DefendChronosphere = AddPrimaryObjective(PID, "defend-chronosphere-tech-center")
	KeepBasePowered = AddPrimaryObjective(PID, "chronosphere-needs-power")
	EvacuateScientists = AddSecondaryObjective(PID, "evacuate-scientists-from-island")
	end
	BeatAllies = AddPrimaryObjective(USSR, "")

	Trigger.AfterDelay(DateTime.Minutes(1), function()
		Media.PlaySpeechNotification(All, "TwentyMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(11), function()
		Media.PlaySpeechNotification(All, "TenMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(16), function()
		Media.PlaySpeechNotification(All, "WarningFiveMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(18), function()
		Media.PlaySpeechNotification(All, "WarningThreeMinutesRemaining")
	end)
	Trigger.AfterDelay(DateTime.Minutes(20), function()
		Media.PlaySpeechNotification(All, "WarningOneMinuteRemaining")
	end)

	PowerProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = USSR })

	Camera.Position = DefaultCameraPosition.CenterPosition
	TimerColor = Greece.Color

	Trigger.OnAnyKilled(ObjectiveBuildings, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(DefendChronosphere)
		end
	end)

	Trigger.OnEnteredFootprint(ScientistDiscoveryFootprint, function(a, id)
		for i, PID in pairs (CoopPlayers) do
		if a.Owner == PID and not ScientistsTriggered then
			ScientistsTriggered = true
			Trigger.RemoveFootprintTrigger(id)
			CreateScientists()
		end
		end
	end)

	InitialAlliedReinforcements()
	ActivateAI()
end
