--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

ConvoyUnits =
{
	{ "ftrk", "ftrk", "truk", "truk", "apc", "ftrk" },
	{ "ftrk", "3tnk", "truk", "truk", "apc" },
	{ "3tnk", "3tnk", "truk", "truk", "ftrk" }
}

ConvoyRallyPoints =
{
	{ SovietEntry1.Location, SovietRally1.Location, SovietRally3.Location, SovietRally5.Location, SovietRally4.Location, SovietRally6.Location },
	{ SovietEntry2.Location, SovietRally10.Location, SovietRally11.Location }
}

ConvoyDelays =
{
	easy = { DateTime.Minutes(4), DateTime.Minutes(5) + DateTime.Seconds(20) },
	normal = { DateTime.Minutes(2) + DateTime.Seconds(30), DateTime.Minutes(4) },
	hard = { DateTime.Minutes(1) + DateTime.Seconds(30), DateTime.Minutes(2) + DateTime.Seconds(30) },
	tough = { DateTime.Minutes(1), DateTime.Minutes(1) + DateTime.Seconds(15) }
}

Convoys =
{
	easy = 2,
	normal = 3,
	hard = 5,
	tough = 10
}

ParadropDelays =
{
	easy = { DateTime.Seconds(40), DateTime.Seconds(90) },
	normal = { DateTime.Seconds(30), DateTime.Seconds(70) },
	hard = { DateTime.Seconds(20), DateTime.Seconds(50) },
	tough = { DateTime.Seconds(10), DateTime.Seconds(25) }
}

ParadropWaves =
{
	easy = 4,
	normal = 6,
	hard = 10,
	tough = 25
}

ParadropLZs = { ParadropPoint1.CenterPosition, ParadropPoint2.CenterPosition, ParadropPoint3.CenterPosition }

Paradropped = 0
Paradrop = function()
	Trigger.AfterDelay(Utils.RandomInteger(ParadropDelay[1], ParadropDelay[2]), function()
		local aircraft = PowerProxy.TargetParatroopers(Utils.Random(ParadropLZs))
		Utils.Do(aircraft, function(a)
			Trigger.OnPassengerExited(a, function(_, p)
				IdleHunt(p)
			end)
		end)

		Paradropped = Paradropped + 1
		if Paradropped <= ParadropWaves[Difficulty] then
			Paradrop()
		end
	end)
end

ConvoysSent = 0
SendConvoys = function()
	Trigger.AfterDelay(Utils.RandomInteger(ConvoyDelay[1], ConvoyDelay[2]), function()
		local path = Utils.Random(ConvoyRallyPoints)
		local units = Reinforcements.Reinforce(USSR, Utils.Random(ConvoyUnits), { path[1] })
		local lastWaypoint = path[#path]

		Utils.Do(units, function(unit)
			Trigger.OnAddedToWorld(unit, function()
				if unit.Type == "truk" then
					Utils.Do(path, function(waypoint)
						unit.Move(waypoint)
					end)

					Trigger.OnIdle(unit, function()
						unit.Move(lastWaypoint)
					end)
				else
					unit.Patrol(path)
					Trigger.OnIdle(unit, function()
						unit.AttackMove(lastWaypoint)
					end)
				end
			end)
		end)

		local id = Trigger.OnEnteredFootprint({ lastWaypoint }, function(a, id)
			if a.Owner == USSR and Utils.Any(units, function(unit) return unit == a end) then

				-- We are at our destination and thus don't care about other queued actions anymore
				a.Stop()
				a.Destroy()

				if a.Type == "truk" then
					for i,PID in pairs (CoopPlayers) do
					PID.MarkFailedObjective(DestroyConvoys)
					end
				end
			end
		end)

		Trigger.OnAllRemovedFromWorld(units, function()
			Trigger.RemoveFootprintTrigger(id)

			ConvoysSent = ConvoysSent + 1
			if ConvoysSent <= Convoys[Difficulty] then
				SendConvoys()
			else
				for i,PID in pairs (CoopPlayers) do
				PID.MarkCompletedObjective(DestroyConvoys)
				end
			end
		end)

		Media.PlaySpeechNotification(All, "ConvoyApproaching")
	end)
end

Tick = function()
for i,PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(2) and PID.HasNoRequiredUnits() then
		for i,OPID in pairs (CoopPlayers) do
		OPID.MarkFailedObjective(KillUSSR)
		end
	end
end

	if USSR.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillUSSR)

		-- We don't care about future convoys anymore
		PID.MarkCompletedObjective(DestroyConvoys)
		end
	end
end

AddObjectives = function()
	for i,PID in pairs (CoopPlayers) do
	KillUSSR = AddPrimaryObjective(PID, "destroy-soviet-units-buildings")
	DestroyConvoys = AddSecondaryObjective(PID, "destroy-convoys")
	end
end

PlayOpening = function()
Media.PlayMovieInRadar("binoc.vqa")
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	Media.PlayMovieFullscreen("ally4.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1

	USSR.Cash = 10000

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4, ExtraMine5, ExtraMine6}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end


	ConstructionVehicleReinforcements = { "mcv" }
	ConstructionVehiclePath = { SovietRally11.Location, PlayerBase.Location }
	for i, PID in pairs (CoopPlayers) do
	if i ~= 1 then
	Reinforcements.Reinforce(PID, ConstructionVehicleReinforcements, ConstructionVehiclePath)
--	MCVs = Actor.Create("mcv", true, { Location = PlayerBase.Location, Owner = PID })
--	MCVs.Scatter()
	end
	end
	
		P1Units = Greece.GetGroundAttackers()
	CoopCurrent = 1

for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end

	Camera.Position = AlliedConyard.CenterPosition

--	InitObjectives(Greece)
	AddObjectives()

	ConvoyDelay = ConvoyDelays[Difficulty]
	ParadropDelay = ParadropDelays[Difficulty]
	PowerProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = USSR })
	Paradrop()
	SendConvoys()

	Trigger.AfterDelay(0, ActivateAI)
end
