--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
StartingMCV = { "mcv" }
StartingUnits = { "2tnk", "2tnk", "2tnk", "2tnk" }
MammothWays = { MammothWay1.Location, MammothWay2.Location, MammothWay3.Location, MammothWay4.Location, ParaLZ5.Location }
PeekersA = { Peekaboo1, Peekaboo2, Peekaboo3 }
PeekersB = { Peekaboo4, Peekaboo5 }
AmbushTeam = { "3tnk", "v2rl", "e2", "e2", "e4" }
NorthHarassFootprint = { CPos.New(24, 75), CPos.New(25, 75), CPos.New(26, 75), CPos.New(27, 75), CPos.New(36, 72), CPos.New(37, 72), CPos.New(38, 72), CPos.New(39, 72) }
NorthHarassTeam = { "e2", "e2", "e2", "3tnk" }
MissileSilos = { MissileSilo1, MissileSilo2, MissileSilo3, MissileSilo4 }

TimerColor = Player.GetPlayer("USSR").Color
TimerTicks = DateTime.Minutes(59) + DateTime.Seconds(42)

MissionStart = function()
	Utils.Do(USSR.GetGroundAttackers(), function(unit)
		Trigger.OnDamaged(unit, function() IdleHunt(unit) end)
	end)
	
	for i, PID in pairs (CoopPlayers) do
	Reinforcements.Reinforce(PID, StartingMCV, { MCVEntry.Location, MCVStop.Location })
	end
	
	Reinforcements.Reinforce(GoodGuy, StartingUnits, { MCVEntry.Location, MCVStop.Location })
	PatrolMammoth.Patrol(MammothWays, true, 20)

	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Utils.Do(PeekersA, function(unit)
			if not unit.IsDead then
				unit.AttackMove(MCVStop.Location)
				IdleHunt(unit)
			end
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(45), function()
		Utils.Do(PeekersB, function(unit)
			if not unit.IsDead then
				unit.AttackMove(AttackWaypoint1.Location)
				IdleHunt(unit)
			end
		end)
	end)
end

MissionTriggers = function()
	Trigger.OnKilled(CommandCenter, function()
		USSR.MarkCompletedObjective(HoldOut)
	end)

	Trigger.OnEnteredProximityTrigger(FCom.CenterPosition, WDist.FromCells(15), function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and not MissilesLaunched then
			Trigger.RemoveProximityTrigger(id)
			LaunchMissiles()
		end
		end
	end)

	Trigger.OnTimerExpired(function()
		DateTime.TimeLimit = 0
		Trigger.AfterDelay(1, function() UserInterface.SetMissionText(UserInterface.Translate("we-are-too-late"), USSR.Color) end)
		USSR.MarkCompletedObjective(HoldOut)
	end)

	Trigger.OnKilled(BridgeBarrel, function()
		local bridge = Utils.Where(Map.ActorsInWorld, function(actor) return actor.Type == "bridge1" end)[1]
		if not bridge.IsDead then
			bridge.Kill()
		end
	end)

	Trigger.OnEnteredProximityTrigger(OreAmbushTrigger.CenterPosition, WDist.FromCells(5), function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and actor.Type == "harv" and not Map.LobbyOption("difficulty") == "easy" then
			Trigger.RemoveProximityTrigger(id)
			local ambush = Reinforcements.Reinforce(USSR, AmbushTeam, { OreAmbushEntry.Location})
			Utils.Do(ambush, IdleHunt)
		end
		end
	end)

	local northFootTriggered
	Trigger.OnEnteredFootprint(NorthHarassFootprint, function(actor, id)
		for i, PID in pairs (CoopPlayers) do
		if actor.Owner == PID and not northFootTriggered then
			Trigger.RemoveFootprintTrigger(id)
			northFootTriggered = true

			local northHarass = Reinforcements.Reinforce(USSR, NorthHarassTeam, { OreAmbushEntry.Location})
			Utils.Do(northHarass, IdleHunt)
		end
		end
	end)
end

LaunchMissiles = function()
	MissilesLaunched = true
	Actor.Create("camera", true, { Owner = Greece, Location = FCom.Location })
	Camera.Position = FCom.CenterPosition
	Media.PlaySpeechNotification(All, "AbombLaunchDetected")
	MissileSilo1.ActivateNukePower(CPos.New(127, 127))

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.DisplayMessage(UserInterface.Translate("incoming-transmission-capitalized"), UserInterface.Translate("landcom-16-capitalized"))
		Media.PlaySpeechNotification(All, "AbombLaunchDetected")
		MissileSilo2.ActivateNukePower(CPos.New(127, 127))
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.PlaySpeechNotification(All, "AbombLaunchDetected")
		MissileSilo3.ActivateNukePower(CPos.New(127, 127))
	end)

	Trigger.AfterDelay(DateTime.Seconds(6), function()
		Media.PlaySpeechNotification(All, "AbombLaunchDetected")
		MissileSilo4.ActivateNukePower(CPos.New(127, 127))
	end)

	Trigger.AfterDelay(DateTime.Seconds(8), function()
		local fmvStart = DateTime.GameTime
		Media.PlayMovieInRadar("ally10b.vqa", function()
			-- Completing immediately indicates that the FMV is not available
			-- Fall back to a text message
			if fmvStart == DateTime.GameTime then
				Media.DisplayMessage(UserInterface.Translate("deactivate-four-missiles"), UserInterface.Translate("landcom-16-capitalized"))
			end
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(9), function()
		for i, PID in pairs (CoopPlayers) do
		CaptureFCom = AddPrimaryObjective(PID, "capture-enemy-command-center")
		end
		DateTime.TimeLimit = TimerTicks
		Media.PlaySpeechNotification(All, "TimerStarted")
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(ApproachBase)
		end
	end)

	Trigger.OnCapture(CommandCenter, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(CaptureFCom)
		end
	end)

	Paradrop()
	Trigger.AfterDelay(DateTime.Minutes(2), SendParabombs)
end

SilosDamaged = function()
	if not MissilesLaunched then
		LaunchMissiles()
	end
end

Tick = function()
	USSR.Cash = 50000
	BadGuy.Cash = 50000

	GoodGuySpread()
	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(15) then
		USSR.MarkCompletedObjective(HoldOut)
	end
	end
end


GoodGuySpread  = function()
	P1Units = GoodGuy.GetGroundAttackers()
	if #P1Units > 0 then
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
	end
end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("mcv_land.vqa")
end

WorldLoaded = function()
	BadGuy = Player.GetPlayer("BadGuy")
	Greece = Player.GetPlayer("Greece")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Neutral = Player.GetPlayer("Neutral")
	USSR = Player.GetPlayer("USSR")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	
	Media.PlayMovieFullscreen("ally10.vqa",PlayOpening)
	
	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	
	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2, ExtraGemMine3, ExtraGemMine4}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end
	
		EnemyUnits = BadGuy.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = BadGuy })
	CopyUnit.Scatter()
	end
	end

	InitObjectives(Greece)

	HoldOut = AddPrimaryObjective(USSR, "")
	for i, PID in pairs (CoopPlayers) do
	ApproachBase = AddPrimaryObjective(PID, "disable-atomic-weapons")
	end

	Camera.Position = DefaultCameraPosition.CenterPosition
	StandardDrop = Actor.Create("paradrop", false, { Owner = USSR })
	MissionStart()
	MissionTriggers()
	ActivateAI()
	OnAnyDamaged(MissileSilos, SilosDamaged)
end
