--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

LstReinforcements =
{
	actors = { "mcv" },
	entryPath = { AlliedMCVEntry.Location, Unload1.Location },
	exitPath = { AlliedMCVEntry.Location }
}

ExtractionHelicopterType = "tran.extraction"
ExtractionPath = { HeliWP01.Location, HeliWP02.Location, HeliWP03.Location }
Dog5PatrolPath = { WP94.Location, WP93.Location }
Dog6PatrolPath = { WP90.Location, WP91.Location, WP92.Location, WP91.Location }
TankGroup10 = { TankGroup101, TankGroup102 }
TankGroup10PatrolPath = { WP81.Location, WP82.Location, WP83.Location, WP84.Location, WP85.Location, WP84.Location, WP83.Location, WP82.Location }
HuntDogsGroup = { Dog701, Dog702, Dog703, Dog704, Dog705, Dog706 }

KosyginType = "gnrl"
KosyginContacted = false

InitialAlliedReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Reinforcements.ReinforceWithTransport(Greece, "lst.reinforcement", LstReinforcements.actors, LstReinforcements.entryPath, LstReinforcements.exitPath)
		FillLander()
	end)
	

end

FillLander = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Lander = Greece.GetActorsByType("lst.reinforcement")
		for i, PID in pairs (CoopPlayers) do
		if PID ~= Greece then
	    ExtraMCV = Actor.Create("mcv", false, { Owner = PID })    
		Lander[1].LoadPassenger(ExtraMCV)
		end
		end
	end)
end

RescueFailed = function()
	Media.PlaySpeechNotification(All, "ObjectiveNotMet")
	for i, PID in pairs (CoopPlayers) do
	PID.MarkFailedObjective(KosyginSurviveObjective)
	end
end

InitialSovietPatrols = function()
	Dog5.Patrol(Dog5PatrolPath, true, DateTime.Seconds(60))
	Dog6.Patrol(Dog6PatrolPath, true, DateTime.Seconds(90))
	for i = 1, 2 do
		TankGroup10[i].Patrol(TankGroup10PatrolPath, true, DateTime.Seconds(30))
	end
end

CreateKosygin = function()
	for i, PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(UseSpyObjective)
	end
	Media.PlaySpeechNotification(All, "ObjectiveMet")
	local kosygin = Actor.Create(KosyginType, true, { Location = KosyginSpawnPoint.Location, Owner = Greece })
	Trigger.OnKilled(kosygin, RescueFailed)
	for i, PID in pairs (CoopPlayers) do
	ExtractObjective = AddPrimaryObjective(PID, "extract-kosygin")
	end
	Trigger.AfterDelay(DateTime.Seconds(1), function() Media.PlaySpeechNotification(All, "TargetFreed") end)
end

DogsGuardGates = function()
	if not Dog707.IsDead then
		Dog707.AttackMove(WP89.Location)
	end
	if not Dog708.IsDead then
		Dog708.AttackMove(WP81.Location)
	end
	if not Dog709.IsDead then
		Dog709.AttackMove(WP79.Location)
	end
end

InfiltrateForwardCenter = function()
	Trigger.OnInfiltrated(USSRFC, function()
		if not KosyginContacted then
			KosyginContacted = true
			CreateKosygin()
			DogsGuardGates()
		end
	end)

	Trigger.OnKilledOrCaptured(USSRFC, function()
		if not Greece.IsObjectiveCompleted(UseSpyObjective) then
			for i, PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(UseSpyObjective)
			end
		end
	end)
end

Tick = function()
	USSR.Cash = 5000
	for i, PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() and DateTime.GameTime > DateTime.Seconds(15) then
		USSR.MarkCompletedObjective(USSRObj)
	end
	end
end

TriggerHuntKosygin = function()
	Trigger.OnEnteredProximityTrigger(WP79.CenterPosition, WDist.FromCells(4), function(actor, triggerflee)
		if actor.Type == KosyginType then
			Trigger.RemoveProximityTrigger(triggerflee)
			for i = 1, 6 do
				if not HuntDogsGroup[i].IsDead then
					HuntDogsGroup[i].Attack(actor)
				end
			end
		end
	end)
	Trigger.OnEnteredProximityTrigger(WP81.CenterPosition, WDist.FromCells(4), function(actor, triggerflee)
		if actor.Type == KosyginType then
			Trigger.RemoveProximityTrigger(triggerflee)
			for i = 1, 6 do
				if not HuntDogsGroup[i].IsDead then
					HuntDogsGroup[i].Attack(actor)
				end
			end
		end
	end)
	Trigger.OnEnteredProximityTrigger(WP89.CenterPosition, WDist.FromCells(4), function(actor, triggerflee)
		if actor.Type == KosyginType then
			Trigger.RemoveProximityTrigger(triggerflee)
			for i = 1, 6 do
				if not HuntDogsGroup[i].IsDead then
					HuntDogsGroup[i].Attack(actor)
				end
			end
		end
	end)
end

TriggerRevealUSSRBase = function()
	Trigger.OnEnteredProximityTrigger(LowerBaseWP.CenterPosition, WDist.FromCells(10), function(a, id)
		if a.Owner == Greece then
			Trigger.RemoveProximityTrigger(id)
			local cam = Actor.Create("Camera", true, { Owner = Greece, Location = RevealLowerBase.Location })
			Trigger.AfterDelay(DateTime.Seconds(15), cam.Destroy)
		end
	end)
end

TriggerRevealUSSRFC = function()
	Trigger.OnEnteredProximityTrigger(UpperBaseWP.CenterPosition, WDist.FromCells(10), function(a, id)
		if a.Owner == Greece then
			Trigger.RemoveProximityTrigger(id)
			local cam = Actor.Create("Camera", true, { Owner = Greece, Location = KosyginSpawnPoint.Location })
			Trigger.AfterDelay(DateTime.Seconds(15), cam.Destroy)
		end
	end)
end

TriggerExtractKosygin = function()
	Trigger.OnEnteredProximityTrigger(KosyginExtractPoint.CenterPosition, WDist.FromCells(10), function(actor, triggerflee)
		if actor.Type == KosyginType then
			Reinforcements.ReinforceWithTransport(Greece, ExtractionHelicopterType, nil, ExtractionPath)
			Trigger.RemoveProximityTrigger(triggerflee)
			Trigger.AfterDelay(DateTime.Seconds(10), function()
				for i, PID in pairs (CoopPlayers) do
				PID.MarkCompletedObjective(KosyginSurviveObjective)
				PID.MarkCompletedObjective(ExtractObjective)
				end
				Media.PlaySpeechNotification(All, "ObjectiveMet")
			end)
		end
	end)
end

GreeceSpread  = function()
	P1Units = Greece.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "pt" and UID.Type ~= "lst.reinforcement" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
	end
end
end

PlayOpening = function()
Media.PlayMovieInRadar("spy.vqa")
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	GoodGuy = Player.GetPlayer("GoodGuy")
	Neutral = Player.GetPlayer("Neutral")
	USSR = Player.GetPlayer("USSR")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")

	
	Media.PlayMovieFullscreen("ally9.vqa",PlayOpening)
	
	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	CoopCurrent = 1
	GreeceSpread()
	
	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4, ExtraMine5, ExtraMine6}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end
	
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end
	
	
	Camera.Position = DefaultCameraPosition.CenterPosition
	InitObjectives(Greece)
	for i, PID in pairs (CoopPlayers) do
	UseSpyObjective = AddPrimaryObjective(PID, "infiltrate-soviet-command-center-contact-kosygin")
	KosyginSurviveObjective = AddPrimaryObjective(PID, "kosygin-must-survive")
	end
	USSRObj = AddPrimaryObjective(USSR, "")
	InitialAlliedReinforcements()
	InfiltrateForwardCenter()
	InitialSovietPatrols()
	TriggerRevealUSSRBase()
	TriggerRevealUSSRFC()
	TriggerExtractKosygin()
	TriggerHuntKosygin()
	ActivateAI()
end
