--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

if Difficulty == "easy" then
	TanyaType = "e7"
	ReinforceCash = 5000
	HoldAITime = DateTime.Minutes(3)
	SpecialCameras = true
elseif Difficulty == "normal" then
	TanyaType = "e7.noautotarget"
	ReinforceCash = 2250
	HoldAITime = DateTime.Minutes(2)
	SpecialCameras = true
else
	TanyaType = "e7.noautotarget"
	ReinforceCash = 1500
	HoldAITime = DateTime.Minutes(1) + DateTime.Seconds(30)
	SendWaterTransports = true
end

SpyUnits = {}
ReinAreSpread = "NotDone"
TanyasEscaped = 0
EnteredPrison = false
SpyType = { }
SpyEntryPath = { SpyEntry.Location, SpyLoadout.Location }
InsertionTransport = "lst.in"
ExtractionTransport = "lst"
TrukPath = { TrukWaypoint1, TrukWaypoint2, TrukWaypoint3, TrukWaypoint4, TrukWaypoint5, TrukWaypoint6 }
ExtractionHeliType = "tran"
InsertionHeliType = "tran.in"
ExtractionPath = { ExtractionEntry.Location, ExtractionLZ.Location }
HeliReinforcements = { "medi", "mech", "mech" }

GreeceReinforcements =
{
	{ types = { "2tnk", "2tnk", "2tnk", "arty", "arty" }, entry = { SpyEntry.Location, SpyLoadout.Location } },
	{ types = { "e3", "e3", "e3", "e6", "e6" }, entry = { SpyEntry.Location, GreeceLoadout1.Location } },
	{ types = { "jeep", "jeep", "e1", "e1", "2tnk" }, entry = { SpyEntry.Location, GreeceLoadout2.Location } }
}

DogPatrol = { Dog1, Dog2 }
PatrolA = { PatrolA1, PatrolA2, PatrolA3, PatrolA4, PatrolA5 }
PatrolB = { PatrolB1, PatrolB2, PatrolB3 }

DogPatrolPath = { DogPatrolRally1.Location, DogPatrolRally2.Location, DogPatrolRally3.Location }
PatrolAPath = { PatrolRally.Location, PatrolARally1.Location, PatrolARally2.Location, PatrolARally3.Location }
PatrolBPath = { PatrolBRally1.Location, PatrolBRally2.Location, PatrolBRally3.Location, PatrolRally.Location }

TanyaVoices = { "tuffguy", "bombit", "laugh", "gotit", "lefty", "keepem" }
SpyVoice = "sking"
SamSites = { Sam1, Sam2, Sam3, Sam4 }

GroupPatrol = function(units, waypoints, delay)
	local i = 1
	local stop = false

	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end

			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)

				if bool then
					stop = true

					i = i + 1
					if i > #waypoints then
						i = 1
					end

					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i])
			end
		end)
	end)
end

Tick = function()
	if FollowTruk and not Truk.IsDead then
		Camera.Position = Truk.CenterPosition
	end

	if USSR.HasNoRequiredUnits() then
		if not Greece.IsObjectiveCompleted(KillAll) and Difficulty == "tough" then
			SendWaterExtraction()
		end
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillAll)
		end
	end
	
	for i,PID in pairs (CoopPlayers) do
	if GreeceReinforcementsArrived and PID.HasNoRequiredUnits() and ReinAreSpread == "Done" then
		USSR.MarkCompletedObjective(USSRobjective)
	end
	end

	if USSR.Resources >= USSR.ResourceCapacity * 0.75 then
		USSR.Cash = USSR.Cash + USSR.Resources - USSR.ResourceCapacity * 0.25
		USSR.Resources = USSR.ResourceCapacity * 0.25
	end
end

SendReinforcements = function()
	GreeceReinforcementsArrived = true
	Camera.Position = ReinforceCamera.CenterPosition
	for i,PID in pairs (CoopPlayers) do
		PID.Cash = PID.Cash + ReinforceCash
	end
	

	Utils.Do(GreeceReinforcements, function(reinforcements)
		Reinforcements.ReinforceWithTransport(Greece, InsertionTransport, reinforcements.types, reinforcements.entry, { SpyEntry.Location })
	end)

	Media.PlaySpeechNotification(All, "AlliedReinforcementsArrived")
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		ReinSpread()
	end)
	
	ActivateAI()
end

ExtractUnits = function(extractionUnit, pos, after)
	if extractionUnit.IsDead or not extractionUnit.HasPassengers then
		return
	end

	extractionUnit.Move(pos)
	extractionUnit.Destroy()

	Trigger.OnRemovedFromWorld(extractionUnit, after)
end

SendWaterExtraction = function()
	local flare = Actor.Create("flare", true, { Owner = Greece, Location = SpyEntryPath[2] + CVec.New(2, 0) })
	Trigger.AfterDelay(DateTime.Seconds(5), flare.Destroy)
	Media.PlaySpeechNotification(All, "SignalFlareNorth")
	Camera.Position = flare.CenterPosition

	WaterExtractionTran = Reinforcements.ReinforceWithTransport(Greece, ExtractionTransport, nil, SpyEntryPath)[1]
	for i,PID in pairs (CoopPlayers) do
	ExtractObjective = AddPrimaryObjective(PID, "extract-transport")
	end
	
	Trigger.OnKilled(WaterExtractionTran, function() USSR.MarkCompletedObjective(USSRobjective) end)
	Trigger.OnAllRemovedFromWorld(Greece.GetGroundAttackers(), function()
		ExtractUnits(WaterExtractionTran, SpyEntryPath[1], function()
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(ExtractObjective)
			PID.MarkCompletedObjective(TanyaSurviveObjective)
			end
		end)
	end)
end

WarfactoryInfiltrated = function()
	SpyCleanup()

	FollowTruk = true
	Truk.GrantCondition("hijacked")

	Truk.Wait(DateTime.Seconds(1))
	Utils.Do(TrukPath, function(waypoint)
		Truk.Move(waypoint.Location)
	end)

	if SpecialCameras then
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			SpyCameraA.Destroy()
			SpyCameraB.Destroy()
		end)
	end
end

MissInfiltrated = function()		
	for i = 0, 5, 1 do
		local sound = Utils.Random(TanyaVoices)
		Trigger.AfterDelay(DateTime.Seconds(i), function()
			Media.PlaySoundNotification(All, sound)
		end)
	end
	Prison.Attack(Prison)

	Trigger.AfterDelay(DateTime.Seconds(6), FreeTanya)
end

FreeTanya = function()
	Prison.Stop()
	for i,PID in pairs (CoopPlayers) do
	Tanya = Actor.Create(TanyaType, true, { Owner = Greece, Location = Prison.Location + CVec.New(1, 1) })
	Tanya.Demolish(Prison)
	Tanya.Move(Tanya.Location + CVec.New(Utils.RandomInteger(-1, 2), 1))
	end
	Trigger.AfterDelay(DateTime.Seconds(1), function()
	TanyaSpread()
	end)
	

	if TanyaType == "e7.noautotarget" then
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.DisplayMessage(UserInterface.Translate("tanya-rules-of-engagement"), UserInterface.Translate("tanya"))
		end)
	end

	

	if Difficulty == "tough" then
		for i,PID in pairs (CoopPlayers) do
		KillSams = AddPrimaryObjective(PID, "destroy-sam-sites-blocker")

		PID.MarkCompletedObjective(RescueTanyaObjective)
		TanyaSurviveObjective = AddPrimaryObjective(PID, "tanya-survive")
		end
		Media.PlaySpeechNotification(All, "TanyaRescued")
	else
		for i,PID in pairs (CoopPlayers) do
		KillSams = AddPrimaryObjective(PID, "destroy-sam-sites-blocker")
		end
		Media.PlaySpeechNotification(All, "TargetFreed")
	end

	if not SpecialCameras and PrisonCamera and PrisonCamera.IsInWorld then
		PrisonCamera.Destroy()
	end
end

SpySpread  = function()
	SpyUnits = Greece.GetActorsByType("spy")
for _, UID in ipairs(SpyUnits) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end
Trigger.OnAnyKilled(SpyUnits, function() USSR.MarkCompletedObjective(USSRobjective) end)
end

TanyaSpread  = function()
	TanyaUnits = Greece.GetActorsByType(TanyaType)
for _, UID in ipairs(TanyaUnits) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end
	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end
	Trigger.OnAnyKilled(TanyaUnits, function()
	if TanyasEscaped ~= #CoopPlayers then
	USSR.MarkCompletedObjective(USSRobjective)
	end
	end)
end

ReinSpread  = function()
	P1Units = Greece.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end
	P1Engineers = Greece.GetActorsByType("e6")
for _, UID in ipairs(P1Engineers) do
    for i,PID in pairs (CoopPlayers) do
		if PID ~= Greece then
		CopyUnit = Actor.Create(UID.Type, true, { Location = UID.Location, Owner = PID })
		CopyUnit.Scatter()
		end
    end
end
	
ReinAreSpread = "Done"
end

SendSpy = function()
	Camera.Position = SpyEntry.CenterPosition
	Spy = Reinforcements.ReinforceWithTransport(Greece, InsertionTransport, SpyType, SpyEntryPath, { SpyEntryPath[1]} )[2][1]

	if SpecialCameras then
		SpyCameraA = Actor.Create("camera", true, { Owner = Greece, Location = SpyCamera1.Location })
		SpyCameraB = Actor.Create("camera", true, { Owner = Greece, Location = SpyCamera2.Location })
	end

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		SpySpread()
		Media.DisplayMessage(UserInterface.Translate("disguise-spy"), "Spy")
	end)
end

ActivatePatrols = function()
	GroupPatrol(DogPatrol, DogPatrolPath, DateTime.Seconds(2))

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		GroupPatrol(PatrolA, PatrolAPath, DateTime.Seconds(7))
		GroupPatrol(PatrolB, PatrolBPath, DateTime.Seconds(6))
	end)
end

SpyCleanup = function()
	for i,SpyID in pairs (SpyUnits) do
		SpyID.Destroy()
	end
end

InitTriggers = function()
	Trigger.OnInfiltrated(Warfactory, function()
		if Greece.IsObjectiveCompleted(InfiltrateWarfactoryObjective) then
			return
		elseif Truk.IsDead then
			if not Greece.IsObjectiveCompleted(RescueTanyaObjective) then
				USSR.MarkCompletedObjective(USSRobjective)
			end

			return
		end

		Trigger.ClearAll(Spy)
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(InfiltrateWarfactoryObjective)
		end
		WarfactoryInfiltrated()
	end)

	Trigger.OnKilled(Truk, function()
		if not Greece.IsObjectiveCompleted(InfiltrateWarfactoryObjective) then
			for i,PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(InfiltrateWarfactoryObjective)
			end
		elseif FollowTruk then
			USSR.MarkCompletedObjective(USSRobjective)
		end
	end)


	Trigger.OnInfiltrated(Prison, function()
	  	
		if Greece.IsObjectiveCompleted(RescueTanyaObjective) then
			return
		end

		if not Greece.IsObjectiveCompleted(InfiltrateWarfactoryObjective) then
			SpyCleanup()
			Media.DisplayMessage(UserInterface.Translate("skip-heroics"), UserInterface.Translate("battlefield-control"))
			for i,PID in pairs (CoopPlayers) do
			PID.MarkCompletedObjective(InfiltrateWarfactoryObjective)
			end
		end

		if not PrisonCamera then
			if SpecialCameras then
				PrisonCamera = Actor.Create("camera", true, { Owner = Greece, Location = TrukWaypoint5.Location })
			else
				PrisonCamera = Actor.Create("camera.small", true, { Owner = Greece, Location = Prison.Location + CVec.New(1, 1) })
			end
		end

		if SpecialCameras and SpyCameraA and not SpyCameraA.IsDead then
			SpyCameraA.Destroy()
			SpyCameraB.Destroy()
		end

		Trigger.ClearAll(Spy)
		
		Trigger.AfterDelay(DateTime.Seconds(2), MissInfiltrated)
	end)

	Trigger.OnEnteredFootprint({ TrukWaypoint5.Location }, function(a, id)
		if a == Truk then
			Trigger.RemoveFootprintTrigger(id)

			Spy = Actor.Create("spy", true, { Owner = Greece, Location = TrukWaypoint5.Location })
			Spy.DisguiseAsType("e1", USSR)
			Spy.Move(SpyWaypoint.Location)
			Spy.Infiltrate(Prison)

			Media.PlaySoundNotification(All, SpyVoice)

			FollowTruk = false

			if SpecialCameras then
				PrisonCamera = Actor.Create("camera", true, { Owner = Greece, Location = TrukWaypoint5.Location })
			else
				PrisonCamera = Actor.Create("camera.small", true, { Owner = Greece, Location = Prison.Location + CVec.New(1, 1) })
			end

			Trigger.OnKilled(Spy, function() USSR.MarkCompletedObjective(USSRobjective) end)
		end
	end)

	Trigger.OnEnteredFootprint({ TrukWaypoint6.Location }, function(a, id)
		if a == Truk then
			Trigger.RemoveFootprintTrigger(id)
			Truk.Stop()
			Truk.Kill()
			ExplosiveBarrel.Kill()
		end
	end)

	if Difficulty ~= "tough" then
		Trigger.OnKilled(Mammoth, function()
			Trigger.AfterDelay(HoldAITime - DateTime.Seconds(45), function() HoldProduction = false end)
			Trigger.AfterDelay(HoldAITime, function() Attacking = true end)
		end)
	end

	Trigger.OnKilled(FlameBarrel, function()
		if not FlameTower.IsDead then
			FlameTower.Kill()
		end
	end)

	Trigger.OnKilled(SamBarrel, function()
		if not Sam1.IsDead then
			Sam1.Kill()
		end
	end)

	Trigger.OnAllKilled(SamSites, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(KillSams)
		end

		local flare = Actor.Create("flare", true, { Owner = Greece, Location = ExtractionPath[2] + CVec.New(0, -1) })
		Trigger.AfterDelay(DateTime.Seconds(7), flare.Destroy)
		Media.PlaySpeechNotification(All, "SignalFlare")

		if Difficulty == "tough" then
			Reinforcements.ReinforceWithTransport(Greece, InsertionHeliType, HeliReinforcements, ExtractionPath, { ExtractionPath[1] })
			if not Harvester.IsDead then
				Harvester.FindResources()
			end

		else
			ExtractionHeli = Reinforcements.ReinforceWithTransport(Greece, ExtractionHeliType, nil, ExtractionPath)[1]
			exitPos = CPos.New(ExtractionPath[1].X, ExtractionPath[2].Y)

			Trigger.OnKilled(ExtractionHeli, function() USSR.MarkCompletedObjective(USSRobjective) end)
			
			for i,TID in pairs (TanyaUnits) do
			Trigger.OnRemovedFromWorld(TID, function()
			TanyasEscaped = TanyasEscaped + 1
			TanyasReady()
			end)
			end
				
	end
end)
end

TanyasReady = function()
if TanyasEscaped == #CoopPlayers then
					for i,PID in pairs (CoopPlayers) do
					PID.MarkCompletedObjective(RescueTanyaObjective)
					end
				ExtractUnits(ExtractionHeli, exitPos, function()

					Media.PlaySpeechNotification(All, "TanyaRescued")
					Trigger.AfterDelay(DateTime.Seconds(2), function()
						SendReinforcements()
					end)

					if PrisonCamera and PrisonCamera.IsInWorld then
						PrisonCamera.Destroy()
					end
				end)
				end
end

AddObjectives = function()
	USSRobjective = AddPrimaryObjective(USSR, "")
	for i,PID in pairs (CoopPlayers) do
	RescueTanyaObjective = AddPrimaryObjective(PID, "rescue-tanya")
	KillAll = AddPrimaryObjective(PID, "elminate-soviet-units")
	InfiltrateWarfactoryObjective = AddSecondaryObjective(PID, "infiltrate-warfactory")
	end
end

PlayOpening = function()
Media.PlayMovieFullscreen("tanya1.vqa")
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	Media.PlayMovieFullscreen("ally5.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

	GotYard = "No"
	Conyards = USSR.GetActorsByType("fact")
	for i,CoID in pairs (Conyards) do
		Trigger.OnCapture(CoID, function()
			if GotYard == "No" then
				GotYard = "Yes"
				CoID.Owner = Greece
				for c,PID in pairs (CoopPlayers) do
					if PID ~= Greece then
						local ConName = "conyard_" .. c
						ConName = Actor.Create(CoID.Type, true, { Location = CoID.Location + CVec.New((1*c), 1), Owner = USSR })
						Trigger.AfterDelay(DateTime.Seconds(4), function()
							ConName.Owner = PID
							ConName.Deploy()
						end)
					end
				end
			end
		end)
	end

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	for i,PID in pairs (CoopPlayers) do
	table.insert(SpyType, "spy")
	end
	
	CoopCurrent = 1
	


	InitObjectives(Greece)
	AddObjectives()
	InitTriggers()
	SendSpy()

	Trigger.AfterDelay(DateTime.Seconds(3), ActivatePatrols)
end
