--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
DestroySubPensTriggerActivator = { Spen1, Spen2, Spen3, Spen4, Spen5 }
ClearSubActivityTriggerActivator = { Sub1, Sub2, Sub3, Sub4, Sub5, Sub6, Sub7, Sub8, Sub9, Sub10, Sub11, Sub12, Sub13, Sub14, Sub15, Sub16, Sub17 }
AlliedGunboats = { "pt", "pt", "pt" }
BeachRifles = { BeachRifle1, BeachRifle2, BeachRifle3, BeachRifle4 }

LstReinforcements =
{
	first =
	{
		actors = { "mcv", "jeep", "2tnk", "2tnk" },
		entryPath = { AlliedMCVEntry.Location, Unload1.Location },
		exitPath = { AlliedMCVEntry.Location }
	},
	second =
	{
		actors = { "jeep", "2tnk", "e1", "e1", "e1" },
		entryPath = { AlliedMCVEntry.Location, Unload1.Location },
		exitPath = { AlliedMCVEntry.Location }
	}
}

if Difficulty == "easy" then
	ActivateAIDelay = DateTime.Minutes(1)
else
	ActivateAIDelay = DateTime.Seconds(30)
end

RaidingParty = { "3tnk", "3tnk", "v2rl", "e1", "e2"}
BaseRaidDelay1 = { DateTime.Minutes(1), DateTime.Minutes(2) }
BaseRaidDelay2 = { DateTime.Minutes(3), DateTime.Minutes(4) }
RaidOnePath = { RaidOneEntry.Location, RaidOneLanding.Location }
RaidTwoPath = { RaidTwoEntry.Location, RaidTwoLanding.Location }

StartTimer = false
TimerColor = Player.GetPlayer("USSR").Color
TimerTicks = DateTime.Minutes(10)
Ticked = TimerTicks
StartTimerDelay = DateTime.Minutes(5)

InitialAlliedReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Reinforcements.Reinforce(GoodGuy, AlliedGunboats, { GunboatEntry.Location, waypoint42.Location }, 2,GoodSpread)
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		local reinforcement = LstReinforcements.first
		Reinforcements.ReinforceWithTransport(Greece, "lst.reinforcement", reinforcement.actors, reinforcement.entryPath, reinforcement.exitPath)
	end)
Trigger.AfterDelay(DateTime.Seconds(3), function()
GreeceSpread()
end)
end

GreeceSpread  = function()
Trigger.AfterDelay(DateTime.Seconds(5), function()
	P1Units = Greece.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "pt" and UID.Type ~= "lst.reinforcement" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
	end
end
	P1Units = England.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end

HostMCV = Greece.GetActorsByType("mcv")
for i, PID in pairs (CoopPlayers) do
if PID ~= Greece then
MCVs = PID.GetActorsByType("mcv")
for m, MID in ipairs(MCVs) do
--MID.Teleport(Unload1.Location+CVec.New(m,0))
--MID.Scatter()
NewMCV = Actor.Create("mcv", true, { Location = HostMCV[1].Location, Owner = PID })
NewMCV.Scatter()
MID.Destroy()
end
end
end
end)
end

BeachRunners = function()
	Trigger.AfterDelay(DateTime.Seconds(7), function()
		Utils.Do(BeachRifles, function(actor)
			actor.Move(BeachRifleDestination.Location)
		end)
	end)
end

SecondAlliedLanding = function()
	Trigger.AfterDelay(DateTime.Minutes(1), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		local reinforcement = LstReinforcements.second
		Reinforcements.ReinforceWithTransport(GoodGuy, "lst.reinforcement", reinforcement.actors, reinforcement.entryPath, reinforcement.exitPath)
	end)
end

SetSecondLanding = function()
SecondLanding = true
end

CaptureRadarDome = function()
	Trigger.OnKilled(RadarDome, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CaptureRadarDomeObj)
		end
	end)

	Trigger.OnCapture(RadarDome, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(CaptureRadarDomeObj)
		end
		BaseRaids()
	end)
end

BaseRaids = function()
	if Difficulty == "easy" then
		return
	else
		Trigger.AfterDelay(Utils.RandomInteger(BaseRaidDelay1[1], BaseRaidDelay1[2]), function()
			local raiders = Reinforcements.ReinforceWithTransport(USSR, "lst", RaidingParty, RaidOnePath, { RaidOneEntry.Location })[2]
			Utils.Do(raiders, function(a)
				Trigger.OnAddedToWorld(a, function()
					a.AttackMove(PlayerBase.Location)
					IdleHunt(a)
				end)
			end)
		end)

		Trigger.AfterDelay(Utils.RandomInteger(BaseRaidDelay2[1], BaseRaidDelay2[2]), function()
			local raiders = Reinforcements.ReinforceWithTransport(USSR, "lst", RaidingParty, RaidTwoPath, { RaidTwoEntry.Location })[2]
			Utils.Do(raiders, function(a)
				Trigger.OnAddedToWorld(a, function()
					a.AttackMove(PlayerBase.Location)
					IdleHunt(a)
				end)
			end)
		end)
	end
end

StartTimerFunction = function()
	if Difficulty == "hard" then
		StartTimer = true
		Media.PlaySpeechNotification(All, "TimerStarted")
	end
end

EnemyApproaching = UserInterface.Translate("enemy-approaching")
FinishTimer = function()
	for i = 0, 5, 1 do
		local c = TimerColor
		if i % 2 == 0 then
			c = HSLColor.White
		end

		Trigger.AfterDelay(DateTime.Seconds(i), function() UserInterface.SetMissionText(EnemyApproaching, c) end)
	end
	Trigger.AfterDelay(DateTime.Seconds(6), function() UserInterface.SetMissionText("") end)
end

BattalionWays =
{
	{ HardEntry1.Location, HardLanding1.Location },
	{ HardEntry2.Location, HardLanding2.Location },
	{ HardEntry3.Location, HardLanding3.Location },
	{ HardEntry4.Location, HardLanding4.Location },
	{ HardEntry5.Location, HardLanding5.Location },
	{ HardEntry6.Location, HardLanding6.Location }
}

SendArmoredBattalion = function()
	Media.PlaySpeechNotification(All, "EnemyUnitsApproaching")
	Utils.Do(BattalionWays, function(way)
		local units = { "3tnk", "3tnk", "3tnk", "4tnk", "4tnk" }
		local armor = Reinforcements.ReinforceWithTransport(USSR, "lst", units , way, { way[2], way[1] })[2]
		Utils.Do(armor, function(a)
			Trigger.OnAddedToWorld(a, function()
				a.AttackMove(PlayerBase.Location)
				IdleHunt(a)
			end)
		end)
	end)
end

DestroySubPensCompleted = function()
	for i, PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(DestroySubPens)
	end
end

ClearSubActivityCompleted = function()
	for i, PID in pairs (CoopPlayers) do
	PID.MarkCompletedObjective(ClearSubActivity)
	end
end

Tick = function()
	USSR.Cash = 5000
	BadGuy.Cash = 500

	GoodLandSpread()
	
	if StartTimer then
		if Ticked > 0 then
			if (Ticked % DateTime.Seconds(1)) == 0 then
				Timer = UserInterface.Translate("soviet-armored-battalion-arrives-in", { ["time"] = Utils.FormatTime(Ticked) })
				UserInterface.SetMissionText(Timer, TimerColor)
			end
			Ticked = Ticked - 1
		elseif Ticked == 0 then
			FinishTimer()
			SendArmoredBattalion()
			Ticked = Ticked - 1
		end
	end

for i, PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(15) and PID.HasNoRequiredUnits() then
		USSR.MarkCompletedObjective(BeatAllies)
	end
end
end

GoodSpread  = function()
	P1Units = GoodGuy.GetActors()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end
end

GoodLandSpread  = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
	if UID.Type ~= "pt" and UID.Type ~= "lst.reinforcement" then
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
	end
end
end


WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	BadGuy = Player.GetPlayer("BadGuy")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")
	GoodGuy = Player.GetPlayer("GoodGuy")
	England = Player.GetPlayer("England")

	Media.PlayMovieInRadar("shorbom1.vqa")

	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end

ConstructionVehicleReinforcements = { "mcv" }
ConstructionVehiclePath = { OOB.Location+CVec.New (-20,0), OOB.Location+CVec.New (-20,0) }
for i, PID in pairs (CoopPlayers) do
if i ~= 1 then
ExtraMCVName = "EMCV_" .. i
ExtraMCVName = Reinforcements.Reinforce(PID, ConstructionVehicleReinforcements, ConstructionVehiclePath)
end
end

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraGemMines = {ExtraGemMine1, ExtraGemMine2}
	for i,MID in pairs (ExtraGemMines) do
	AddMine = Actor.Create("gmine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end
	
	EnemyUnits = BadGuy.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = BadGuy })
	CopyUnit.Scatter()
	end
	end
	
	CoopCurrent = 1
	
	P1Units = Greece.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end

SecondLanding = false
	Camera.Position = DefaultCameraPosition.CenterPosition

	InitObjectives(Greece)
	
	for i, PID in pairs (CoopPlayers) do
	CaptureRadarDomeObj = AddPrimaryObjective(PID, "capture-radar-dome")
	DestroySubPens = AddPrimaryObjective(PID, "destroy-all-soviet-sub-pens")
	ClearSubActivity = AddSecondaryObjective(PID, "clear-area-all-subs")
	end
	BeatAllies = AddPrimaryObjective(USSR, "")
	
	PowerProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = USSR })

	InitialAlliedReinforcements()
	SecondAlliedLanding()
	BeachRunners()
	CaptureRadarDome()
	Trigger.AfterDelay(ActivateAIDelay, ActivateAI)
	Trigger.AfterDelay(StartTimerDelay, StartTimerFunction)

	Trigger.OnAllKilledOrCaptured(DestroySubPensTriggerActivator, DestroySubPensCompleted)
	Trigger.OnAllRemovedFromWorld(ClearSubActivityTriggerActivator, ClearSubActivityCompleted)
end
