--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
ConstructionVehicleReinforcements = { "mcv" }
ConstructionVehiclePath = { ReinforcementsEntryPoint.Location, DeployPoint.Location }

JeepReinforcements = { "e1", "e1", "e1", "jeep" }
JeepPath = { ReinforcementsEntryPoint.Location, ReinforcementsRallyPoint.Location }

TruckReinforcements = { "truk", "truk", "truk" }
TruckPath = { TruckEntryPoint.Location, TruckRallyPoint.Location }

PathGuards = { PathGuard1, PathGuard2, PathGuard3, PathGuard4, PathGuard5, PathGuard6, PathGuard7, PathGuard8, PathGuard9, PathGuard10, PathGuard11, PathGuard12, PathGuard13, PathGuard14, PathGuard15 }

SovietBase = { SovietConyard, SovietRefinery, SovietPower1, SovietPower2, SovietSilo, SovietKennel, SovietBarracks, SovietWarfactory }

IdlingUnits = { }

if Difficulty == "easy" then
	DateTime.TimeLimit = DateTime.Minutes(10) + DateTime.Seconds(3)

elseif Difficulty == "normal" then
	DateTime.TimeLimit = DateTime.Minutes(5) + DateTime.Seconds(3)
	InfantryTypes = { "e1", "e1", "e1", "e2", "e2", "e1" }
	InfantryDelay = DateTime.Seconds(18)
	AttackGroupSize = 5

elseif Difficulty == "hard" then
	DateTime.TimeLimit = DateTime.Minutes(3) + DateTime.Seconds(3)
	InfantryTypes = { "e1", "e1", "e1", "e2", "e2", "e1" }
	InfantryDelay = DateTime.Seconds(10)
	VehicleTypes = { "ftrk" }
	VehicleDelay = DateTime.Seconds(30)
	AttackGroupSize = 7

else
	DateTime.TimeLimit = DateTime.Minutes(1) + DateTime.Seconds(3)
	ConstructionVehicleReinforcements = { "jeep" }

	InfantryTypes = { "e1", "e1", "e1", "e2", "e2", "dog", "dog" }
	InfantryDelay = DateTime.Seconds(10)
	VehicleTypes = { "ftrk" }
	VehicleDelay = DateTime.Minutes(1) + DateTime.Seconds(10)
	AttackGroupSize = 5
end

SendJeepReinforcements = function()
	Media.PlaySpeechNotification(All, "ReinforcementsArrived")
	Reinforcements.Reinforce(Neutral, JeepReinforcements, JeepPath, DateTime.Seconds(1),CoopSpreader)
end

RunInitialActivities = function()
	Harvester.FindResources()
	Trigger.OnKilled(Harvester, function() HarvesterKilled = true end)

	Trigger.OnAllKilled(PathGuards, function()
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(SecureObjective)
		end
		SendTrucks()
	end)

	Trigger.OnAllKilled(SovietBase, function()
		Utils.Do(USSR.GetGroundAttackers(), function(unit)
			if not Utils.Any(PathGuards, function(pg) return pg == unit end) then
				Trigger.OnIdle(unit, unit.Hunt)
			end
		end)
	end)

	if InfantryTypes then
		Trigger.AfterDelay(InfantryDelay, ProduceInfantry)
	end

	if VehicleTypes then
		Trigger.AfterDelay(VehicleDelay, ProduceVehicles)
	end
end

ProductionMultiplier = function(unit)
	for m=1,EProMultiplier do
	CopyUnit = Actor.Create(LastBuiltUnit.Type, true, { Location = LastBuiltUnit.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
end

ProduceInfantry = function()
	if SovietBarracks.IsDead then
		return
	end

	local toBuild = { Utils.Random(InfantryTypes) }

	if SovietKennel.IsDead and toBuild == "dog" then
		toBuild = { "e1" }
	end

	USSR.Build(toBuild, function(unit)

		LastBuiltUnit = unit[1]
		ProductionMultiplier()

		IdlingUnits[#IdlingUnits + 1] = unit[1]
		Trigger.AfterDelay(InfantryDelay, ProduceInfantry)

		if #IdlingUnits >= (AttackGroupSize * 1.5) then
			SendAttack()
		end
	end)
end

ProduceVehicles = function()
	if SovietWarfactory.IsDead then
		return
	end

	if HarvesterKilled then
		USSR.Build({ "harv" }, function(harv)
			harv[1].FindResources()
			Trigger.OnKilled(harv[1], function() HarvesterKilled = true end)

			HarvesterKilled = false
			ProduceVehicles()
		end)
		return
	end

	local toBuild = { Utils.Random(VehicleTypes) }
	USSR.Build(toBuild, function(unit)

		LastBuiltUnit = unit[1]
		ProductionMultiplier()

		IdlingUnits[#IdlingUnits + 1] = unit[1]
		Trigger.AfterDelay(VehicleDelay, ProduceVehicles)

		if #IdlingUnits >= (AttackGroupSize * 1.5) then
			SendAttack()
		end
	end)
end

SendAttack = function()
	local units = { }

	for i = 0, AttackGroupSize, 1 do
		local number = Utils.RandomInteger(1, #IdlingUnits)

		if IdlingUnits[number] and not IdlingUnits[number].IsDead then
			units[i] = IdlingUnits[number]
			table.remove(IdlingUnits, number)
		end
	end

	Utils.Do(units, function(unit)
		if Difficulty ~= "tough" then
			unit.AttackMove(DeployPoint.Location)
		end
		Trigger.OnIdle(unit, unit.Hunt)
	end)
end

Tick = function()
	USSR.Resources = USSR.Resources - (0.01 * USSR.ResourceCapacity / 25)

	if USSR.HasNoRequiredUnits() then
		for i,PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(ConquestObjective)
		end
	end
	if DateTime.GameTime > 6 then
	for i,PID in pairs (CoopPlayers) do
	if PID.HasNoRequiredUnits() then
		USSR.MarkCompletedObjective(USSRobjective)
	end
	end
	end
end

FinishTimer = function()
	DateTime.TimeLimit = 0
	for i = 0, 5, 1 do
		local c = TimerColor
		if i % 2 == 0 then
			c = HSLColor.White
		end

		Trigger.AfterDelay(DateTime.Seconds(i), function()
			UserInterface.SetMissionText(UserInterface.Translate("convoy-arrived"), c)
		end)
	end
	Trigger.AfterDelay(DateTime.Seconds(6), function() UserInterface.SetMissionText("") end)
end

ConvoyOnSite = false
SendTrucks = function()
	if not ConvoyOnSite then
		ConvoyOnSite = true

		DateTime.TimeLimit = 0
		UserInterface.SetMissionText("")
		for i,PID in pairs (CoopPlayers) do
		ConvoyObjective = AddPrimaryObjective(PID, "escort-convoy")
		end
		Media.PlaySpeechNotification(All, "ConvoyApproaching")
		Trigger.AfterDelay(DateTime.Seconds(3), function()
			ConvoyUnharmed = true
			local trucks = Reinforcements.Reinforce(England, TruckReinforcements, TruckPath, DateTime.Seconds(1),
				function(truck)
					Trigger.OnIdle(truck, function() truck.Move(TruckExitPoint.Location) end)
				end)
			local count = 0
			Trigger.OnEnteredFootprint( { TruckExitPoint.Location }, function(a, id)
				if a.Owner == England then
					count = count + 1
					a.Destroy()
					if count == 3 then
						for i,PID in pairs (CoopPlayers) do
						PID.MarkCompletedObjective(ConvoyObjective)
						end
						Trigger.RemoveFootprintTrigger(id)
					end
				end
			end)
			Trigger.OnAnyKilled(trucks, ConvoyCasualites)
		end)
	end
end

ConvoyCasualites = function()
	Media.PlaySpeechNotification(All, "ConvoyUnitLost")
	if ConvoyUnharmed then
		for i,PID in pairs (CoopPlayers) do
			ConvoyUnharmed = false
			Trigger.AfterDelay(DateTime.Seconds(1), function() PID.MarkFailedObjective(ConvoyObjective) end)
		end
	end
end

PlayOpening = function()
Media.PlayMovieInRadar("mcv.vqa", PlayOpening2)
end

CoopSpreader = function()
	P1Units = Neutral.GetGroundAttackers()

for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	England = Player.GetPlayer("England")
	USSR = Player.GetPlayer("USSR")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")

	Media.PlayMovieFullscreen("ally2.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end
 	
	
	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end

	P1Units = Greece.GetGroundAttackers()
	CoopCurrent = 1

for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end

	InitObjectives(Greece)

	USSRobjective = AddPrimaryObjective(USSR, "")

	for i,PID in pairs (CoopPlayers) do
	SecureObjective = AddPrimaryObjective(PID, "secure-convoy")
	ConquestObjective = AddPrimaryObjective(PID, "eliminate-soviets")
	end

	Trigger.AfterDelay(DateTime.Seconds(1), function() Media.PlaySpeechNotification(All, "MissionTimerInitialised") end)

	RunInitialActivities()

	for i,PID in pairs (CoopPlayers) do
	Reinforcements.Reinforce(PID, ConstructionVehicleReinforcements, ConstructionVehiclePath)
	end
	Trigger.AfterDelay(DateTime.Seconds(5), SendJeepReinforcements)
	Trigger.AfterDelay(DateTime.Seconds(10), SendJeepReinforcements)

	Trigger.OnTimerExpired(function()
		FinishTimer()
		SendTrucks()
	end)

	Camera.Position = ReinforcementsEntryPoint.CenterPosition
	TimerColor = Greece.Color
end
