--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
AlliedReinforcementsA = { "e1", "e1", "e1", "e1", "e1" }
AlliedReinforcementsB = { "e3", "e3", "e3", "e3", "e3" }
BadGuys = { BadGuy1, BadGuy2, BadGuy3 }

SovietDogPatrols =
{
	{ Patrol_1_e1, Patrol_1_dog },
	{ Patrol_2_e1, Patrol_2_dog },
	{ Patrol_3_e1, Patrol_3_dog },
	{ Patrol_4_e1, Patrol_4_dog }
}

SovietDogPatrolPaths =
{
	{ Patrol6.Location, Patrol7.Location, Patrol8.Location, Patrol1.Location, Patrol2.Location, Patrol3.Location, Patrol4.Location, Patrol5.Location },
	{ Patrol8.Location, Patrol1.Location, Patrol2.Location, Patrol3.Location, Patrol4.Location, Patrol5.Location, Patrol6.Location, Patrol7.Location },
	{ Patrol1.Location, Patrol2.Location, Patrol3.Location, Patrol4.Location, Patrol5.Location, Patrol6.Location, Patrol7.Location, Patrol8.Location },
	{ Patrol2.Location, Patrol3.Location, Patrol4.Location, Patrol5.Location, Patrol6.Location, Patrol7.Location, Patrol8.Location, Patrol1.Location }
}

Mammoths = { Mammoth1, Mammoth2, Mammoth3 }

SovietMammothPaths =
{
	{ TnkPatrol1.Location, TnkPatrol2.Location,TnkPatrol3.Location, TnkPatrol4.Location, TnkPatrol5.Location, TnkPatrol6.Location, TnkPatrol7.Location, TnkPatrol8.Location },
	{ TnkPatrol5.Location, TnkPatrol6.Location, TnkPatrol7.Location, TnkPatrol8.Location,  TnkPatrol1.Location, TnkPatrol2.Location, TnkPatrol3.Location, TnkPatrol4.Location },
	{ TnkPatrol8.Location, TnkPatrol1.Location, TnkPatrol2.Location, TnkPatrol3.Location, TnkPatrol4.Location, TnkPatrol5.Location,  TnkPatrol6.Location, TnkPatrol7.Location }
}

SovietSubPath = { SubPatrol3_1.Location, SubPatrol3_2.Location, SubPatrol3_3.Location }

ParadropWaypoints =
{
	easy = { UnitBStopLocation },
	normal = { UnitBStopLocation, UnitAStopLocation },
	hard = { UnitBStopLocation, MCVStopLocation, UnitAStopLocation }
}

SovietTechLabs = { TechLab1, TechLab2, TechLab3 }

GroupPatrol = function(units, waypoints, delay)
	local i = 1
	local stop = false

	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end
			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)
				if bool then
					stop = true
					i = i + 1
					if i > #waypoints then
						i = 1
					end
					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i])
			end
		end)
	end)
end

InitialSovietPatrols = function()
	-- Dog Patrols
	for i = 1, 4 do
		GroupPatrol(SovietDogPatrols[i], SovietDogPatrolPaths[i], DateTime.Seconds(5))
	end

	-- Mammoth Patrols
	for i = 1, 3 do
		Trigger.AfterDelay(DateTime.Seconds(6 * (i - 1)), function()
			Trigger.OnIdle(Mammoths[i], function()
				Mammoths[i].Patrol(SovietMammothPaths[i])
			end)
		end)
	end

	-- Sub Patrols
	Patrol1Sub.Patrol({ SubPatrol1_1.Location, SubPatrol1_2.Location })
	Patrol2Sub.Patrol({ SubPatrol2_1.Location, SubPatrol2_2.Location })
	Patrol3Sub1.Patrol(SovietSubPath)
	Patrol3Sub2.Patrol(SovietSubPath)
end

InitialAlliedReinforcements = function()
	local camera = Actor.Create("Camera", true, { Owner = Greece, Location = DefaultCameraPosition.Location })
	Trigger.AfterDelay(DateTime.Seconds(30), camera.Destroy)

	Reinforcements.Reinforce(GoodGuy, AlliedReinforcementsA, { AlliedEntry1.Location, UnitBStopLocation.Location }, 2,GoodSpread)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Reinforcements.Reinforce(GoodGuy, AlliedReinforcementsB, { AlliedEntry2.Location, UnitAStopLocation.Location }, 2,GoodSpread)
	end)
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Reinforcements.Reinforce(Greece, { "mcv" }, { AlliedEntry3.Location, MCVStopLocation.Location })
	end)
end

CaptureRadarDome = function()
	Trigger.OnKilled(RadarDome, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(CaptureRadarDomeObj)
		end
	end)

	Trigger.OnCapture(RadarDome, function()
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(CaptureRadarDomeObj)
		end
		
		Utils.Do(SovietTechLabs, function(a)
			if a.IsDead then
				return
			end

			Beacon.New(Greece, a.CenterPosition)
			if Difficulty ~= "hard" then
				Actor.Create("TECH.CAM", true, { Owner = Greece, Location = a.Location + CVec.New(1, 1) })
			end
		end)

		Media.DisplayMessage(UserInterface.Translate("soviet-tech-centers-discovered"))

		if Difficulty == "easy" then
			Actor.Create("Camera", true, { Owner = Greece, Location = Weapcam.Location })
		end
	end)
end

InfiltrateTechCenter = function()
	Utils.Do(SovietTechLabs, function(a)
		Trigger.OnInfiltrated(a, function()
			if Infiltrated then
				return
			end
			Infiltrated = true
			for i, PID in pairs (CoopPlayers) do
			DestroySovietsObj = AddPrimaryObjective(PID, "destroy-soviet-buildings-units")
			PID.MarkCompletedObjective(InfiltrateTechCenterObj)
			end
			
			local Proxy = Actor.Create("powerproxy.paratroopers", false, { Owner = USSR })
			Utils.Do(ParadropWaypoints[Difficulty], function(waypoint)
				Proxy.TargetParatroopers(waypoint.CenterPosition, Angle.South)
			end)
			Proxy.Destroy()
		end)

		Trigger.OnCapture(a, function()
			if not Infiltrated then
				Media.DisplayMessage(UserInterface.Translate("dont-capture-tech-centers"))
			end
		end)
	end)

	Trigger.OnAllKilledOrCaptured(SovietTechLabs, function()
		if not Greece.IsObjectiveCompleted(InfiltrateTechCenterObj) then
			for i, PID in pairs (CoopPlayers) do
			PID.MarkFailedObjective(InfiltrateTechCenterObj)
			end
		end
	end)
end

Tick = function()
	for i, PID in pairs (CoopPlayers) do
	if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkFailedObjective(InfiltrateTechCenterObj)
		end
	end
	end

	if DestroySovietsObj and USSR.HasNoRequiredUnits() then
		for i, PID in pairs (CoopPlayers) do
		PID.MarkCompletedObjective(DestroySovietsObj)
		end
	end
end

PlayOpening = function()
Media.PlayMovieInRadar("mcv.vqa")
end

GoodSpread  = function()
	P1Units = GoodGuy.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Multi4 = Player.GetPlayer("Multi4")
	Multi5 = Player.GetPlayer("Multi5")
	Neutral = Player.GetPlayer("Neutral")
	GoodGuy = Player.GetPlayer("GoodGuy")

	Media.PlayMovieFullscreen("ally6.vqa", PlayOpening)

	CoopPlayers = {};
	table.insert(CoopPlayers, Greece)
	if Multi1 ~= nil then
	table.insert(CoopPlayers, Multi1)
	end
	if Multi2 ~= nil then
	table.insert(CoopPlayers, Multi2)
	end
	if Multi3 ~= nil then
	table.insert(CoopPlayers, Multi3)
	end
	if Multi4 ~= nil then
	table.insert(CoopPlayers, Multi4)
	end
	if Multi5 ~= nil then
	table.insert(CoopPlayers, Multi5)
	end


	ConstructionVehicleReinforcements = { "mcv" }
	ConstructionVehiclePath = { AlliedEntry3.Location, MCVStopLocation.Location }
	for i, PID in pairs (CoopPlayers) do
	if i ~= 1 then
	Reinforcements.Reinforce(PID, ConstructionVehicleReinforcements, ConstructionVehiclePath)
	end
	end

	if Map.LobbyOption("oremines") == "oreon"  then
	ExtraMines = {ExtraMine1, ExtraMine2, ExtraMine3, ExtraMine4}
	for i,MID in pairs (ExtraMines) do
	AddMine = Actor.Create("mine", true, { Location = MID.Location, Owner = Neutral })
	end
	ExtraDiamondMines = {ExtraDiamondMine1}
	for i,DMID in pairs (ExtraDiamondMines) do
	AddMine = Actor.Create("gmine", true, { Location = DMID.Location, Owner = Neutral })
	end
	end

	EnemyMultiplier = Map.LobbyOption("enmp")
	if Map.LobbyOption("enmp") == "enmppc"  then
	EnemyMultiplier = #CoopPlayers-1
	end
	
	EProMultiplier = Map.LobbyOption("prmp")
	if Map.LobbyOption("prmp") == "prmppc"  then
	EProMultiplier = #CoopPlayers-1
	end

	EnemyUnits = USSR.GetGroundAttackers()
	for m=1,EnemyMultiplier do
	for i,EID in pairs (EnemyUnits) do
	CopyUnit = Actor.Create(EID.Type, true, { Location = EID.Location, Owner = USSR })
	CopyUnit.Scatter()
	end
	end
	
	CoopCurrent = 1
	
	P1Units = Greece.GetGroundAttackers()
for _, UID in ipairs(P1Units) do
    CurrentPlayer = CoopPlayers[CoopCurrent]
    UID.Owner = CurrentPlayer
    CoopCurrent = CoopCurrent + 1
    if CoopCurrent > #CoopPlayers then
        CoopCurrent = 1
    end
end

	InitObjectives(Greece)

	for i, PID in pairs (CoopPlayers) do
	InfiltrateTechCenterObj = AddPrimaryObjective(PID, "infiltrate-tech-center-spy")
	CaptureRadarDomeObj = AddSecondaryObjective(PID, "capture-radar-shore")
	end
	
	Camera.Position = DefaultCameraPosition.CenterPosition

	Utils.Do(BadGuys, function(a)
		a.AttackMove(MCVStopLocation.Location)
	end)

	Trigger.AfterDelay(DateTime.Seconds(1), function()
		InitialAlliedReinforcements()
		InitialSovietPatrols()
	end)

	Trigger.OnEnteredProximityTrigger(SovietMiniBaseCam.CenterPosition, WDist.New(1024 * 6), function(a, id)
		for i, PID in pairs (CoopPlayers) do
		if a.Owner == PID then
			Trigger.RemoveProximityTrigger(id)
			local cam = Actor.Create("Camera", true, { Owner = Greece, Location = SovietMiniBaseCam.Location })
			Trigger.AfterDelay(DateTime.Seconds(15), cam.Destroy)
		end
		end
	end)

	CaptureRadarDome()
	InfiltrateTechCenter()
	Trigger.AfterDelay(0, ActivateAI)
end
