if Difficulty == "easy" then
	CommandoType = "rmbo.easy"
elseif Difficulty == "hard" then
	CommandoType = "rmbo.hard"
else
	CommandoType = "rmbo"
end
Commando = { CommandoType }

-------------------------------------------- Enemy Units --------------------------------------------

EnemyUnitType =
{
	hard = { { "e1" }, { "e1" }, { "e1" }, { "e1" }, { "e1" }, { "e1", "e1" }, { "e1", "e1" }, { "e2" }, { "e2" }, { "e2" }, { "e2" }, { "e1", "e2" }, { "e1", "e2" }, { "e3" }, { "e3" }, { "e3" }, { "e1", "e3" }, { "e1", "e3" }, { "e4" }, { "e4" }, { "e1", "e4" }, { "e1", "e4" }, { "e5" }, { "e1", "e5" }, { "e1", "e5" }, { "mtnk" }, { "e1", "mtnk" }, { "e1", "mtnk" } },
	normal = { { "e1" }, { "e1" }, { "e1" }, { "e1" }, { "e1" }, { "e1", "e1" }, { "e2" }, { "e2" }, { "e2" }, { "e2" }, { "e1", "e2" }, { "e3" }, { "e3" }, { "e3" }, { "e1", "e3" }, { "e4" }, { "e4" }, { "e1", "e4" }, { "e5" }, { "e1", "e5" }, { "mtnk" }, { "e1", "mtnk" } },
	easy = { { "e1" }, { "e1" }, { "e1" }, { "e1" }, { "e1" }, { "e2" }, { "e2" }, { "e2" }, { "e2" }, { "e3" }, { "e3" }, { "e3" }, { "e4" }, { "e4" }, { "e5" }, { "mtnk" } }
}

AttackDelayMin =
{
	easy = DateTime.Seconds(5),
	normal = DateTime.Seconds(4),
	hard = DateTime.Seconds(3)
}

AttackDelayMax =
{
	easy = DateTime.Seconds(11),
	normal = DateTime.Seconds(10),
	hard = DateTime.Seconds(9)
}

EnemyUnits = function()

	local enemyspawn = Map.RandomEdgeCell()
	local enemyunit = Utils.Random(EnemyUnitType[Difficulty])

	local attackUnit = Reinforcements.Reinforce(GDI, enemyunit, { enemyspawn })

	Utils.Do(attackUnit, function(a)
		Trigger.OnAddedToWorld(a, function()
			IdleHunt(a)
		end)
	end)

	Trigger.AfterDelay(Utils.RandomInteger(AttackDelayMin[Difficulty], AttackDelayMax[Difficulty]), EnemyUnits)
end

----------------------------------------------- World -----------------------------------------------

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")

	InitObjectives(Nod)
	InitObjectives(GDI)

	GetFilthyRich = AddPrimaryObjective(Nod, "Get filthy rich")
	DestroyNod = AddPrimaryObjective(GDI, "")

	Camera.Position = CommandoSpawn.CenterPosition

	Reinforcements.Reinforce(Nod, Commando, { CommandoSpawn.Location, CommandoSpawn.Location })

	Actor.Create("airstrike.proxy", true, { Owner = Nod })

	EnemyUnits()

end

---------------------------------------------- The End ----------------------------------------------

Tick = function()
	if DateTime.GameTime > DateTime.Seconds(5) and Nod.Cash >= 10000 then
		Nod.MarkCompletedObjective(GetFilthyRich)
	end

	if DateTime.GameTime > DateTime.Seconds(5) and Nod.HasNoRequiredUnits() then
		GDI.MarkCompletedObjective(DestroyNod)
	end
end

