ChooseTEN1 =
{
	{ type = "tent", pos = CPos.New(128, 46), cost = 500 }
}

BuildTEN1 = function()
	if not CheckExistenceForFAC1() then
		Trigger.AfterDelay(DateTime.Seconds(1), BuildTEN1)
		return
	end

	for i,v in ipairs(ChooseTEN1) do
		if not v.exists then
			PlaceTEN1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildTEN1)
end

PlaceTEN1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			Trigger.AfterDelay(DateTime.Seconds(1), BuildTEN1)
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildTEN1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildTEN1)
	end)
end

CheckHealthForTEN1 = function()
	Trigger.OnDamaged(TEN1, function()
		if TEN1.Owner == Player1 and TEN1.Health < TEN1.MaxHealth * 3/4 then
			TEN1.StartBuildingRepairs()
		end
		if TEN1.Owner == Player1 and TEN1.Health < TEN1.MaxHealth * 1/4 then
			TEN1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(TEN1, BuildTEN1)
end