ChooseSPE1 =
{
	{ type = "spen", pos = CPos.New(42, 72), cost = 800 }
}

BuildSPE1 = function()
	if not CheckExistenceForFAC1() then
		Trigger.AfterDelay(DateTime.Seconds(1), BuildSPE1)
		return
	end

	for i,v in ipairs(ChooseSPE1) do
		if not v.exists then
			PlaceSPE1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildSPE1)
end

PlaceSPE1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			Trigger.AfterDelay(DateTime.Seconds(1), BuildSPE1)
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildSPE1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildSPE1)
	end)
end

CheckHealthForSPE1 = function()
	Trigger.OnDamaged(SPE1, function()
		if SPE1.Owner == Player1 and SPE1.Health < SPE1.MaxHealth * 3/4 then
			SPE1.StartBuildingRepairs()
		end
		if SPE1.Owner == Player1 and SPE1.Health < SPE1.MaxHealth * 1/4 then
			SPE1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(SPE1, BuildSPE1)
end