ChooseBAR1 =
{
	{ type = "barr", pos = CPos.New(117, 46), cost = 500 }
}

BuildBAR1 = function()
	if not CheckExistenceForFAC1() then
		Trigger.AfterDelay(DateTime.Seconds(1), BuildBAR1)
		return
	end

	for i,v in ipairs(ChooseBAR1) do
		if not v.exists then
			PlaceBAR1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildBAR1)
end

PlaceBAR1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForFAC1() then
			Trigger.AfterDelay(DateTime.Seconds(1), BuildBAR1)
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildBAR1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true

		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildBAR1)
	end)
end

CheckHealthForBAR1 = function()
	Trigger.OnDamaged(BAR1, function()
		if BAR1.Owner == Player1 and BAR1.Health < BAR1.MaxHealth * 3/4 then
			BAR1.StartBuildingRepairs()
		end
		if BAR1.Owner == Player1 and BAR1.Health < BAR1.MaxHealth * 1/4 then
			BAR1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(BAR1, BuildBAR1)
end