ChoosePRO2 =
{
	{ type = "proc", pos = CPos.New(60, 8), cost = 1400 }
}

BuildPRO2 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePRO2) do
		if not v.exists then
			PlacePRO2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPRO2)
end

PlacePRO2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPRO2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		CheckHealthForHarvesters()
		ConsiderProtectionForHarvesters()
		Trigger.AfterDelay(DateTime.Seconds(1), BuildPRO2)
	end)
end

CheckHealthForPRO2 = function()
	Trigger.OnDamaged(PRO2, function()
		if PRO2.Owner == Player1 and PRO2.Health < PRO2.MaxHealth * 3/4 then
			PRO2.StartBuildingRepairs()
		end
		if PRO2.Owner == Player1 and PRO2.Health < PRO2.MaxHealth * 1/4 then
			PRO2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(PRO2, BuildPRO2)
end