ChoosePRO1 =
{
	{ type = "proc", pos = CPos.New(75, 17), cost = 1400 }
}

BuildPRO1 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePRO1) do
		if not v.exists then
			PlacePRO1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPRO1)
end

PlacePRO1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPRO1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		CheckHealthForHarvesters()
		ConsiderProtectionForHarvesters()
		Trigger.AfterDelay(DateTime.Seconds(1), BuildPRO1)
	end)
end

CheckHealthForPRO1 = function()
	Trigger.OnDamaged(PRO1, function()
		if PRO1.Owner == Player1 and PRO1.Health < PRO1.MaxHealth * 3/4 then
			PRO1.StartBuildingRepairs()
		end
		if PRO1.Owner == Player1 and PRO1.Health < PRO1.MaxHealth * 1/4 then
			PRO1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(PRO1, BuildPRO1)
end