NormalUnitTypes =
{
	{ "1tnk.turkey", "1tnk.turkey", "1tnk.turkey", "1tnk.turkey", "1tnk.turkey" },
	{ "jeep.turkey", "jeep.turkey", "jeep.turkey", "jeep.turkey", "jeep.turkey" },
	{ "1tnk.turkey", "1tnk.turkey", "1tnk.turkey", "jeep.turkey", "jeep.turkey" },
	{ "e1", "e1", "e1", "e1", "e1" },
	{ "e3", "e3", "e3", "e3", "e3" }
}

HardUnitTypes =
{
	{ "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3" },
	{ "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey", "1tnk.turkey", "jeep.turkey" }
}

InfantryRallypoints = { InfantryRallypoint1, InfantryRallypoint2 }
VehicleRallypoints = { VehicleRallypoint1, VehicleRallypoint2, VehicleRallypoint3 }

CheckExistenceForSCY1 = function()
	ConYard = Map.ActorsInBox(MCVTopLeft.CenterPosition, MCVBottomRight.CenterPosition, function(actor)
		return actor.Type == "fact" and actor.Owner == Player1
	end)

	return #ConYard >= 1
end

CheckHealth = function()
	if Map.LobbyOption("difficulty") == "hard" or Map.LobbyOption("difficulty") == "normal" then
		CheckHealthForSCY1()
		CheckHealthForPOW1()
		CheckHealthForPOW2()
		CheckHealthForPOW3()
		CheckHealthForPOW4()
		CheckHealthForPOW5()
		CheckHealthForPOW6()
		CheckHealthForPOW7()
		CheckHealthForTEN1()
		CheckHealthForPBO1()
		CheckHealthForPBO2()
		CheckHealthForPBO3()
		CheckHealthForPBO4()
		CheckHealthForPBO5()
		CheckHealthForPBO6()
		CheckHealthForPBO7()
		CheckHealthForPBO8()
		CheckHealthForHBO1()
		CheckHealthForHBO2()
		CheckHealthForHBO3()
		CheckHealthForGUN1()
		CheckHealthForGUN2()
		CheckHealthForGUN3()
		CheckHealthForGUN4()
		CheckHealthForGUN5()
		CheckHealthForGUN6()
		CheckHealthForSYR1()
		CheckHealthForPRO1()
		CheckHealthForPRO2()
		CheckHealthForSIL1()
		CheckHealthForSIL2()
		CheckHealthForWEA1()
		CheckHealthForDOM1()
		CheckHealthForFIX1()
	end
end

CheckHealthForSCY1 = function()
	Trigger.OnDamaged(SCY1, function()
		if SCY1.Owner == Player1 and SCY1.Health < SCY1.MaxHealth * 3/4 then
			SCY1.StartBuildingRepairs()
		end
		if SCY1.Owner == Player1 and SCY1.Health < SCY1.MaxHealth * 1/4 then
			SCY1.Sell()
		end
	end)

	Trigger.OnRemovedFromWorld(SCY1, function()
		StopInfantryProduction()
		StopVehicleProduction()
		SetProductionDisabled()
	end)
end

StopInfantryProduction = function()
	if TENPDestroyed then
		return
	end

	TENP.Destroy()
	TENPDestroyed = true
end

StopVehicleProduction = function()
	if WEAPDestroyed then
		return
	end

	WEAP.Destroy()
	WEAPDestroyed = true
end

SetProductionDisabled = function()
	if AGUPDestroyed then
		return
	end

	AGUP.Destroy()
	AGUPDestroyed = true
end

ProduceArmy = function()
	if Map.LobbyOption("difficulty") == "normal" or Map.LobbyOption("difficulty") == "easy" then
		local toBuild = Utils.Random(NormalUnitTypes)
		Player1.Build( toBuild, function(units)
			CreateTeam(units)
		end)
	end
	if Map.LobbyOption("difficulty") == "hard" then
		local toBuild = Utils.Random(HardUnitTypes)
		Player1.Build( toBuild, function(units)
			CreateTeam(units)
		end)
	end
end

CreateTeam = function(units)
	Utils.Do(units, function(unit)
		SendAttack(unit)
	end)
end

SendAttack = function(unit)
	if not unit.IsDead then
		Trigger.OnIdle(unit, unit.Hunt) 
	end 
end

ControlInfantryRallypoints = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local TentFound = Player1.GetActorsByType("tent.turkey")

		Utils.Do(TentFound, function(unit)
			unit.RallyPoint = Utils.Random(InfantryRallypoints).Location
		end)
	end)
end

ControlVehicleRallypoints = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local WeapFound = Player1.GetActorsByType("weap.turkey")

		Utils.Do(WeapFound, function(unit)
			unit.RallyPoint = Utils.Random(VehicleRallypoints).Location
		end)
	end)
end

ShowMissionDetails = function()
	Media.DisplayMessage("There is an additional side ready for challenge.", "Battlefield Control")
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Besides other possible opponents also Turkey must be defeated in order to accomplish this mission.", "Battlefield Control")
	end)
end


CheckExistenceForInitialUnits = function()
	GuardExists = true
	Trigger.OnKilled(Guard, function() GuardExists = false end)
end


SendDefence = function()
	local defenders = Player1.GetGroundAttackers()
	if #defenders > 0 then
		Utils.Do(defenders, function(unit)
			unit.Hunt()

			if GuardExists then
				Guard.Stop()
			end
		end)
	end
end

ConsiderProtectionForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		DisableProtectionForHarvesters = false
		CheckHealthForHarvesters()
	end)
end

CheckHealthForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		Utils.Do(Harvester, function(unit)
			Trigger.OnDamaged(unit, function()
				if not DisableProtectionForHarvesters then
					SendDefence()
					DisableProtectionForHarvesters = true
				end
			end)
		end)
	end)
end

ConsiderHarvesterProduction = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		if #Harvester < 2 then
			Player1.Build({ "harv" }, function(harv)
				harv[1].FindResources()

				CheckHealthForHarvesters()
				ConsiderProtectionForHarvesters()
			end)
		end
	end)
end

WorldLoaded = function()
	Player1 = Player.GetPlayer("Turkey")
	Player1.Cash = 0

	Player2 = Player.GetPlayer("Multi0")
	Player3 = Player.GetPlayer("Multi1")
	Player4 = Player.GetPlayer("Multi2")
	Player5 = Player.GetPlayer("Multi3")

	ShowMissionDetails()
	CheckHealth()
	CheckExistenceForInitialUnits()
	CheckHealthForHarvesters()
	ConsiderProtectionForHarvesters()
end

Tick = function()
	if DateTime.GameTime % 100 == 0 then
		ControlInfantryRallypoints()
		ControlVehicleRallypoints()

		ProduceArmy()
		ConsiderHarvesterProduction()
	end
end