ChooseWEA1 =
{
	{ type = "weap.turkey", pos = CPos.New(89, 10), cost = 500 }
}

BuildWEA1 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChooseWEA1) do
		if not v.exists then
			PlaceWEA1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildWEA1)
end

PlaceWEA1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildWEA1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildWEA1)
	end)
end

CheckHealthForWEA1 = function()
	Trigger.OnDamaged(WEA1, function()
		if WEA1.Owner == Player1 and WEA1.Health < WEA1.MaxHealth * 3/4 then
			WEA1.StartBuildingRepairs()
		end
		if WEA1.Owner == Player1 and WEA1.Health < WEA1.MaxHealth * 1/4 then
			WEA1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(WEA1, BuildWEA1)
end