ChooseSIL2 =
{
	{ type = "silo", pos = CPos.New(62, 8), cost = 150 }
}

BuildSIL2 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChooseSIL2) do
		if not v.exists then
			PlaceSIL2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildSIL2)
end

PlaceSIL2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildSIL2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildSIL2)
	end)
end

CheckHealthForSIL2 = function()
	Trigger.OnDamaged(SIL2, function()
		if SIL2.Owner == Player1 and SIL2.Health < SIL2.MaxHealth * 3/4 then
			SIL2.StartBuildingRepairs()
		end
		if SIL2.Owner == Player1 and SIL2.Health < SIL2.MaxHealth * 1/4 then
			SIL2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(SIL2, BuildSIL2)
end