--------------------
-- Power Plant 1  --
--------------------

ChoosePOW1 =
{
	{ type = "powr", pos = CPos.New(88, 22), cost = 300 }
}

BuildPOW1 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW1) do
		if not v.exists then
			PlacePOW1(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW1)
end

PlacePOW1 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW1)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW1) 
	end)
end

CheckHealthForPOW1 = function()
	Trigger.OnDamaged(POW1, function()
		if POW1.Owner == Player1 and POW1.Health < POW1.MaxHealth * 3/4 then
			POW1.StartBuildingRepairs()
		end
		if POW1.Owner == Player1 and POW1.Health < POW1.MaxHealth * 1/4 then
			POW1.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW1, BuildPOW1)
end

--------------------
-- Power Plant 2  --
--------------------

ChoosePOW2 =
{
	{ type = "powr", pos = CPos.New(42, 18), cost = 300 }
}

BuildPOW2 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW2) do
		if not v.exists then
			PlacePOW2(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW2)
end

PlacePOW2 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW2)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPOW2)
	end)
end

CheckHealthForPOW2 = function()
	Trigger.OnDamaged(POW2, function()
		if POW2.Owner == Player1 and POW2.Health < POW2.MaxHealth * 3/4 then
			POW2.StartBuildingRepairs()
		end
		if POW2.Owner == Player1 and POW2.Health < POW2.MaxHealth * 1/4 then
			POW2.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW2, BuildPOW2)
end

--------------------
-- Power Plant 3  --
--------------------

ChoosePOW3 =
{
	{ type = "powr", pos = CPos.New(81, 16), cost = 300 }
}

BuildPOW3 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW3) do
		if not v.exists then
			PlacePOW3(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW3)
end

PlacePOW3 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW3)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW3) 
	end)
end

CheckHealthForPOW3 = function()
	Trigger.OnDamaged(POW3, function()
		if POW3.Owner == Player1 and POW3.Health < POW3.MaxHealth * 3/4 then
			POW3.StartBuildingRepairs()
		end
		if POW3.Owner == Player1 and POW3.Health < POW3.MaxHealth * 1/4 then
			POW3.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW3, BuildPOW3)
end

--------------------
-- Power Plant 4  --
--------------------

ChoosePOW4 =
{
	{ type = "powr", pos = CPos.New(78, 12), cost = 300 }
}

BuildPOW4 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW4) do
		if not v.exists then
			PlacePOW4(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW4)
end

PlacePOW4 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW4)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPOW4)
	end)
end

CheckHealthForPOW4 = function()
	Trigger.OnDamaged(POW4, function()
		if POW4.Owner == Player1 and POW4.Health < POW4.MaxHealth * 3/4 then
			POW4.StartBuildingRepairs()
		end
		if POW4.Owner == Player1 and POW4.Health < POW4.MaxHealth * 1/4 then
			POW4.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW4, BuildPOW4)
end

--------------------
-- Power Plant 5  --
--------------------

ChoosePOW5 =
{
	{ type = "powr", pos = CPos.New(55, 11), cost = 300 }
}

BuildPOW5 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW5) do
		if not v.exists then
			PlacePOW5(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW5)
end

PlacePOW5 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW5)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW5) 
	end)
end

CheckHealthForPOW5 = function()
	Trigger.OnDamaged(POW5, function()
		if POW5.Owner == Player1 and POW5.Health < POW5.MaxHealth * 3/4 then
			POW5.StartBuildingRepairs()
		end
		if POW5.Owner == Player1 and POW5.Health < POW5.MaxHealth * 1/4 then
			POW5.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW5, BuildPOW5)
end

--------------------
-- Power Plant 6  --
--------------------

ChoosePOW6 =
{
	{ type = "powr", pos = CPos.New(82, 4), cost = 300 }
}

BuildPOW6 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW6) do
		if not v.exists then
			PlacePOW6(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW6)
end

PlacePOW6 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW6)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPOW6)
	end)
end

CheckHealthForPOW6 = function()
	Trigger.OnDamaged(POW6, function()
		if POW6.Owner == Player1 and POW6.Health < POW6.MaxHealth * 3/4 then
			POW6.StartBuildingRepairs()
		end
		if POW6.Owner == Player1 and POW6.Health < POW6.MaxHealth * 1/4 then
			POW6.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW6, BuildPOW6)
end

--------------------
-- Power Plant 7  --
--------------------

ChoosePOW7 =
{
	{ type = "powr", pos = CPos.New(46, 4), cost = 300 }
}

BuildPOW7 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePOW7) do
		if not v.exists then
			PlacePOW7(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPOW7)
end

PlacePOW7 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW7)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1),BuildPOW7) 
	end)
end

CheckHealthForPOW7 = function()
	Trigger.OnDamaged(POW7, function()
		if POW7.Owner == Player1 and POW7.Health < POW7.MaxHealth * 3/4 then
			POW7.StartBuildingRepairs()
		end
		if POW7.Owner == Player1 and POW7.Health < POW7.MaxHealth * 1/4 then
			POW7.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(POW7, BuildPOW7)
end