ChoosePBO3 =
{
	{ type = "pbox", pos = CPos.New(36, 91), cost = 600 }
}

BuildPBO3 = function()
	if not CheckExistenceForSCY1() then
		return
	end

	for i,v in ipairs(ChoosePBO3) do
		if not v.exists then
			PlacePBO3(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildPBO3)
end

PlacePBO3 = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type), function()
		if not CheckExistenceForSCY1() then
			return
		elseif Player1.Resources <= 299 then
			Trigger.AfterDelay(DateTime.Seconds(1),BuildPBO3)
			return
		end

		local actor = Actor.Create(building.type, true, { Owner = Player1, Location = building.pos })
		Player1.Cash = Player1.Cash - building.cost

		building.exists = true
		Trigger.OnRemovedFromWorld(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == Player1 and building.Health < building.MaxHealth * 3/4 then
				building.StartBuildingRepairs()
			end
			if building.Owner == Player1 and building.Health < building.MaxHealth * 1/4 then
				building.Sell()
			end

			SendDefence()
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildPBO3)
	end)
end

CheckHealthForPBO3 = function()
	Trigger.OnDamaged(PBO3, function()
		if PBO3.Owner == Player1 and PBO3.Health < PBO3.MaxHealth * 3/4 then
			PBO3.StartBuildingRepairs()
		end
		if PBO3.Owner == Player1 and PBO3.Health < PBO3.MaxHealth * 1/4 then
			PBO3.Sell()
		end

		SendDefence()
	end)

	Trigger.OnRemovedFromWorld(PBO3, BuildPBO3)
end