Commando = { "rmbo" }
GDIBase = { NUK201, NUK202, PYLE01, MISS01, EYE01 }
Patrol01Squad = { Patrol01_01, Patrol01_02, Patrol01_03 }
Patrol02Squad = { Patrol02_01, Patrol02_02, Patrol02_03 }
Patrol03Squad = { Patrol03_01, Patrol03_02, Patrol03_03 }
Patrol04Squad = { Patrol04_01, Patrol04_02, Patrol04_03 }
Patrol05Squad = { Patrol05_01, Patrol05_02, Patrol05_03 }
Patrol06Squad = { Patrol06_01, Patrol06_02, Patrol06_03 }
Patrol01Route = { Patrol01WP01.Location, Patrol01WP02.Location, Patrol01WP03.Location, Patrol01WP04.Location, Patrol01WP03.Location, Patrol01WP02.Location, }
Patrol02Route = { Patrol02WP01.Location, Patrol02WP02.Location, Patrol02WP03.Location, Patrol02WP04.Location, Patrol02WP03.Location, }
Patrol03Route = { Patrol03WP01.Location, Patrol03WP02.Location, Patrol03WP03.Location, Patrol03WP04.Location, Patrol03WP03.Location, Patrol03WP02.Location, }
Patrol04Route = { Patrol04WP01.Location, Patrol04WP02.Location, Patrol04WP03.Location, Patrol04WP02.Location, }
Patrol05Route = { Patrol05WP01.Location, Patrol05WP02.Location, Patrol05WP03.Location, Patrol05WP04.Location, Patrol05WP03.Location, Patrol05WP02.Location, }
Patrol06Route = { Patrol06WP01.Location, Patrol06WP02.Location, Patrol06WP03.Location, Patrol06WP02.Location, }
Ambush00Squad = { Ambush00_01 }
Ambush01Squad = { Ambush01_01, Ambush01_02, Ambush01_03, Ambush01_04 }
Ambush02Squad = { Ambush02_01, Ambush02_02, Ambush02_03 }
Ambush03Squad = { Ambush03_01, Ambush03_02, Ambush03_03 }
Ambush04Squad = { Ambush04_01, Ambush04_02, Ambush04_03 }
Ambush05Squad = { Ambush05_01, Ambush05_02, Ambush05_03, Ambush05_04, Ambush05_05, Ambush05_06, Ambush05_07 }
Ambush06Squad = { Ambush06_01, Ambush06_02 }
AmbushSquads01 = { Ambush01_01, Ambush01_02, Ambush01_03, Ambush01_04, Ambush02_01, Ambush02_02, Ambush02_03, Ambush03_01, Ambush03_02, Ambush03_03, Ambush04_01, Ambush04_02, Ambush04_03 }

------------------------------------------- Reinforcements ------------------------------------------

Reinforcement = function()
	Trigger.OnAllKilled(AmbushSquads01, function()
		Media.PlaySpeechNotification(Nod, "Reinforce")
		Reinforcements.ReinforceWithTransport(Nod, 'apc.nogun', { 'e6', 'e6', 'e6', 'e6' }, { UnitsStart.Location, UnitsEnd.Location, UnitsRally.Location })
	end)
end

------------------------------------------- Patrol Squads -------------------------------------------

Patrol = function()
	Utils.Do(Patrol01Squad, function(unit)
		unit.Patrol(Patrol01Route, true, 75)
	end)
	Trigger.OnAnyKilled(Patrol01Squad, function()
		Utils.Do(Patrol01Squad, IdleHunt)
	end)
	Utils.Do(Patrol02Squad, function(unit)
		unit.Patrol(Patrol02Route, true, 75)
	end)
	Trigger.OnAnyKilled(Patrol02Squad, function()
		Utils.Do(Patrol02Squad, IdleHunt)
	end)
	Utils.Do(Patrol03Squad, function(unit)
		unit.Patrol(Patrol03Route, true, 75)
	end)
	Trigger.OnAnyKilled(Patrol03Squad, function()
		Utils.Do(Patrol03Squad, IdleHunt)
	end)
	Utils.Do(Patrol04Squad, function(unit)
		unit.Patrol(Patrol04Route, true, 75)
	end)
	Trigger.OnAnyKilled(Patrol04Squad, function()
		Utils.Do(Patrol04Squad, IdleHunt)
	end)
	Utils.Do(Patrol05Squad, function(unit)
		unit.Patrol(Patrol05Route, true, 75)
	end)
	Trigger.OnAnyKilled(Patrol05Squad, function()
		Utils.Do(Patrol05Squad, IdleHunt)
	end)
	Utils.Do(Patrol06Squad, function(unit)
		unit.Patrol(Patrol06Route, true, 75)
	end)
	Trigger.OnAnyKilled(Patrol06Squad, function()
		Utils.Do(Patrol06Squad, IdleHunt)
	end)
end

------------------------------------------- Ambush Squads -------------------------------------------

Ambush = function()
	Trigger.OnEnteredProximityTrigger(Ambush01Trigger01.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush01Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush01Trigger02.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush01Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush02Trigger.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush02Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush03Trigger.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush03Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush04Trigger.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush04Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush05Trigger.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush05Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush06Trigger01.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush06Squad, IdleHunt)
		end
	end)
	Trigger.OnEnteredProximityTrigger(Ambush06Trigger02.CenterPosition, WDist.New(1024 * 3), function(actor, id)
		if actor.Owner == Nod and actor.Type ~= "waypoint" then
			Trigger.RemoveProximityTrigger(id)
			Utils.Do(Ambush06Squad, IdleHunt)
		end
	end)
end

----------------------------------------------- World -----------------------------------------------

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")

	InitObjectives(Nod)

	DestroyGDIBase = AddPrimaryObjective(Nod, "Destroy the GDI Base")

	RepairNamedActors(GDI, 0.9)

	Camera.Position = UnitsEnd.CenterPosition

	Media.PlaySpeechNotification(Nod, "Reinforce")
	Reinforcements.Reinforce(Nod, Commando, { UnitsStart.Location, UnitsEnd.Location })

	Reinforcement()
	Patrol()
	Ambush()
end

----------------------------------------- Lose Game if all dead -------------------------------------

Tick = function()
	if GDI.HasNoRequiredUnits() then
		Nod.MarkCompletedObjective(DestroyGDIBase)
	end

	if DateTime.GameTime > DateTime.Seconds(5) and Nod.HasNoRequiredUnits() then
		Nod.MarkFailedObjective(DestroyGDIBase)
	end
end

