-- The players.
Players = {}
-- The start waypoints for each player.
Entries = {}
-- The flag for each player (this keeps them alive).
Flags = {}
-- Locations to spawn the flags for each player.
Waypoints = {}
-- The team lives.
Lives = {}

FlagsTypes = {
	america = "causfgl",
	england = "caukfgl",
	france = "cafrfgl",
	germany = "cagefgl",
	korea = "caskfgl",
	japan = "cajpfgl",
	belarus = "cablfgl",
	poland = "capofgl",
	ukraine = "cauafgl",
	aussie = "caaufgl",
	china = "cachfgl",
	turkey = "catrfgl",
	canada = "cacnfgl",
	russia = "carufgl",
	iraq = "cairfgl",
	vietnam = "cavnfgl",
	cuba = "cacufgl",
	libya = "calbfgl",
	chile = "caclfgl",
	mexico = "camxfgl",
	mongolia = "camofgl",
	psicorps = "capcfgl",
	psinepal = "caplfgl",
	psitrans = "captfgl",
	psisouth = "capsfgl",
	psimoon = "capmfgl",
	transcaucus = "catcfgl",
	turkmen = "catmfgl",
	tuva = "catvfgl",
	russianfed = "carffgl",
	serbia = "casmfgl"
}

TeamId = function(playerId)
    return 1 + ((playerId - 1 - ((playerId - 1) % 4)) / 4)
end

BuildPlayerUnit = function(playerId, unit)
    local teamId = TeamId(playerId)
    if Lives[teamId] > 0 then
        Actor.Create(unit, true, { Owner = Players[playerId], Location = Entries[playerId].Location })
    end
end

SendUnits = function(playerId)
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        -- Replace destroyed V2s if lives remaining.
        local teamId = TeamId(playerId)
        -- Expect actors for spawn, flag and ???
        if #(Players[playerId].GetActors()) <= 2 then
            if Lives[teamId] > 0 then
                BuildPlayerUnit(playerId, "m3")
                Lives[teamId] = Lives[teamId] - 1
                Media.DisplayMessage("Team " .. teamId .. " has " .. Lives[teamId] .. " lives left")
            else
                -- All lives gone so player is out.
                Flags[playerId].Owner = Player.GetPlayer("Neutral")
            end
        end
        SendUnits(playerId)
    end)
end

InitPlayers = function()
    Players[1] = Player.GetPlayer("Multi0")
    Players[2] = Player.GetPlayer("Multi1")
    Players[3] = Player.GetPlayer("Multi2")
    Players[4] = Player.GetPlayer("Multi3")
    Players[5] = Player.GetPlayer("Multi4")
    Players[6] = Player.GetPlayer("Multi5")
    Players[7] = Player.GetPlayer("Multi6")
    Players[8] = Player.GetPlayer("Multi7")

    Entries[1] = Spawn1
    Entries[2] = Spawn2
    Entries[3] = Spawn3
    Entries[4] = Spawn4
    Entries[5] = Spawn5
    Entries[6] = Spawn6
    Entries[7] = Spawn7
    Entries[8] = Spawn8

	Waypoints[1] = Waypoint1.Location
	Waypoints[2] = Waypoint2.Location
	Waypoints[3] = Waypoint3.Location
	Waypoints[4] = Waypoint4.Location
	Waypoints[5] = Waypoint5.Location
	Waypoints[6] = Waypoint6.Location
	Waypoints[7] = Waypoint7.Location
	Waypoints[8] = Waypoint8.Location

    for playerId = 1, 8 do
		if Players[playerId] ~= nil then
			Flags[playerId] = Actor.Create(FlagsTypes[Players[playerId].Faction], true, { Owner = Players[playerId], Location = Waypoints[playerId] })
		end
	end

    Lives[1] = 4
    Lives[2] = 4
end

WorldLoaded = function()
    InitPlayers()

    for playerId = 1, 8 do
		if Players[playerId] ~= nil then
			Trigger.OnKilled(Players[playerId].GetActorsByType("m3")[1], function()
				SendUnits(playerId)
			end)
		end
	end
end
