function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)

	return actorList
end

buildWidth = 3

function DoDelay(I_Actor, I_actorOwner, I_Location, I_time)
	local m_Actor = I_Actor 
	local m_actorOwner = I_actorOwner 
	local m_Location = I_Location 
	local m_time = I_time
	if m_Location.X > ( Map.BottomRight.X / 1024.0 - buildWidth ) then
		Media.DisplayMessage("Out of map: "..m_actorOwner.InternalName.." - "..m_Location.X..","..m_Location.Y.." - "..(Map.BottomRight.X/1024)..","..(Map.BottomRight.Y/1024), m_actorOwner.InternalName, m_actorOwner.Color)
		return
	end
	if m_Location.Y > ( Map.BottomRight.Y / 1024.0 - buildWidth  ) then
		Media.DisplayMessage("Out of map: "..m_actorOwner.InternalName.." - "..m_Location.X..","..m_Location.Y.." - "..(Map.BottomRight.X/1024)..","..(Map.BottomRight.Y/1024), m_actorOwner.InternalName, m_actorOwner.Color)
		return
	end
	if m_Location.X < buildWidth then
		Media.DisplayMessage("Out of map: "..m_actorOwner.InternalName.." - "..m_Location.X..","..m_Location.Y.." - "..(Map.BottomRight.X/1024)..","..(Map.BottomRight.Y/1024), m_actorOwner.InternalName, m_actorOwner.Color)
		return
	end
	if m_Location.Y < buildWidth then
		Media.DisplayMessage("Out of map: "..m_actorOwner.InternalName.." - "..m_Location.X..","..m_Location.Y.." - "..(Map.BottomRight.X/1024)..","..(Map.BottomRight.Y/1024), m_actorOwner.InternalName, m_actorOwner.Color)
		return
	end

	Trigger.AfterDelay(DateTime.Seconds(m_time), function()
		Actor.Create(m_Actor, true, { Owner = m_actorOwner, Location = m_Location})
    end)
end	


function getAllCreeps()
	targets = Utils.Where(Creeps.GetActors(), function(actor)
		return actor.Type == "silo"
		--return actor.Type == "apwr" or actor.Type == "silo" or actor.Type == "thf"
	end)
	return targets
end

--Remove Boxes in Table
function removeactors(a)
	Utils.Do(a, function(unit)
		unit.Destroy()
	end)
	return 
end

function tablelength(T)
	local count = 0
	for _ in pairs(T) do count = count + 1 end
	return count
end

WorldLoaded = function()
	playersingame = {"Multi0","Multi1","Multi2","Multi3","Multi4","Multi5","Multi6","Multi7"}
    playersingamecount = tablelength(playersingame) 
	quick_enabled = 0
	activeplayers = {}    -- Table for Active Players
	--activeplayername = {}    -- Table for Active Players

	z = 1
	for i = playersingamecount,1,-1 
	do 
		playername = playersingame[i]
		
		if (Player.GetPlayer(playername) ~= nil) then
			playerinfo = Player.GetPlayer(playername)
			activeplayers[z] = Player.GetPlayer(playername)
			--Media.DisplayMessage (playerinfo.InternalName.." - ", "Mission", HSLColor.Red)
			Media.DisplayMessage (playerinfo.InternalName, "Mission", HSLColor.Red)
			--activeplayername[i] = playername
			z = z + 1
--			if playerinfo.HasPrerequisites({"quick_enabled"}) 
--			then
--				quick_enabled = 1
--			end
		end
		
		--Media.DisplayMessage ("Player  " .. message, "Mission", HSLColor.Red)
	end

	SNAP = Map.LobbyOption("SNAP")
	Media.DisplayMessage("SNAP: "..SNAP, "Debug", HSLColor.Blue)
	if SNAP == "entry_2" or SNAP == "entry_3" then 
		quick_enabled = 1
		if SNAP == "entry_1" or SNAP == "entry_2" then
			next_ticker = -1
		end 
	end

	Creeps = Player.GetPlayer("Creeps") 
	Neutral = Player.GetPlayer("Neutral") 

	if quick_enabled == 1
	then
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			setupRefs()
		end)
	    --Trigger.AfterDelay(DateTime.Seconds(4), function()
	    --    Media.PlaySound("snap.aud")
	    --end)
	end
end

ticker = 0
next_ticker=100
ticker_count=0

Tick = function()
	ticker = ticker + 1

	if (next_ticker ~= -1) then 

		if (ticker >= next_ticker and ticker_count < 11 ) then
			if ticker_count == 0 then 
				buildWidth = 1
			end

			for i = BRICKS_number,1,-1 
			do 
				DoDelay("brik", 	BRICKS_actorOwner[i], BRICKS_Location[i] + CVec.New(0,ticker_count), 1)
			end
			next_ticker = next_ticker + 4
			ticker_count = ticker_count + 1


		elseif (ticker >= next_ticker and ticker_count >= 11 and ticker_count < 19 ) then

			for i = BRICKS_number,1,-1 
			do 
				DoDelay("brik", 	BRICKS_actorOwner[i], BRICKS_Location[i] + CVec.New(ticker_count-11,11), 1)
			end
			next_ticker = next_ticker + 4
			ticker_count = ticker_count + 1

		elseif (ticker >= next_ticker and ticker_count >= 19 and ticker_count < 30 ) then

			for i = BRICKS_number,1,-1 
			do 
				DoDelay("brik", 	BRICKS_actorOwner[i], BRICKS_Location[i] + CVec.New(8,11-(ticker_count-19)), 1)
			end
			next_ticker = next_ticker + 4
			ticker_count = ticker_count + 1

		elseif (ticker >= next_ticker and ticker_count >= 30 and ticker_count < 38 ) then

			for i = BRICKS_number,1,-1 
			do 
				DoDelay("brik", 	BRICKS_actorOwner[i], BRICKS_Location[i] + CVec.New(8-(ticker_count-30),0), 1)
			end
			next_ticker = next_ticker + 4
			ticker_count = ticker_count + 1

		else
			if ticker_count == 38 then
				next_ticker = -1 
			end
		end
	end
end

BRICKS_number = 0
BRICKS_actorOwner = {}
BRICKS_Location = {}

function setupRefs()
--	allies: 	allies
--	england: 	allies
--	france: 	allies
--	germany: 	allies
--	spain: 		allies
--	greece: 	allies
--	turkey: 	allies
--
--	russia: 	soviet
--	soviet: 	soviet
--	ukraine: 	soviet

--	facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
--		return actor.Type == "fact" or actor.Type == "mcv"
--	end)
--
--	Utils.Do(facts, function(a)
--		if a.Owner ~= castlePlayer then
--			actorOwner = a.Owner
--			toCapture = {}
--			toCapture = { "silo","powr", "thf"}
--			Utils.Do(toCapture, function(z)
--				actorsToCapture = getActorsAround(a,z,15)
--				Utils.Do(actorsToCapture, function(b)
--					b.Owner = actorOwner
--				end)
--			end)
--		end
--	end)

	--Create Refs
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
			return actor.Type == "fact" or actor.Type == "mcv"
		end)

--		powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
--			return actor.Type == "silo"
--		end)

		Utils.Do(facts, function(a)
			BRICKS_number = BRICKS_number + 1
			actorOwner = a.Owner
			originalLocation = a.Location
			--originalLocation = a.CenterPosition	


			if actorOwner.InternalName ~= "Creeps" then
			 	--Media.DisplayMessage("Type:  "..actorOwner.InternalName.." - "..a.Type, actorOwner.InternalName, actorOwner.Color)
			 	--Media.DisplayMessage("Faction:  "..actorOwner.InternalName.." - "..actorOwner.Faction, actorOwner.InternalName, actorOwner.Color)

				if ( actorOwner.Faction == "russia" or actorOwner.Faction == "soviet" ) then 
					barrack 	= "barr"
					tech_center = "stek"
					air 		= "afld"
				elseif ( actorOwner.Faction == "ukraine" ) then 
					barrack 	= "barr"
					tech_center = "stek"
					air 		= "afld.ukraine"
				else
					barrack 	= "tent"
					tech_center = "atek"
					air 		= "hpad"
				end


				if a.Type == "fact" then
					originalLocation2 = originalLocation + CVec.New(1,1)
				else
					originalLocation2 = originalLocation
				end

				if originalLocation.X > ( Map.BottomRight.X / 2048.0 ) then 
				--if originalLocation.X < Map.BottomRight.X then 
				 	--Media.DisplayMessage("Left:  "..actorOwner.InternalName.." - "..originalLocation.X..","..originalLocation.Y.." - "..(Map.BottomRight.X/2048)..","..(Map.BottomRight.Y/2048), actorOwner.InternalName, actorOwner.Color)
					
					--newLocation = CVec.New(originalLocation.X/2048,originalLocation.Y/2048) + CVec.New(-1,4)

					newLocation = originalLocation2 + CVec.New(-1,4)
					--Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
					DoDelay("proc", 		actorOwner,	newLocation + CVec.New(-4,-2), 0)
					DoDelay("jeep", 		Neutral, 	newLocation + CVec.New(-3,-4), 0)
					DoDelay("thf", 			actorOwner, newLocation + CVec.New(-2,-4), 0)
					DoDelay("e6", 			actorOwner, newLocation + CVec.New(-4,-4), 0)
					DoDelay("apwr", 		actorOwner, newLocation + CVec.New( 0,-8), 2)
					Trigger.AfterDelay(DateTime.Seconds(2), function() Media.PlaySound("snap.aud") end)
					DoDelay("dome", 		actorOwner, newLocation + CVec.New( 4,-8), 3)
					DoDelay("weap", 		actorOwner, newLocation + CVec.New(-4,-8), 4)
					DoDelay("fix", 			actorOwner,	newLocation + CVec.New(-4,-5), 5)
					DoDelay(barrack, 		actorOwner, newLocation + CVec.New(-4,-11),5)

					DoDelay(tech_center, 	actorOwner,	newLocation + CVec.New( 4,-1), 6)
					DoDelay("apwr", 		actorOwner, newLocation + CVec.New( 4,-5), 7)
					Trigger.AfterDelay(DateTime.Seconds(7), function() Media.PlaySound("snap.aud") end)
					if air == "afld" or air == "afld.ukraine" then
						DoDelay(air, 		actorOwner, newLocation + CVec.New( 0,-1), 8)
					else
						DoDelay(air, 		actorOwner, newLocation + CVec.New( 0,-1), 8)
					end
					if next_ticker ~= -1 then
						BRICKS_actorOwner[BRICKS_number] = actorOwner
						BRICKS_Location[BRICKS_number] = newLocation + CVec.New(-1, -9)
					end
				else
				 	--Media.DisplayMessage("Right: "..actorOwner.InternalName.." - "..originalLocation.X..","..originalLocation.Y.." - "..(Map.BottomRight.X/2048)..","..(Map.BottomRight.Y/2048), actorOwner.InternalName, actorOwner.Color)

					--newLocation = CVec.New(originalLocation.X/2048,originalLocation.Y/2048) + CVec.New(-1,4)

					newLocation = originalLocation2 + CVec.New(-1,-5)
					--Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
					DoDelay("proc", 		actorOwner,	newLocation + CVec.New( 4, 0), 0)
					DoDelay("jeep", 		Neutral, 	newLocation + CVec.New( 5, 5), 0)
					DoDelay("thf", 			actorOwner, newLocation + CVec.New( 4, 5), 0)
					DoDelay("e6", 			actorOwner, newLocation + CVec.New( 6, 5), 0)
					DoDelay("apwr", 		actorOwner, newLocation + CVec.New( 0, 8), 2)
					Trigger.AfterDelay(DateTime.Seconds(2), function() Media.PlaySound("snap.aud") end)
					DoDelay("dome", 		actorOwner, newLocation + CVec.New(-3, 8), 3)
					DoDelay("weap", 		actorOwner, newLocation + CVec.New( 4, 8), 4)
					DoDelay("fix", 			actorOwner, newLocation + CVec.New( 4, 4), 5)
					DoDelay(barrack, 		actorOwner, newLocation + CVec.New( 5,11), 5)

					if tech_center == "atek" then
						DoDelay(tech_center, 	actorOwner,	newLocation + CVec.New(-3, 1), 6)
					else 
						DoDelay(tech_center, 	actorOwner,	newLocation + CVec.New(-4, 1), 6)
					end
					DoDelay("apwr", 		actorOwner, newLocation + CVec.New(-4, 5), 7)
				    Trigger.AfterDelay(DateTime.Seconds(7), function() Media.PlaySound("snap.aud") end)
					if air == "afld" or air == "afld.ukraine" then
						DoDelay(air, 		actorOwner, newLocation + CVec.New( 0, 1), 8)
					else
						DoDelay(air, 		actorOwner, newLocation + CVec.New( 0, 1), 8)
					end
					if next_ticker ~= -1 then
						BRICKS_actorOwner[BRICKS_number] = actorOwner
						BRICKS_Location[BRICKS_number] = newLocation + CVec.New(-5, 0)
					end
				end

			end
		end)

	end)


	Trigger.AfterDelay(DateTime.Seconds(2), function()
		creepActors = getAllCreeps()
		removeactors(creepActors)
	end)

end
