function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)

	return actorList
end

function DoDelay(I_Actor, I_actorOwner, I_Location, I_time)
	local m_Actor = I_Actor 
	local m_actorOwner = I_actorOwner 
	local m_Location = I_Location 
	local m_time = I_time
	Trigger.AfterDelay(DateTime.Seconds(m_time), function()
		Actor.Create(m_Actor, true, { Owner = m_actorOwner, Location = m_Location})
    end)
end	

function setupRefs()
	facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == "fact" or actor.Type == "mcv"
	end)

	Utils.Do(facts, function(a)
		if a.Owner ~= castlePlayer then
			actorOwner = a.Owner
			toCapture = {}
			toCapture = { "silo","powr", "thf"}
			Utils.Do(toCapture, function(z)
				actorsToCapture = getActorsAround(a,z,7)
				Utils.Do(actorsToCapture, function(b)
					b.Owner = actorOwner
				end)
			end)
		end
	end)

	--Create Refs
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
			return actor.Type == "silo"
		end)

		Utils.Do(powrs, function(a)

			actorOwner = a.Owner
			originalLocation = a.Location
			newLocation = originalLocation + CVec.New(0,0)


			if actorOwner.InternalName ~= "Creeps" then
				Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})

			 	--Media.DisplayMessage(""..originalLocation.X..","..originalLocation.Y.." - "..Map.BottomRight.X..","..Map.BottomRight.Y, "Mission", HSLColor.Red)

				if originalLocation.Y < ( Map.BottomRight.Y / 2048.0 ) then 
					DoDelay("jeep", Neutral, 	originalLocation + CVec.New(-3,-4), 0)
					DoDelay("thf", 	actorOwner, originalLocation + CVec.New(-2,-4), 0)
					DoDelay("e6", 	actorOwner, originalLocation + CVec.New(-4,-4), 0)
					DoDelay("apwr", actorOwner, originalLocation + CVec.New( 0,-9), 2)
					DoDelay("dome", actorOwner, originalLocation + CVec.New( 4,-9), 3)
					DoDelay("weap", actorOwner, originalLocation + CVec.New(-4,-9), 4)
					DoDelay("fix", 	actorOwner,	originalLocation + CVec.New( 4,-4), 5)

				else
					DoDelay("jeep", Neutral, 	originalLocation + CVec.New( 5, 7), 0)
					DoDelay("thf", 	actorOwner, originalLocation + CVec.New( 4, 7), 0)
					DoDelay("e6", 	actorOwner, originalLocation + CVec.New( 6, 7), 0)
					DoDelay("apwr", actorOwner, originalLocation + CVec.New( 0,10), 2)
					DoDelay("dome", actorOwner, originalLocation + CVec.New(-3,10), 3)
					DoDelay("weap", actorOwner, originalLocation + CVec.New( 4,10), 4)
					DoDelay("fix", 	actorOwner, originalLocation + CVec.New(-4, 6), 5)
				end

			end
		end)

	end)


	Trigger.AfterDelay(DateTime.Seconds(2), function()
		creepActors = getAllCreeps()
		removeactors(creepActors)
	end)

end


function getAllCreeps()
	targets = Utils.Where(Creeps.GetActors(), function(actor)
		return actor.Type == "silo"
		--return actor.Type == "apwr" or actor.Type == "silo" or actor.Type == "thf"
	end)
	return targets
end

--Remove Boxes in Table
function removeactors(a)
	Utils.Do(a, function(unit)
		unit.Destroy()
	end)
	return 
end

WorldLoaded = function()
	Creeps = Player.GetPlayer("Creeps") 
	Neutral = Player.GetPlayer("Neutral") 

	Trigger.AfterDelay(DateTime.Seconds(1), function()
		setupRefs()
	end)
    Trigger.AfterDelay(DateTime.Seconds(4), function()
        Media.PlaySound("snap.aud")
    end)
end


Tick = function()
end
