function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)

	return actorList
end

function setupRefs()
	facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == "fact" or actor.Type == "mcv"
	end)

	Utils.Do(facts, function(a)
		if a.Owner ~= castlePlayer then
			actorOwner = a.Owner
			toCapture = {}
			toCapture = { "silo","powr", "thf"}
			Utils.Do(toCapture, function(z)
				actorsToCapture = getActorsAround(a,z,15)
				Utils.Do(actorsToCapture, function(b)
					b.Owner = actorOwner
				end)
			end)
		end
	end)

	--Create Refs
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
			return actor.Type == "silo"
		end)

		Utils.Do(powrs, function(a)

			actorOwner = a.Owner
			originalLocation = a.Location
			newLocation = originalLocation + CVec.New(0,0)


			if actorOwner.InternalName ~= "Creeps" then
				Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})

			 	--Media.DisplayMessage(""..originalLocation.X..","..originalLocation.Y.." - "..Map.BottomRight.X..","..Map.BottomRight.Y, "Mission", HSLColor.Red)

				if originalLocation.Y < ( Map.BottomRight.Y / 2048.0 ) then 
					newLocation = originalLocation + CVec.New(4,1)
					Actor.Create("powr", true, { Owner = actorOwner, Location = newLocation})
					newLocation = originalLocation + CVec.New(-2,-4)
					Actor.Create("jeep", true, { Owner = Neutral, Location = newLocation})
					newLocation = originalLocation + CVec.New(-4,-4)
					Actor.Create("thf", true, { Owner = actorOwner, Location = newLocation})
				else
					newLocation = originalLocation + CVec.New(-3,1)
					Actor.Create("powr", true, { Owner = actorOwner, Location = newLocation})
					newLocation = originalLocation + CVec.New(4,7)
					Actor.Create("jeep", true, { Owner = Neutral, Location = newLocation})
					newLocation = originalLocation + CVec.New(6,7)
					Actor.Create("thf", true, { Owner = actorOwner, Location = newLocation})
				end

			end
		end)

	end)


	Trigger.AfterDelay(DateTime.Seconds(2), function()
		creepActors = getAllCreeps()
		removeactors(creepActors)
	end)

end


function getAllCreeps()
	targets = Utils.Where(Creeps.GetActors(), function(actor)
		return actor.Type == "powr" or actor.Type == "silo" or actor.Type == "thf"
	end)
	return targets
end

--Remove Boxes in Table
function removeactors(a)
	Utils.Do(a, function(unit)
		unit.Destroy()
	end)
	return 
end

WorldLoaded = function()
	Creeps = Player.GetPlayer("Creeps") 
	Neutral = Player.GetPlayer("Neutral") 

	Trigger.AfterDelay(DateTime.Seconds(2), function()
		setupRefs()
	end)
    Trigger.AfterDelay(DateTime.Seconds(4), function()
        Media.PlaySound("snap.aud")
    end)
end


Tick = function()
end
