--[[*
Copyright 2024 by Gingdev
--]]

Neutral = Player.GetPlayer("Neutral")

HumanPlayers = Player.GetPlayers(
---@param p player
---@return boolean
	function(p)
		return p.IsBot == false
	end)

AIPlayers = Player.GetPlayers(
---@param p player
---@return boolean
	function(p)
		return p.IsBot
	end)

SuperTeam = { "zkoi", "volk", "tany" }
Waypoints = { Waypoint1, Waypoint2 }
MoneyArea = { x = { 30, 60 }, y = { 60, 80 } }
Transport = { 'apc', 'jeep' }

---@generic T
---@param c T[]
---@return T
TakeRandom = function(c)
	return Utils.Random(c)
end

---@param p player
---@return player[]
FindEnemies = function(p)
	local enemies = Player.GetPlayers(
	---@param e player
		function(e)
			return p.IsAlliedWith(e) == false and #e.GetActorsByTypes({ 'proc', 'fact' }) > 0
		end
	)

	return enemies
end

RaidInterval = function()
	Trigger.AfterDelay(DateTime.Minutes(3), RaidInterval)

	Utils.Do(AIPlayers,
		---@param ai player
		function(ai)
			local enemy = TakeRandom(FindEnemies(ai))
			local targets = enemy.GetActorsByTypes({ 'harv', 'proc' })

			if #targets == 0 then
				return
			end

			local target = TakeRandom(targets)
			local transport = Actor.Create(TakeRandom(Transport), true,
				{ Location = ai.HomeLocation + CVec.New(0, 2), Owner = ai })

			transport.LoadPassenger(Actor.Create('thf', false, { Owner = ai }))

			Trigger.OnPassengerExited(transport,
				---@param t actor
				---@param a actor
				function(t, a)
					Trigger.OnAddedToWorld(a,
						---@param a actor
						function(a)
							if target.Type == 'proc' then
								a.Infiltrate(target)
							else
								a.Capture(target)
							end
						end)
				end)

			Trigger.OnDamaged(target,
				---@param self actor
				---@param attacker actor
				---@param damage integer
				function(self, attacker, damage)
					if attacker == transport then
						transport.Stop()
                        transport.UnloadPassengers()
					end
				end)

			transport.Attack(target, true, true)
		end)
end

---@param killed actor
RebornOnKilled = function(killed)
	Media.DisplayMessageToPlayer(killed.Owner, 'Your hero will respawn after 5 minutes', 'Ging', HSLColor.Red)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		local transport = Actor.Create("badr", true, { Owner = killed.Owner, Location = killed.Owner.HomeLocation })
		transport.LoadPassenger(CreateSuperActor(killed.Type, killed.Owner))
		transport.Paradrop(killed.Owner.HomeLocation)
	end)
end

---Create super hero unit
---@param type string
---@param owner player
---@return actor
CreateSuperActor = function(type, owner)
	local a = Actor.Create(type, false, { Owner = owner })
	Trigger.OnKilled(a, RebornOnKilled)
	return a
end

---@param actor actor
IdleHunt = function(actor)
	Trigger.OnIdle(actor,
		---@param a actor
		function(a)
			if a.IsInWorld then
				a.Hunt()
			end
		end)
end

---@param location actor
SendParadrops = function(location)
	local aircraft = ParaTroopersPowerProxy.TargetParatroopers(location.CenterPosition)
	Utils.Do(aircraft,
		---@param a actor
		function(a)
			Trigger.OnPassengerExited(a,
				---@param t actor
				---@param p actor
				function(t, p)
					IdleHunt(p)
				end)
		end)
end

ParaDropsInterval = function()
	for _, bot in ipairs(AIPlayers) do
		ParaTroopersPowerProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = bot })
		SendParadrops(TakeRandom(Waypoints))
	end
	Trigger.AfterDelay(DateTime.Minutes(1), ParaDropsInterval)
end

---@param location cpos
---@param limit integer
AIMoveTo = function(location, limit)
	local actors = TakeRandom(AIPlayers).GetGroundAttackers()
	Utils.Do(Utils.Take(limit, actors),
		---@param a actor
		function(a)
			a.Move(location)
		end)
end

---@param interval? integer
RandomMoneyCrate = function(interval)
	local transport = Actor.Create('badr', true, { Owner = Neutral })
	transport.LoadPassenger(Actor.Create('moneycrate', false, { Owner = Neutral }))
	transport.Paradrop(CPos.New(
		Utils.RandomInteger(MoneyArea.x[1], MoneyArea.x[2]),
		Utils.RandomInteger(MoneyArea.y[1], MoneyArea.y[2])
	))

	Trigger.OnPassengerExited(transport,
		---@param self actor
		---@param passenger actor
		function(self, passenger)
			Media.DisplayMessage('Reinforcements has arrived', 'Admin', HSLColor.Green)
			AIMoveTo(self.Location, 2)
		end)

	if interval == nil then
		return
	end

	Trigger.AfterDelay(interval, function()
		RandomMoneyCrate(interval)
	end)
end

WorldLoaded = function()
	Media.DisplayMessage('Family War v1.0', 'Ging', HSLColor.Green)

	RandomMoneyCrate(DateTime.Minutes(1))

	Trigger.AfterDelay(DateTime.Minutes(5), function ()
        ParaDropsInterval()
		RaidInterval()
	end)

	--Send hero to players
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		for _, p in pairs(Player.GetPlayers(function()
			return true
		end)) do
			local transport = Actor.Create("badr", true, { Owner = p, Location = p.HomeLocation })
			Utils.Do(SuperTeam,
				---@param type string
				function(type)
					transport.LoadPassenger(CreateSuperActor(type, p))
				end)
			Media.PlaySpeechNotification(p, "ReinforcementsArrived")
			transport.Paradrop(p.HomeLocation)
		end
	end)

	--bruh mode enable
	Trigger.AfterDelay(DateTime.Minutes(5), function()
		for _, bot in pairs(AIPlayers) do
			bot.Cash = 1000000
		end
	end)
end
