--[[*
Copyright 2024 by Gingdev
--]]

Neutral = Player.GetPlayer("Neutral")

HumanPlayers = Player.GetPlayers(
---@param p player
---@return boolean
	function(p)
		return p.IsBot == false
	end)

AIPlayers = Player.GetPlayers(
---@param p player
---@return boolean
	function(p)
		return p.IsBot
	end)

SuperTeam = { "zkoi", "volk", "tany" }
Waypoints = { Waypoint1, Waypoint2 }
MoneyArea = {
	x = { 30, 60 },
	y = { 60, 80 }
}

---@generic T
---@param c T[]
---@return T
TakeRandomOne = function(c)
	return c[Utils.RandomInteger(1, #c + 1)]
end

---@param killed actor
RebornOnKilled = function(killed)
	Media.DisplayMessageToPlayer(killed.Owner, 'Your hero will respawn after 5 minutes', 'Ging', HSLColor.Red)
	Trigger.AfterDelay(DateTime.Minutes(5), function()
		local transport = Actor.Create("badr", true, { Owner = killed.Owner, Location = killed.Owner.HomeLocation })
		transport.LoadPassenger(CreateSuperActor(killed.Type, killed.Owner))
		transport.Paradrop(killed.Owner.HomeLocation)
	end)
end

---Create super hero unit
---@param type string
---@param owner player
---@return actor
CreateSuperActor = function(type, owner)
	local a = Actor.Create(type, false, { Owner = owner })
	Trigger.OnKilled(a, RebornOnKilled)
	return a
end

---@param actor actor
IdleHunt = function(actor)
	Trigger.OnIdle(actor,
		---@param a actor
		function(a)
			if a.IsInWorld then
				a.Hunt()
			end
		end)
end

---@param location actor
SendParadrops = function(location)
	local aircraft = ParaTroopersPowerProxy.TargetParatroopers(location.CenterPosition)
	Utils.Do(aircraft,
		---@param a actor
		function(a)
			Trigger.OnPassengerExited(a,
				---@param t actor
				---@param p actor
				function(t, p)
					IdleHunt(p)
				end)
		end)
end

ParaDropsInterval = function()
	for _, bot in ipairs(AIPlayers) do
		ParaTroopersPowerProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = bot })
		SendParadrops(TakeRandomOne(Waypoints))
	end
	Trigger.AfterDelay(DateTime.Seconds(30), ParaDropsInterval)
end

---@param location cpos
AIMoveTo = function(location)
	Utils.Do(TakeRandomOne(AIPlayers).GetGroundAttackers(),
		---@param a actor
		function(a)
			Trigger.AfterDelay(DateTime.Seconds(5), function()
				if not a.IsDead and a.IsIdle then
					a.Move(location)
				end
			end)
		end)
end

---@param interval? integer
RandomMoneyCrate = function(interval)
	local transport = Actor.Create('badr', true, { Owner = Neutral })
	transport.LoadPassenger(Actor.Create('moneycrate', false, { Owner = Neutral }))
	transport.Paradrop(CPos.New(
		Utils.RandomInteger(MoneyArea.x[1], MoneyArea.x[2]),
		Utils.RandomInteger(MoneyArea.y[1], MoneyArea.y[2])
	))

	Trigger.OnPassengerExited(transport,
		---@param self actor
		---@param passenger actor
		function(self, passenger)
			Media.DisplayMessage('Gói tiếp tế SussyBaka đã đến', 'Admin', HSLColor.Green)
			AIMoveTo(self.Location)
		end)

	if interval == nil then
		return
	end

	Trigger.AfterDelay(interval, function()
		RandomMoneyCrate(interval)
	end)
end

WorldLoaded = function()
	Media.DisplayMessage('Family War v1.0', 'Ging', HSLColor.Green)
	RandomMoneyCrate(DateTime.Minutes(1))
	Trigger.AfterDelay(DateTime.Minutes(5), ParaDropsInterval)

	--Send hero to players
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		for _, p in pairs(Player.GetPlayers(function()
			return true
		end)) do
			local transport = Actor.Create("badr", true, { Owner = p, Location = p.HomeLocation })
			Utils.Do(SuperTeam,
				---@param type string
				function(type)
					transport.LoadPassenger(CreateSuperActor(type, p))
				end)
			Media.PlaySpeechNotification(p, "ReinforcementsArrived")
			transport.Paradrop(p.HomeLocation)
		end
	end)

	--bruh mode enable
	Trigger.AfterDelay(DateTime.Minutes(5), function()
		for _, bot in pairs(AIPlayers) do
			bot.Cash = 1000000
		end
	end)
end
