local Ukraine = Player.GetPlayer("Ukraine")

local Entries =
{
	EntryN, EntryS, EntrySW, EntryW, EntryNW
}

WorldLoaded = function()
	local type = "e1"
	local types = { }

	for _ = 1, 50 do
		table.insert(types, type)
	end
	--SendRepeatingUnit("jeep", RandomEntry(), Exit)
	SendRepeatingGroup(types, RandomEntry(), Exit)

	Trigger.OnEnteredFootprint({ Exit.Location }, function(actor)
		if actor.HasProperty("Health") and actor.Owner == Ukraine then
			actor.Destroy()
		end
	end)
end

Tick = function()
	Ukraine.Cash = 5000
end

RandomEntry = function(lastEntry)
	local shuffled = Utils.Shuffle(Entries)

	for i = 1, #shuffled do
		if shuffled[i] ~= lastEntry then
			return shuffled[1]
		end
	end
end

FacingTowardTarget = function(start, target)
	return (target.CenterPosition - start.CenterPosition).Facing
end

SendRepeatingGroup = function(types, entry, exit)
	local units = Reinforcements.Reinforce(Ukraine, types, { entry.Location, exit.Location }, 1, function(unit)
		unit.Move(exit.Location)
	end)

	Trigger.OnAllRemovedFromWorld(units, function()
		SendRepeatingGroup(types, RandomEntry(), exit)
	end)
end
