-- Constants
local SOUND_DELAY_TIMES = {300, 600, 900, 1200, 1800}

rules = function()
    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage ("The All-Mighty's shall reign supreme!", "Message", HSLColor.Red)
    end)	

    for _, delay in ipairs(SOUND_DELAY_TIMES) do
        Trigger.AfterDelay(DateTime.Seconds(delay), function()
            Media.PlaySound("mightyintro1.aud")
        end)
    end
end

WorldLoaded = function ()
	Creeps = Player.GetPlayer("Creeps")
    rules()
end

Tick = function ()
end

function getActorsAround(actorselected,actorsToFind, distance)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
		return a.Type == actorsToFind
	end)

	return actorList
end

function getClosetActor(actorselected,actorsToFind)
	actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(50), function(a)
		return a.Type == actorsToFind
	end)

	return actorList[1]
end

function getAllActors(a)

	theActors = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == a
	end)

	return theActors

end

function getAllCreeps()

	targets = Utils.Where(Creeps.GetActors(), function(actor)
		return
			actor.Type == "powr" or actor.Type == "harv"
	end)
	return targets

end

function setupProc()

	facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == "fact" or actor.Type == "mcv"
	end)

	Utils.Do(facts, function(a)
		if a.Owner ~= castlePlayer then
			actorOwner = a.Owner

			toCapture = { "harv","powr"}

			Utils.Do(toCapture, function(z)
				actorsToCapture = getActorsAround(a,z,13)
					
				Utils.Do(actorsToCapture, function(b)
					b.Owner = actorOwner
				end)
			end)
		end
	end)

	Trigger.AfterDelay(DateTime.Seconds(1), function()
		powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
			return actor.Type == "harv"
		end)

		Utils.Do(powrs, function(a)

			actorOwner = a.Owner
			originalLocation = a.Location
			newLocation = originalLocation + CVec.New(0,1)

			if actorOwner.InternalName ~= "Creeps" then
				Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
			end
		end)

	end)

	Trigger.AfterDelay(DateTime.Seconds(2), function()
		creepActors = getAllCreeps()
		removeactors(creepActors)
	end)

end

function removeactors(a)
	Utils.Do(a, function(unit)
			unit.Destroy()
	end)
	return 
	end
	
Trigger.AfterDelay(DateTime.Seconds(2), function()
			setupProc()


end)
		