CaptureTrigger = function(s, captor, oldOwner, newOwner)
    --Notify players
    Media.DisplayMessage(s.TooltipName .. " has been captured.", newOwner.Name, newOwner.Color)

    --Color flags
    local flags = Map.ActorsInCircle(s.CenterPosition, WDist.FromCells(6), function(f) return f.Type == "ctflag" end)
    Utils.Do(flags, function(f) f.Owner = newOwner end)
end

ResetTrigger = function(s)
    --Notify players
    Media.DisplayMessage(s.TooltipName .. " Has been destroyed.", "Reset", HSLColor.White)

    --Color flags
    local flags = Map.ActorsInCircle(s.CenterPosition, WDist.FromCells(6), function(f) return f.Type == "ctflag" end)
    Utils.Do(flags, function(f) f.Owner = Player.GetPlayer("Neutral") end)

    --Reattach Triggers
    Trigger.AfterDelay(2, function() AttachTriggerTo(s.Type) end)
end

AttachTriggerTo = function(t)
    local hills = Utils.Where(Map.ActorsInWorld, function(s) return s.Type == t end)
    Utils.Do(hills, function(h)
        Trigger.OnCapture(h, CaptureTrigger)
        Trigger.OnKilled(h, ResetTrigger)
    end)
end

WorldLoaded = function()
    Trigger.AfterDelay(5, function() 
        AttachTriggerTo("pdox.koth")
        AttachTriggerTo("bio.koth")
    end)
end