creeps = nil
p0score = 1500
p1score = 1500
player0 = nil
player1 = nil

SetCamera = function(player)
	local mcv = player.GetActorsByType("mcv")[1]
	Camera.Position = mcv.CenterPosition
end


StartingTexts = function()
	Media.DisplayMessage("Unfortunately the vaccine research against the Lazarene plague had been removed from the Gerasene Research Facility.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("The research is distributed within the Gerasene Laboratoires within this area.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Capture and hold the laboratoires before our enemies get a hold of the vaccine.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Or alternatively destroy all resistance!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(20), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

SpawnZombies = function()
	local randomCell = Map.RandomEdgeCell()
	local oppositeCell = CPos.New(98 - randomCell.Y, 98 - randomCell.X)
	local cellToMove = Map.RandomCell()
	local howMany = Utils.RandomInteger(1, 5)
	while howMany > 0 do
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = randomCell })
		MoveToCell(actor, cellToMove)
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = oppositeCell })
		MoveToCell(actor, CPos.New(98 - cellToMove.Y, 98 - cellToMove.X))
		howMany = howMany - 1
	end
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 20)), function()
		SpawnZombies()
	end)
end

MoveToCell = function(moved,cell)
	if moved.IsDead == false then
		moved.Scatter()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			if moved.IsDead == false then
				moved.AttackMove(cell)
				Trigger.OnDiscovered(moved, StopMe)
			end
		end)
	end
end

StopMe = function(discovered,discoverer)
	if discovered.IsDead == false then
		discovered.Stop()
	end
end

UpdateScore = function()
	local p0minutes = math.floor(p0score / 60)
	local p0seconds = p0score - (p0minutes * 60)
	local p1minutes = math.floor(p1score / 60)
	local p1seconds = p1score - (p1minutes * 60)
	local text = ""
	text = "Time left for succesful recovery of research:\n"
	if p0seconds < 10 then
		text = text .. player0.Name .. ": " .. p0minutes .. ":0" .. p0seconds .. " (-" .. #player0.GetActorsByType("bio") .. ")\n"
	else
		text = text .. player0.Name .. ": " .. p0minutes .. ":" .. p0seconds .. " (-" .. #player0.GetActorsByType("bio") .. ")\n"
	end
	if p1seconds < 10 then
		text = text .. player1.Name .. ": " .. p1minutes .. ":0" .. p1seconds .. " (-" .. #player1.GetActorsByType("bio") .. ")\n"
	else
		text = text .. player1.Name .. ": " .. p1minutes .. ":" .. p1seconds .. " (-" .. #player1.GetActorsByType("bio") .. ")\n"
	end
	p0score = p0score - #player0.GetActorsByType("bio")
	p1score = p1score - #player1.GetActorsByType("bio")
	if p0score < 0 and p1score > p0score then
		DecideWinner(player1)
		text = player0.Name .. " wins!"
	elseif p1score < 0 and p1score < p0score then
		DecideWinner(player0)
		text = player1.Name .. " wins!"
	elseif p1score < 0 and p0score < 0 and p1score == p0score then
		text = "There is a tie. The player that gets an extra laboratoire or destroyes an enemy one wins."
	end
	UserInterface.SetMissionText(text, HSLColor.White)
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		UpdateScore()
	end)
end

DecideWinner = function(loser)
	loser.MarkFailedObjective(0)
end

WorldLoaded = function()
	creeps = Player.GetPlayer("Creeps")
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")

	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
	StartingTexts()
	SpawnZombies()
	UpdateScore()
end
