creeps = nil
gametimer = 300
thecompound = nil

SetCamera = function(player)
	local mcv = player.GetActorsByType("mcv")[1]
	Camera.Position = mcv.CenterPosition
end

LaunchNukes = function ()
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		LaunchNuke()
	end)
end

LaunchNuke = function ()
	local x = 1
	local y = 1
	x = Utils.RandomInteger(1, 98)
	y = Utils.RandomInteger(1, 98)
	if NukeSilo1.IsDead == false or NukeSilo2.IsDead == false then
		Media.PlaySpeechNotification(Greece, "AbombLaunchDetected")
	end
	if NukeSilo1.IsDead == false then
		NukeSilo1.ActivateNukePower(CPos.New(x, y))
		Beacon.New(Player.GetPlayer("Multi0"),Map.CenterOfCell(CPos.New(x, y)),900)
		Beacon.New(Player.GetPlayer("Multi1"),Map.CenterOfCell(CPos.New(x, y)),900)
	end
	if NukeSilo2.IsDead == false then
		NukeSilo2.ActivateNukePower(CPos.New(99 - y, 99 - x))
		Beacon.New(Player.GetPlayer("Multi0"),Map.CenterOfCell(CPos.New(99 - y, 99 - x)),900)
		Beacon.New(Player.GetPlayer("Multi1"),Map.CenterOfCell(CPos.New(99 - y, 99 - x)),900)
	end
	LaunchNukes()
end

StartingTexts = function()
	Media.DisplayMessage("We have cleared our way to the Gerasene Research Facility. Capture the compound as soon as you can.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Our enemies have similiar intentions. Hold the compound for 5 minutes or destroy your enemies.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("The automated defense mechanisms of the compound have been activated. Beaware, we do not know the full extent of these defenses.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

SpawnZombies = function()
	local randomCell = Map.RandomEdgeCell()
	local oppositeCell = CPos.New(99 - randomCell.Y, 99 - randomCell.X)
	local cellToMove = Map.RandomCell()
	local howMany = Utils.RandomInteger(1, 5)
	while howMany > 0 do
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = randomCell })
		MoveToCell(actor, cellToMove)
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = oppositeCell })
		MoveToCell(actor, CPos.New(99 - cellToMove.Y, 99 - cellToMove.X))
		howMany = howMany - 1
	end
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 20)), function()
		SpawnZombies()
	end)
end

MoveToCell = function(moved,cell)
	if moved.IsDead == false then
		moved.Scatter()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			if moved.IsDead == false then
				moved.AttackMove(cell)
				Trigger.OnDiscovered(moved, StopMe)
			end
		end)
	end
end

StopMe = function(discovered,discoverer)
	if discovered.IsDead == false then
		discovered.Stop()
	end
end

WinTimer = function()
	if thecompound.Owner ~= Player.GetPlayer("Neutral") then
		if gametimer < 0 then
			if thecompound.Owner == Player.GetPlayer("Multi0") then
				Player.GetPlayer("Multi1").MarkFailedObjective(0)
				UserInterface.SetMissionText("" .. Player.GetPlayer("Multi0").Name .. " wins!", HSLColor.White)
			elseif thecompound.Owner == Player.GetPlayer("Multi1") then
				Player.GetPlayer("Multi0").MarkFailedObjective(0)
				UserInterface.SetMissionText("" .. Player.GetPlayer("Multi1").Name .. " wins!", HSLColor.White)
			end
		else
			local minutes = math.floor(gametimer / 60)
			local seconds = gametimer - (minutes * 60)
			local timetext = ""
			if seconds < 10 then
				timetext = "Time left: " .. minutes .. ":0" .. seconds .. ""
			else
				timetext = "Time left: " .. minutes .. ":" .. seconds .. ""
			end
			UserInterface.SetMissionText("Time until " .. gergoal.Owner.Name .. " wins.\n" .. timetext .. "", HSLColor.White)
			Trigger.AfterDelay(DateTime.Seconds(1), function()
				gametimer = gametimer - 1
				WinTimer()
			end)
		end
	end
end

CompoundCapped = function()
	gametimer = 300
	WinTimer()
end

SpawnNewCompound = function(killed,killer)
	UserInterface.SetMissionText("Capture the Gerasene Research Facility!", HSLColor.White)
	local actor = Actor.Create("miss", true, { Owner = Player.GetPlayer("Neutral"), Location = killed.Location })
	thecompound = actor
	Trigger.OnCapture(thecompound,CompoundCapped)
	Trigger.OnKilled(thecompound,SpawnNewCompound)
end

WorldLoaded = function()
	creeps = Player.GetPlayer("Creeps")
	local player0 = Player.GetPlayer("Multi0")
	local player1 = Player.GetPlayer("Multi1")

	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
	LaunchNukes()
	StartingTexts()
	SpawnZombies()
	thecompound = gergoal
	Trigger.OnCapture(gergoal,CompoundCapped)
	Trigger.OnKilled(gergoal,SpawnNewCompound)
	UserInterface.SetMissionText("Capture the Gerasene Research Facility!", HSLColor.White)
end
