aspawns = {}
bspawns = {}
cspawns = {}
dspawns = {}
espawns = {}
enemies = {}
player0 = nil
player1 = nil
creep = nil
zombos = nil
rounds = 0
spawntime = 60

StartingTexts = function()
	Media.DisplayMessage("The information we gathered from the research Biolab indicate that the cure for the Lazarene plague is inside another research facility called the Gerasene Research Facility!")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Unfortunately the undead have overrun all our outposts near that area!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("In order to advance towards the facility we have to establish a base in this area. It seems to be the least affected by the plague.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("However our intel on this area is scetchy since none of our scouts have returned from their missions!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(20), function()
		Media.DisplayMessage("Prepare for everything! Good luck commander!")
	end)
end

SpawnZombies = function()
	local randomCell = Map.RandomEdgeCell()
	local oppositeCell = CPos.New(99 - randomCell.X, 99 - randomCell.Y)
	local cellToMove = Map.RandomCell()
	local howMany = Utils.RandomInteger(1, 5)
	while howMany > 0 do
		local actor = Actor.Create("zombie", true, { Owner = zombos, Location = randomCell })
		MoveToCell(actor, cellToMove)
		local actor = Actor.Create("zombie", true, { Owner = zombos, Location = oppositeCell })
		MoveToCell(actor, CPos.New(99 - cellToMove.X, 99 - cellToMove.Y))
		howMany = howMany - 1
	end
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 20)), function()
		SpawnZombies()
	end)
end

MoveToCell = function(moved,cell)
	if moved.IsDead == false then
		moved.Scatter()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			if moved.IsDead == false then
				moved.AttackMove(cell)
				Trigger.OnDiscovered(moved, StopMe)
			end
		end)
	end
end

StopMe = function(discovered,discoverer)
	if discovered.IsDead == false then
		discovered.Stop()
	end
end

InitializeAndSpawnsAndEnemies = function ()
	aspawns[1] = A1
	aspawns[2] = A2
	bspawns[1] = B1
	bspawns[2] = B2
	cspawns[1] = C1
	cspawns[2] = C2
	dspawns[1] = D1
	dspawns[2] = D2
	espawns[1] = E1
	espawns[2] = E2
	enemies[1] = "antscout"
	enemies[2] = "antwarrior"
	enemies[3] = "antburrower"
	enemies[4] = "antgigantus"
	enemies[5] = "antpraetor"
	enemies[6] = "antbomb"
	enemies[7] = "antpoison"
	enemies[8] = "antfire"
	enemies[9] = "anttesla"
	enemies[10] = "antdrone"
	creep = Player.GetPlayer("Creeps")
	zombos = Player.GetPlayer("Zombos")
end

SpawnEnemies = function()
	local whichspawn = Utils.RandomInteger(1, 5)
	local delay = Utils.RandomInteger(1, 20)
	if whichspawn == 1 then
		Trigger.AfterDelay(DateTime.Seconds(delay), function()
			SpawnEnemiesAs()
		end)
	elseif whichspawn == 2 then
		Trigger.AfterDelay(DateTime.Seconds(delay), function()
			SpawnEnemiesBs()
		end)
	elseif whichspawn == 3 then
		Trigger.AfterDelay(DateTime.Seconds(delay), function()
			SpawnEnemiesCs()
		end)
	elseif whichspawn == 4 then
		Trigger.AfterDelay(DateTime.Seconds(delay), function()
			SpawnEnemiesDs()
		end)
	elseif whichspawn == 5 then
		Trigger.AfterDelay(DateTime.Seconds(delay), function()
			SpawnEnemiesEs()
		end)
	end
	rounds = rounds + 1
	Trigger.AfterDelay(DateTime.Seconds(spawntime), function()
		SpawnEnemies()
	end)
end

SpawnEnemiesAs = function()
	local scouts = rounds
	local warriors = math.floor(rounds / 5)
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		scouts = 5 + math.floor(rounds / 10)
	end
	if warriors > 3 then
		warriors = 3
	end
	if rounds > 5 then
		randoms = Utils.RandomInteger(1, 3)
		randomNum = Utils.RandomInteger(3, 8)
	end
	if A1.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = A1.Location })
			actor.AttackMove(PA1.Location)
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = A1.Location })
			actor.AttackMove(PA1.Location)
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A1.Location })
			actor.AttackMove(PA1.Location)
		end
	end
	if A2.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = A2.Location })
			actor.AttackMove(PB1.Location)
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = A2.Location })
			actor.AttackMove(PB1.Location)
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A2.Location })
			actor.AttackMove(PB1.Location)
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if A1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A1.Location })
				actor.AttackMove(PA1.Location)
			end
		end
		if A2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = A2.Location })
				actor.AttackMove(PB1.Location)
			end
		end
	end
end

SpawnEnemiesBs = function()
	local scouts = rounds
	local warriors = math.floor(rounds / 5)
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		scouts = 5 + math.floor(rounds / 10)
	end
	if warriors > 3 then
		warriors = 3
	end
	if rounds > 10 then
		randoms = Utils.RandomInteger(1, 3)
		randoms = randoms + math.floor(rounds / 10)
		randomNum = Utils.RandomInteger(3, 9)
	end
	if B1.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = B1.Location })
			actor.AttackMove(PA6.Location)
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = B1.Location })
			actor.AttackMove(PA6.Location)
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B1.Location })
			actor.AttackMove(PA6.Location)
		end
	end
	if B2.IsDead == false then
		for i = 1, scouts do
			local actor = Actor.Create(enemies[1], true, { Owner = creep, Location = B2.Location })
			actor.AttackMove(PB6.Location)
		end
		for i = 1, warriors do
			local actor = Actor.Create(enemies[2], true, { Owner = creep, Location = B2.Location })
			actor.AttackMove(PB6.Location)
		end
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B2.Location })
			actor.AttackMove(PB6.Location)
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if B1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B1.Location })
				actor.AttackMove(PA6.Location)
			end
		end
		if B2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = B2.Location })
				actor.AttackMove(PB6.Location)
			end
		end
	end
end

SpawnEnemiesCs = function()
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		randoms = Utils.RandomInteger(1, 3)
		randoms = randoms + math.floor(rounds / 10)
		randomNum = Utils.RandomInteger(3, 9)
	end
	if C1.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C1.Location })
			actor.AttackMove(PB1.Location)
		end
	end
	if C2.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C2.Location })
			actor.AttackMove(PA1.Location)
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if C1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C1.Location })
				actor.AttackMove(PB1.Location)
			end
		end
		if C2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = C2.Location })
				actor.AttackMove(PA1.Location)
			end
		end
	end
end

SpawnEnemiesDs = function()
	local randoms = 0
	local randomNum = 0
	if rounds > 5 then
		randoms = Utils.RandomInteger(1, 4)
		randoms = randoms + math.floor(rounds / 10)
		randomNum = Utils.RandomInteger(3, 9)
	end
	if D1.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D1.Location })
			actor.AttackMove(PA4.Location)
		end
	end
	if D2.IsDead == false then
		for i = 1, randoms do
			local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D2.Location })
			actor.AttackMove(PB4.Location)
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if D1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D1.Location })
				actor.AttackMove(PA4.Location)
			end
		end
		if D2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = D2.Location })
				actor.AttackMove(PB4.Location)
			end
		end
	end
end

SpawnEnemiesEs = function()
	local drones = math.floor(rounds / 6)
	if E1.IsDead == false then
		for i = 1, drones do
			local actor = Actor.Create(enemies[10], true, { Owner = creep, Location = E1.Location })
			actor.AttackMove(PA3.Location)
		end
	end
	if E2.IsDead == false then
		for i = 1, drones do
			local actor = Actor.Create(enemies[10], true, { Owner = creep, Location = E2.Location })
			actor.AttackMove(PB3.Location)
		end
	end
	local colonies = creep.GetActorsByType("antcolony.spawner")
	local destroyed = 10 - #colonies
	local randomNum = Utils.RandomInteger(3, 9)
	if destroyed > 0 then
		if E1.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = E1.Location })
				actor.AttackMove(PA3.Location)
			end
		end
		if E2.IsDead == false then
			for i = 1, math.floor(destroyed / 2) + 1 do
				local actor = Actor.Create(enemies[randomNum], true, { Owner = creep, Location = E2.Location })
				actor.AttackMove(PB3.Location)
			end
		end
	end
end

SpawnGigantus = function()
	local player0Briks = {}
	local player1Briks = {}
	local spawns = {}
	local closestSpawn = nil
	player0Briks = player0.GetActorsByType("brik")
	player1Briks = player1.GetActorsByType("brik")
	if #player0Briks > 0 then
		local randomSpawn = Utils.RandomInteger(1, 6)
		spawns = creep.GetActorsByType("antcolony.spawner")
		prevDist = 100000000
		if #spawns > 0 then
			for i = 1, #spawns do
				local xd = spawns[i].Location.X - player0Briks[1].Location.X
				local yd = spawns[i].Location.Y - player0Briks[1].Location.Y
				local distance = math.sqrt((xd * xd) + (yd * yd))
				if distance < prevDist then
					closestSpawn = spawns[i]
					prevDist = distance
				end
			end
			local actor = Actor.Create(enemies[4], true, { Owner = creep, Location = closestSpawn.Location })
			actor.AttackMove(player0Briks[1].Location)
		end
	end
	prevDist = 100000000
	if #player1Briks > 0 then
		local randomSpawn = Utils.RandomInteger(1, 6)
		spawns = creep.GetActorsByType("antcolony.spawner")
		prevDist = 100000000
		if #spawns > 0 then
			for i = 1, #spawns do
				local xd = spawns[i].Location.X - player1Briks[1].Location.X
				local yd = spawns[i].Location.Y - player1Briks[1].Location.Y
				local distance = math.sqrt((xd * xd) + (yd * yd))
				if distance < prevDist then
					closestSpawn = spawns[i]
					prevDist = distance
				end
			end
			local actor = Actor.Create(enemies[4], true, { Owner = creep, Location = closestSpawn.Location })
			actor.AttackMove(player1Briks[1].Location)
		end
	end
	Trigger.AfterDelay(DateTime.Seconds(65), function()
		SpawnGigantus()
	end)
end

WakeyWakey = function()
	local allActors = creep.GetActors()
	local looper = 1
	for i = 1, #enemies do
		local baddies = creep.GetActorsByType(enemies[i])
		if #baddies > 0 then
			for a = 1, #baddies do
				if baddies[a].IsIdle == true then
					baddies[a].Stop()
					baddies[a].Hunt()
				end
			end
		end
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		WakeyWakey()
	end)
end

WakeyWakeyZombos = function()
	local allActors = zombos.GetActors()
	local looper = 1
	for i = 1, #enemies do
		local baddies = zombos.GetActorsByType("zombie", "zombie2")
		if #baddies > 0 then
			for a = 1, #baddies do
				if baddies[a].IsIdle == true then
					baddies[a].Stop()
					baddies[a].Hunt()
				end
			end
		end
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		WakeyWakeyZombos()
	end)
end

WorldLoaded = function()
	StartingTexts()
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")
	InitializeAndSpawnsAndEnemies()
	Trigger.AfterDelay(DateTime.Seconds(480), function()
		SpawnGigantus()
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		WakeyWakey()
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		WakeyWakeyZombos()
	end)
	Trigger.AfterDelay(DateTime.Seconds(30), function()
		SpawnEnemies()
	end)
	Trigger.AfterDelay(DateTime.Seconds(30), function()
		SpawnZombies()
	end)
end


