aspawns = {}
bspawns = {}
escalation = 0
rounds = 0

SetCamera = function(player)
	local mcv = player.GetActorsByType("bio")[1]
	Camera.Position = mcv.CenterPosition
end

SetSpawns = function()
	aspawns[1] = spawn1a.Location
	aspawns[2] = spawn2a.Location
	aspawns[3] = spawn3a.Location
	aspawns[4] = spawn4a.Location
	aspawns[5] = spawn5a.Location
	aspawns[6] = spawn6a.Location
	bspawns[1] = spawn1b.Location
	bspawns[2] = spawn2b.Location
	bspawns[3] = spawn3b.Location
	bspawns[4] = spawn4b.Location
	bspawns[5] = spawn5b.Location
	bspawns[6] = spawn6b.Location
end

SpawnZombies = function()
	rounds = rounds + 1
	if rounds > ((escalation + 1) * 5) then
		escalation = escalation + 1
	end
	local randomSpawn = Utils.RandomInteger(1,7)
	local zombos = Utils.RandomInteger(1,(escalation + 1))
	local spawntime = Utils.RandomInteger(1,10)
	SpawnZombiesForA(randomSpawn,zombos)
	SpawnZombiesForB(randomSpawn,zombos)
	Trigger.AfterDelay(DateTime.Seconds(spawntime), function()
		SpawnZombies()
	end)
end

SpawnZombiesForA = function(position,number)
	local creeps = Player.GetPlayer("Creeps")
	while number > 0 do
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = aspawns[position] })
		actor.AttackMove(basea.Location)
		number = number - 1
	end
end

SpawnZombiesForB = function(position,number)
	local creeps = Player.GetPlayer("Creeps")
	while number > 0 do
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = bspawns[position] })
		actor.AttackMove(baseb.Location)
		number = number - 1
	end
end

StartingTexts = function()
	Media.DisplayMessage("Thanks to the evacuated scientists we have located a Biolab that contains information on the location of the Gerasene Research Facility, which might contain a cure for the Lazarene plague.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Our intel tells that our enemies have found a similiar Biolab.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Defend the Biolab as long as you can, so we can gather all relevant information from it.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

WorldLoaded = function()
	SetSpawns()
	StartingTexts()
	Trigger.AfterDelay(DateTime.Seconds(20), function()
		SpawnZombies()
	end)
	local player0 = Player.GetPlayer("Multi0")
	local player1 = Player.GetPlayer("Multi1")
	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
	player0.Cash = 500
	player1.Cash = 500
end


