ascore = 0
bscore = 0
gametimer = 480
evacuees = {}
tie = false

SetCamera = function(player)
	local mcv = player.GetActorsByType("jeep")[1]
	Camera.Position = mcv.CenterPosition
end


StartingTexts = function()
	Media.DisplayMessage("We have located the secret living quarters of some of the top scientists working on the Lazarene plague.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("They might have knowledge on a possible cure for the disease.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Save as many scientist you can before our enemies get their hands on the researchers first.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

SpawnZombies = function()
	local creeps = Player.GetPlayer("Creeps")
	local randomCell = Map.RandomEdgeCell()
	local oppositeCell = CPos.New(101 - randomCell.X, 101 - randomCell.Y)
	local cellToMove = Map.RandomCell()
	local howMany = Utils.RandomInteger(1, 5)
	while howMany > 0 do
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = randomCell })
		MoveToCell(actor, cellToMove)
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = oppositeCell })
		MoveToCell(actor, CPos.New(101 - cellToMove.X, 101 - cellToMove.Y))
		howMany = howMany - 1
	end
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 20)), function()
		SpawnZombies()
	end)
end

MoveToCell = function(moved,cell)
	if moved.IsDead == false then
		moved.Scatter()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			if moved.IsDead == false then
				moved.AttackMove(cell)
				Trigger.OnDiscovered(moved, StopMe)
			end
		end)
	end
end

StopMe = function(discovered,discoverer)
	if discovered.IsDead == false then
		discovered.Stop()
	end
end

Evacuees = function()
	evacuees = Player.GetPlayer("Neutral").GetActorsByType("giftpointer")
	for i = 1, #evacuees do
		Trigger.OnEnteredFootprint({evacuees[i].Location},EnteredFootprint)
	end
end

EnteredFootprint = function(enterer, id)
	if enterer.Type == "jeep" then
		if enterer.AmmoCount("primary") == 0 then
			enterer.Reload("primary",1)
			for i = 1, #evacuees do
				if evacuees[i].Location == enterer.Location then
					local tobedestroyed = evacuees[i]
					evacuees[i] = goal2
					tobedestroyed.Destroy()
				end
			end
			Trigger.RemoveFootprintTrigger(id)
		end
	end
end

ScoreTeamOne = function(enterer, id)
	if enterer.Type == "jeep" and enterer.Owner == Player.GetPlayer("Multi0") then
		if enterer.AmmoCount("primary") == 1 then
			enterer.Reload("primary",-1)
			ascore = ascore + 1
		end
	end
end

ScoreTeamTwo = function(enterer, id)
	if enterer.Type == "jeep" and enterer.Owner == Player.GetPlayer("Multi1") then
		if enterer.AmmoCount("primary") == 1 then
			enterer.Reload("primary",-1)
			bscore = bscore + 1
		end
	end
end

UpdateScore = function()
	local minutes = math.floor(gametimer / 60)
	local seconds = gametimer - (minutes * 60)
	local timetext = ""
	if seconds < 10 then
		timetext = "Time left: " .. minutes .. ":0" .. seconds .. ""
	else
		timetext = "Time left: " .. minutes .. ":" .. seconds .. ""
	end
	if gametimer < 1 then
		if tie == true then
			timetext = "Break the tie by destroying the other player's Jeep or by rescuing a scientist!"
		elseif tie == false then
			timetext = "Time is up!"
		end
		DecideWinner()
	end
	local text = ""
	text = "\nEvacuated scientists:\n"
	if Player.GetPlayer("Multi0") ~= nil then
		text = text .. Player.GetPlayer("Multi0").Name .. ": " .. ascore .. "\n"
	end
	if Player.GetPlayer("Multi1") ~= nil then
		text = text .. Player.GetPlayer("Multi1").Name .. ": " .. bscore .. "\n"
	end
	UserInterface.SetMissionText(timetext .. text, HSLColor.White)
end

Timer = function()
	UpdateScore()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		gametimer = gametimer - 1
		Timer()
	end)
end

DecideWinner = function()
	if ascore == bscore then
		if p0jeep.IsDead == false and p1jeep.IsDead == false and tie == false then
			Media.DisplayMessage("Break the tie by destroying the other player's Jeep or by rescuing a scientist!")
			tie = true
		elseif p0jeep.IsDead == false then
			if p0pwr.IsDead == false then
				p0pwr.Destroy()
			end
		elseif p1jeep.IsDead == false then
			if p1pwr.IsDead == false then
				p1pwr.Destroy()
			end
		end
	elseif ascore > bscore then
		if p1pwr.IsDead == false then
			p1pwr.Destroy()
		end
	elseif bscore > ascore then
		if p0pwr.IsDead == false then
			p0pwr.Destroy()
		end
	end
end

CheckIfKilled = function()
	if p0jeep.IsDead == true and p1jeep.IsDead == true then
		DecideWinner()
	end
end

MakeZombiesStop = function()
	local startzombies = Player.GetPlayer("Creeps").GetActorsByType("zombie")
	for i = 1, #startzombies do
		Trigger.OnDiscovered(startzombies[i], StopMe)
	end
end

WorldLoaded = function()
	StartingTexts()
	SpawnZombies()
	MakeZombiesStop()
	Trigger.OnEnteredFootprint({goal1.Location},ScoreTeamOne)
	Trigger.OnEnteredFootprint({goal2.Location},ScoreTeamTwo)
	Trigger.OnKilled(p0jeep,CheckIfKilled)
	Trigger.OnKilled(p1jeep,CheckIfKilled)
	Evacuees()
	Timer()
	local player0 = Player.GetPlayer("Multi0")
	local player1 = Player.GetPlayer("Multi1")
	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
end


