p0points = 0
p1points = 0
winninpoints = 250

InitializeGame = function()
	SpawnUnits(a11,a12,b11,b12,1)
	Trigger.OnEnteredFootprint({a12.Location}, function(a,id)
		a.Destroy()
	end)
	Trigger.OnEnteredFootprint({b12.Location}, function(a,id)
		a.Destroy()
	end)
	SpawnUnits(a22,a21,b22,b21,2)
	Trigger.OnEnteredFootprint({a21.Location}, function(a,id)
		a.Destroy()
	end)
	Trigger.OnEnteredFootprint({b21.Location}, function(a,id)
		a.Destroy()
	end)
	SpawnUnits(a31,a32,b31,b32,3)
	Trigger.OnEnteredFootprint({a32.Location}, function(a,id)
		a.Destroy()
	end)
	Trigger.OnEnteredFootprint({b32.Location}, function(a,id)
		a.Destroy()
	end)
	SpawnUnits(a42,a41,b42,b41,4)
	Trigger.OnEnteredFootprint({a41.Location}, function(a,id)
		a.Destroy()
	end)
	Trigger.OnEnteredFootprint({b41.Location}, function(a,id)
		a.Destroy()
	end)
end

SpawnUnits = function(startpoint, endpoint, startpoint2, endpoint2, tier)
	local level = Utils.RandomInteger(0,5)
	level = level + tier
	local neutral = Player.GetPlayer("Neutral")
	local actor = Actor.Create("zombie", true, { Owner = neutral, Location = startpoint.Location })
	TierGiver(actor, level)
	actor.AttackMove(endpoint.Location)
	Trigger.OnKilled(actor, GiveScore)
	local actor = Actor.Create("zombie", true, { Owner = neutral, Location = startpoint2.Location })
	TierGiver(actor, level)
	actor.AttackMove(endpoint2.Location)
	Trigger.OnKilled(actor, GiveScore)
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1,12)), function()
		SpawnUnits(startpoint,endpoint,startpoint2,endpoint2,tier)
	end)
end

TierGiver = function(actor,level)
	if level == 1 then
		actor.GrantCondition("tier0")
		actor.AddTag("tier0")
	elseif level == 2 then
		actor.GrantCondition("tier1")
		actor.AddTag("tier1")
	elseif level == 3 then
		actor.GrantCondition("tier2")
		actor.AddTag("tier2")
	elseif level == 4 then
		actor.GrantCondition("tier3")
		actor.AddTag("tier3")
	elseif level == 5 then
		actor.GrantCondition("tier4")
		actor.AddTag("tier4")
	elseif level == 6 then
		actor.GrantCondition("tier5")
		actor.AddTag("tier5")
	elseif level == 7 then
		actor.GrantCondition("tier6")
		actor.AddTag("tier6")
	elseif level == 8 then
		actor.GrantCondition("tier7")
		actor.AddTag("tier7")
	elseif level == 9 then
		actor.GrantCondition("tier8")
		actor.AddTag("tier8")
	elseif level > 9 then
		actor.GrantCondition("tier9")
		actor.AddTag("tier9")
	end
end

GiveScore = function(self,killer)
	if self.HasTag("tier0") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " loses 20 points.")
		UpdateScore(killer.Owner,-20)
	elseif self.HasTag("tier1") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " loses 15 points.")
		UpdateScore(killer.Owner,-15)
	elseif self.HasTag("tier2") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " loses 10 points.")
		UpdateScore(killer.Owner,-10)
	elseif self.HasTag("tier3") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " loses 5 points.")
		UpdateScore(killer.Owner,-5)
	elseif self.HasTag("tier4") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " gains 5 points.")
		UpdateScore(killer.Owner,5)
	elseif self.HasTag("tier5") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " gains 10 points.")
		UpdateScore(killer.Owner,10)
	elseif self.HasTag("tier6") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " gains 15 points.")
		UpdateScore(killer.Owner,15)
	elseif self.HasTag("tier7") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " gains 20 points.")
		UpdateScore(killer.Owner,20)
	elseif self.HasTag("tier8") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " gains 25 points.")
		UpdateScore(killer.Owner,25)
	elseif self.HasTag("tier9") == true then
		Media.DisplayMessage("" .. killer.Owner.Name .. " gains 30 points.")
		UpdateScore(killer.Owner,30)
	end
end

UpdateScore = function(player,points)
	if player == Player.GetPlayer("Multi0") then
		p0points = p0points + points
	elseif player == Player.GetPlayer("Multi1") then
		p1points = p1points + points
	end
	if p0points > (winninpoints - 1) then
		p1arty.Kill()
	elseif p1points > (winninpoints - 1) then
		p0arty.Kill()
	end
	UserInterface.SetMissionText("" .. Player.GetPlayer("Multi0").Name .. ":  " .. p0points .. "\n" .. Player.GetPlayer("Multi1").Name .. ":  " .. p1points .. "")
end

StartingTexts = function()
	Media.DisplayMessage("An undead apocalypse is not without it's perks.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("We have gathered a horde of the undead for our artillery training purposes.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("The first player to reach " .. winninpoints .. " points wins! Beaware that each zombie has it's own score amount attached to it.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Good luck commander!")
		InitializeGame()
	end)
end

WorldLoaded = function()
	StartingTexts()
	UpdateScore(Player.GetPlayer("Multi0"),0)
	UpdateScore(Player.GetPlayer("Multi1"),0)
end