ascore = 0
bscore = 0
gametimer = 480

SetCamera = function(player)
	local mcv = player.GetActorsByType("jeep")[1]
	Camera.Position = mcv.CenterPosition
end


StartingTexts = function()
	Media.DisplayMessage("We are quickly running out of bullets fighting the undead.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Use your jeep to lure the undead into our pyre.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("The commander who lures more of the undead into their pyre in 8 minutes wins.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

ScoreForA = function()
	Trigger.OnEnteredFootprint({p0goal.Location}, function(a,id)
		if a.Type ~= "jeep" and a.Type ~= "empty32" then
			Trigger.AfterDelay(10, function()
				a.Kill("FireDeath")
				ascore = ascore + 1
				UpdateScore()
			end)
		end
	end)
end

ScoreForB = function()
	Trigger.OnEnteredFootprint({p1goal.Location}, function(a,id)
		if a.Type ~= "jeep" and a.Type ~= "empty32" then
			Trigger.AfterDelay(10, function()
				a.Kill("FireDeath")
				bscore = bscore + 1
				UpdateScore()
			end)
		end
	end)
end

UpdateScore = function()
	local minutes = math.floor(gametimer / 60)
	local seconds = gametimer - (minutes * 60)
	local timetext = ""
	if seconds < 10 then
		timetext = "Time left: " .. minutes .. ":0" .. seconds .. ""
	else
		timetext = "Time left: " .. minutes .. ":" .. seconds .. ""
	end
	if gametimer < 1 then
		timetext = "Time is up!"
		DecideWinner()
	end
	local text = ""
	text = "\nKilled undead:\n"
	if Player.GetPlayer("Multi0") ~= nil then
		text = text .. Player.GetPlayer("Multi0").Name .. ": " .. ascore .. "\n"
	end
	if Player.GetPlayer("Multi1") ~= nil then
		text = text .. Player.GetPlayer("Multi1").Name .. ": " .. bscore .. "\n"
	end
	UserInterface.SetMissionText(timetext .. text, HSLColor.White)
end

Timer = function()
	UpdateScore()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		gametimer = gametimer - 1
		Timer()
	end)
end

DecideWinner = function()
	if ascore == bscore then
		gametimer = 30
		Media.DisplayMessage("The score is even! You are granted 30 extra seconds to break the tie!")
	elseif ascore > bscore then
		if p1pwr.IsDead == false then
			p1pwr.Destroy()
		end
	elseif bscore > ascore then
		if p0pwr.IsDead == false then
			p0pwr.Destroy()
		end
	end
end

SpawnZombies = function()
	local creeps = Player.GetPlayer("Creeps")
	local randomCell = Map.RandomEdgeCell()
	local oppositeCell = CPos.New(61 - randomCell.X, 61 - randomCell.Y)
	local cellToMove = Map.RandomCell()
	local howMany = Utils.RandomInteger(1, 5)
	while howMany > 0 do
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = randomCell })
		MoveToCell(actor, cellToMove)
		local actor = Actor.Create("zombie", true, { Owner = creeps, Location = oppositeCell })
		MoveToCell(actor, CPos.New(61 - cellToMove.X, 61 - cellToMove.Y))
		howMany = howMany - 1
	end
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(1, 20)), function()
		SpawnZombies()
	end)
end

MoveToCell = function(moved,cell)
	if moved.IsDead == false then
		moved.Scatter()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			if moved.IsDead == false then
				moved.AttackMove(cell)
				Trigger.OnDiscovered(moved, StopMe)
			end
		end)
	end
end

StopMe = function(discovered,discoverer)
	if discovered.IsDead == false then
		discovered.Stop()
	end
end

CheckIfJeepsExist = function()
	if p0jeep.IsDead == true and p1jeep.IsDead == true then
		DecideWinner()
	end
end

WorldLoaded = function()
	StartingTexts()
	ScoreForA()
	ScoreForB()
	SpawnZombies()
	CheckIfJeepsExist()
	Timer()
	local player0 = Player.GetPlayer("Multi0")
	local player1 = Player.GetPlayer("Multi1")
	if player0.IsLocalPlayer then
		SetCamera(player0)
	elseif player1.IsLocalPlayer then
		SetCamera(player1)
	end
end


