units = {}
eliminatetimer = 600
winnerscore = 0
winner = nil
players = {}

SpawnUnits = function()
	local creeps = Player.GetPlayer("Creeps")
	local randomCell = Map.RandomEdgeCell()
	local actor = Actor.Create(units[Utils.RandomInteger(0,8)], true, { Owner = creeps, Location = randomCell })
	MoveToCell(actor)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		SpawnUnits()
	end)
end

MoveToCell = function(actor)
	local randomTargetCell = Map.RandomEdgeCell()
	if actor.IsDead == false then
		if actor.IsIdle == true then
			actor.AttackMove(randomTargetCell)
		end
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			MoveToCell(actor)
		end)
	end
end

ChangeUnits = function ()
	units[0] = "e1"
	units[1] = "e2"
	units[2] = "e3"
	units[3] = "e4"
	units[4] = "shok"
	units[5] = "spy"
	units[6] = "medi"
	units[7] = "mech"
end

InitializeUnits = function ()
	units[0] = "e1"
	units[1] = "e1"
	units[2] = "e1"
	units[3] = "e2"
	units[4] = "e2"
	units[5] = "e3"
	units[6] = "medi"
	units[7] = "mech"
end

InitializeGame = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Media.DisplayMessage("We need to do more test on this undead mind control research.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("You have been moved to a neutral country to test and spread the undead disease. Our enemies seem to be doing the same.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(9), function()
		Media.DisplayMessage("You must infect as many humans with your strain as you can for research purposes.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(13), function()
		Media.DisplayMessage("You have 10 minutes to destroy all other strains or assert your dominance by killing as many of their undead as you can!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(17), function()
		Media.DisplayMessage("The strain that has killed the most zombies of other strains and still exists at that time wins!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(21), function()
		local allActors = Map.ActorsInWorld
		SpawnUnits()
		for i = 1, #allActors do
			if allActors[i].Type == "zombie" then
				allActors[i].GrantCondition("gameplay")
				TimerText()
			end
		end
	end)
end

TimerText = function()
	if eliminatetimer >= 0 then
		local minutes = math.floor(eliminatetimer / 60)
		local seconds = eliminatetimer - (minutes * 60)
		local timetext = ""
		if seconds < 10 then
			timetext = "" .. minutes .. ":0" .. seconds .. ""
		else
			timetext = "" .. minutes .. ":" .. seconds .. ""
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			eliminatetimer = eliminatetimer - 1
			UserInterface.SetMissionText("Time left : " .. timetext, HSLColor.White)
			TimerText()
		end)
		if eliminatetimer == 40 then
			ChangeUnits()
		end
	elseif eliminatetimer < 0 then
		DecideWinner()
	end
end

DecideWinner = function()
	local tie = false
	for i = 1, #players do
		if players[i].Experience > winnerscore then
			winnerscore = players[i].Experience
			winner = players[i]
		end
	end
	for i = 1, #players do
		if players[i].Experience == winnerscore and players[i] ~= winner then
			tie = true
		end
	end
	if tie == true then
		eliminatetimer = 60
		TimerText()
		Media.DisplayMessage("There is a tie! One extra minute has been added to the timer!")
	else
		Media.DisplayMessage("" .. winner.Name .. " wins!")
		for i = 1, #players do
			if players[i] ~= winner then
				players[i].MarkFailedObjective(0)
			end
		end
	end
end

WorldLoaded = function()
	if Player.GetPlayer("Multi0") ~= nil then
		players[1] = Player.GetPlayer("Multi0")
	end
	if Player.GetPlayer("Multi1") ~= nil then
		players[2] = Player.GetPlayer("Multi1")
	end
	if Player.GetPlayer("Multi2") ~= nil then
		players[3] = Player.GetPlayer("Multi2")
	end
	if Player.GetPlayer("Multi3") ~= nil then
		players[4] = Player.GetPlayer("Multi3")
	end
	InitializeUnits()
	InitializeGame()
end