FindBiolabs = function()
	local neutral = Player.GetPlayer("Neutral")
	local biolabs = neutral.GetActorsByType("bio")
	for i = 1, #biolabs do
		WhenCapped(biolabs[i])
	end
end

WhenCapped = function(biolab)
	Trigger.OnCapture(biolab,BiolabProduce)
	Trigger.OnKilled(biolab,SpawnReplacementBiolab)
end

BiolabProduce = function(biolab)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		if biolab.IsDead == false then
			local actor = Actor.Create("zombie", true, { Owner = biolab.Owner, Location = biolab.Location })
			actor.Scatter()
			BiolabProduce(biolab)
		end
	end)
end

SpawnReplacementBiolab = function(biolab)
	local actor = Actor.Create("bio", true, { Owner = Player.GetPlayer("Neutral"), Location = biolab.Location })
	Trigger.OnCapture(actor,BiolabProduce)
end

StartingTexts = function()
	Media.DisplayMessage("The research papers we took from the Lazarus Compound indicate that this area has a large amount of research facilities regarding the Lazarus virus.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("It seems the scientists here were trying to use the Lazarus virus for mind control purposes.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Capture as many of the research facilities you can.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("However our intel tells us that our enemies have similiar intentions. Destroy their base and kill them all!")
	end)
	Trigger.AfterDelay(DateTime.Seconds(20), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

SpawnNewEngie = function(engie)
	Trigger.OnKilled(engie,SpawnReplacementEngie)
end

SpawnReplacementEngie = function(engie)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		if engie.Owner == Player.GetPlayer("Multi0") or engie.Owner == Player.GetPlayer("Multi1") or engie.Owner == Player.GetPlayer("Multi2") or engie.Owner == Player.GetPlayer("Multi3") then
			if t1hosp.IsDead == false then
				local actor = Actor.Create("e6", true, { Owner = engie.Owner, Location = t1hosp.Location })
				SpawnNewEngie(actor)
				actor.Scatter()
			end
		elseif engie.Owner == Player.GetPlayer("Multi4") or engie.Owner == Player.GetPlayer("Multi5") or engie.Owner == Player.GetPlayer("Multi6") or engie.Owner == Player.GetPlayer("Multi7") then
			if t2hosp.IsDead == false then
				local actor = Actor.Create("e6", true, { Owner = engie.Owner, Location = t2hosp.Location })
				SpawnNewEngie(actor)
				actor.Scatter()
			end
		end
	end)
end

TeamOneLoses = function(hosp)
	if p0.IsDead == false then
		p0.Kill()
	end
	if p1.IsDead == false then
		p1.Kill()
	end
	if p2.IsDead == false then
		p2.Kill()
	end
	if p3.IsDead == false then
		p3.Kill()
	end
end

TeamTwoLoses = function(hosp)
	if p4.IsDead == false then
		p4.Kill()
	end
	if p5.IsDead == false then
		p5.Kill()
	end
	if p6.IsDead == false then
		p6.Kill()
	end
	if p7.IsDead == false then
		p7.Kill()
	end
end

WorldLoaded = function()
	FindBiolabs()
	StartingTexts()
	SpawnNewEngie(m0)
	SpawnNewEngie(m1)
	SpawnNewEngie(m2)
	SpawnNewEngie(m3)
	SpawnNewEngie(m4)
	SpawnNewEngie(m5)
	SpawnNewEngie(m6)
	SpawnNewEngie(m7)
	Trigger.OnKilled(t1hosp,TeamOneLoses)
	Trigger.OnKilled(t2hosp,TeamTwoLoses)
end


