SetFindableUnits = function()
	local types = {"e6", "shok", "e4", "e1"}
	local allFindables = Player.GetPlayer("Neutral").GetActorsByTypes(types)
	for i = 1, #allFindables do
		Trigger.OnDiscovered(allFindables[i], GiftToNew)
	end
end

SetCameraT1 = function()
	Camera.Position = t1spawn.CenterPosition
end

SetCameraT2 = function()
	Camera.Position = t2spawn.CenterPosition
end

GiftToNew = function(unit, discoverer)
	if discoverer ~= Player.GetPlayer("Creeps") and discoverer ~= Player.GetPlayer("Neutral") then
		unit.Owner = discoverer
		if discoverer.IsLocalPlayer == true then
			if unit.Type == "e6" then
				Media.DisplayMessage("Engineer: Thanks for rescuing me! I know nothing what's going on in here, I just work in sewege management!")
			elseif unit.Type == "shok" then
				Media.DisplayMessage("Shock Trooper: Thanks for rescuing me! I know nothing what's going on in here. I just work security here!")
			elseif unit.Type == "e4" then
				Media.DisplayMessage("Flamethrower: Thanks for rescuing me! I know nothing what's going on in here. I just work security here!")
			elseif unit.Type == "e1" then
				Media.DisplayMessage("Rifleman: Thanks for rescuing me! I know nothing what's going on in here. I just work security here!")
			end
		end
		Trigger.ClearAll(unit)
	end
end

CheckIfDead = function()
	local types = {"e6", "shok", "e4", "e1"}
	if #Player.GetPlayer("Multi0").GetActorsByTypes(types) + #Player.GetPlayer("Multi1").GetActorsByTypes(types) + #Player.GetPlayer("Multi2").GetActorsByTypes(types) + #Player.GetPlayer("Multi3").GetActorsByTypes(types) + #Player.GetPlayer("Multi4").GetActorsByTypes(types) == 0 then
		Player.GetPlayer("Multi0").MarkFailedObjective(0)
		Player.GetPlayer("Multi1").MarkFailedObjective(0)
		Player.GetPlayer("Multi2").MarkFailedObjective(0)
		Player.GetPlayer("Multi3").MarkFailedObjective(0)
		Player.GetPlayer("Multi4").MarkFailedObjective(0)
		Media.DisplayMessage("The first team loses!")
	end
	if #Player.GetPlayer("Multi5").GetActorsByTypes(types) + #Player.GetPlayer("Multi6").GetActorsByTypes(types) + #Player.GetPlayer("Multi7").GetActorsByTypes(types) + #Player.GetPlayer("Multi8").GetActorsByTypes(types) + #Player.GetPlayer("Multi9").GetActorsByTypes(types) == 0 then
		Player.GetPlayer("Multi5").MarkFailedObjective(0)
		Player.GetPlayer("Multi6").MarkFailedObjective(0)
		Player.GetPlayer("Multi7").MarkFailedObjective(0)
		Player.GetPlayer("Multi8").MarkFailedObjective(0)
		Player.GetPlayer("Multi9").MarkFailedObjective(0)
		Media.DisplayMessage("The second team loses!")
	end
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		CheckIfDead()
	end)
end

StartingTexts = function()
	Media.DisplayMessage("We have received a distress call from this location.")
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("It appears to be a research laboratory of sorts of unknown origin.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Investigate the facility and the research conducted within.")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Good luck commander!")
	end)
end

WinGame = function(enterer, id)
	if enterer.Owner == Player.GetPlayer("Multi0") or enterer.Owner == Player.GetPlayer("Multi1") or enterer.Owner == Player.GetPlayer("Multi2") or enterer.Owner == Player.GetPlayer("Multi3") or enterer.Owner == Player.GetPlayer("Multi4") then
		Player.GetPlayer("Multi5").MarkFailedObjective(0)
		Player.GetPlayer("Multi6").MarkFailedObjective(0)
		Player.GetPlayer("Multi7").MarkFailedObjective(0)
		Player.GetPlayer("Multi8").MarkFailedObjective(0)
		Player.GetPlayer("Multi9").MarkFailedObjective(0)
		Media.DisplayMessage("Team one has located the inner research rooms!")
	elseif enterer.Owner == Player.GetPlayer("Multi5") or enterer.Owner == Player.GetPlayer("Multi6") or enterer.Owner == Player.GetPlayer("Multi7") or enterer.Owner == Player.GetPlayer("Multi8") or enterer.Owner == Player.GetPlayer("Multi9") then
		Player.GetPlayer("Multi0").MarkFailedObjective(0)
		Player.GetPlayer("Multi1").MarkFailedObjective(0)
		Player.GetPlayer("Multi2").MarkFailedObjective(0)
		Player.GetPlayer("Multi3").MarkFailedObjective(0)
		Player.GetPlayer("Multi4").MarkFailedObjective(0)
		Media.DisplayMessage("Team two has located the inner research rooms!")
	end
end

WorldLoaded = function()
	CheckIfDead()
	SetFindableUnits()
	StartingTexts()
	Trigger.OnEnteredFootprint({goal1.Location},WinGame)
	Trigger.OnEnteredFootprint({goal2.Location},WinGame)
	if Player.GetPlayer("Multi0").IsLocalPlayer then
		SetCameraT1()
	elseif Player.GetPlayer("Multi1").IsLocalPlayer then
		SetCameraT1()
	elseif Player.GetPlayer("Multi2").IsLocalPlayer then
		SetCameraT1()
	elseif Player.GetPlayer("Multi3").IsLocalPlayer then
		SetCameraT1()
	elseif Player.GetPlayer("Multi4").IsLocalPlayer then
		SetCameraT1()
	elseif Player.GetPlayer("Multi5").IsLocalPlayer then
		SetCameraT2()
	elseif Player.GetPlayer("Multi6").IsLocalPlayer then
		SetCameraT2()
	elseif Player.GetPlayer("Multi7").IsLocalPlayer then
		SetCameraT2()
	elseif Player.GetPlayer("Multi8").IsLocalPlayer then
		SetCameraT2()
	elseif Player.GetPlayer("Multi9").IsLocalPlayer then
		SetCameraT2()
	end
end