SaboteurPaths =
{
	{ SaboteurPoint1.Location, SaboteurPoint2.Location, SaboteurPoint3.Location, SaboteurPoint4.Location },
	{ SaboteurPoint5.Location, SaboteurPoint6.Location, SaboteurPoint7.Location, SaboteurPoint8.Location }
}

SaboteurPaths2 =
{
	{ SaboteurPoint9.Location, SaboteurPoint10.Location },
	{ SaboteurPoint11.Location, SaboteurPoint12.Location }
}

GetSaboteurTargets = function(Multi0)
	return Utils.Where(Multi0.GetActors(), function(actor)
		return
			actor.HasProperty("Sell") and
			actor.Type ~= "wall" and
			actor.Type ~= "medium_gun_turret" and
			actor.Type ~= "large_gun_turret" and
			actor.Type ~= "silo"
	end)
end

GetSaboteurTargets1 = function(Multi3)
	return Utils.Where(Multi3.GetActors(), function(actor)
		return
			actor.HasProperty("Sell") and
			actor.Type ~= "wall" and
			actor.Type ~= "medium_gun_turret" and
			actor.Type ~= "large_gun_turret" and
			actor.Type ~= "silo"
	end)
end

BuildSaboteur = function()
	if OrdosPalace.IsDead or OrdosPalace.Owner ~= Ordos then
		return
	end

	local targets = GetSaboteurTargets(Multi0)
	if #targets > 0 then
		local saboteur = Actor.Create("saboteur", true, { Owner = Ordos, Location = OrdosPalace.Location + CVec.New(0, 2) })
		saboteur.Move(saboteur.Location + CVec.New(0, 1))
		saboteur.Wait(DateTime.Seconds(5))

		local path = Utils.Random(SaboteurPaths)
		saboteur.Move(path[1])
		saboteur.Move(path[2])

		SendSaboteur(saboteur)
	end

	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(30), BuildSaboteur)
end

BuildSaboteur1 = function()
	if OrdosPalace.IsDead or OrdosPalace.Owner ~= Ordos then
		return
	end

	local targets = GetSaboteurTargets1(Multi3)
	if #targets > 0 then
		local saboteur = Actor.Create("saboteur", true, { Owner = Ordos, Location = OrdosPalace.Location + CVec.New(0, 2) })
		saboteur.Move(saboteur.Location + CVec.New(1, 1))
		saboteur.Wait(DateTime.Seconds(5))

		local path = Utils.Random(SaboteurPaths2)
		saboteur.Move(path[1])
		saboteur.Move(path[2])

		SendSaboteur1(saboteur)
	end

	Trigger.AfterDelay(DateTime.Minutes(3), BuildSaboteur1)
end

SendSaboteur = function(saboteur)
	local targets = GetSaboteurTargets(Multi0)
	if #targets < 1 then
		return
	end

	local target = Utils.Random(targets)
	saboteur.Demolish(target)

	-- 'target' got removed from the world in the meantime
	saboteur.CallFunc(function()
		SendSaboteur(saboteur)
	end)
end

SendSaboteur1 = function(saboteur)
	local targets = GetSaboteurTargets1(Multi3)
	if #targets < 1 then
		return
	end

	local target = Utils.Random(targets)
	saboteur.Demolish(target)

	-- 'target' got removed from the world in the meantime
	saboteur.CallFunc(function()
		SendSaboteur1(saboteur)
	end)
end

Tick = function()
	if Multi3.HasNoRequiredUnits() and Multi0.HasNoRequiredUnits() then
		Multi2.MarkCompletedObjective(KillAlied)
		Multi1.MarkCompletedObjective(KillAlied2)
		Ordos.MarkCompletedObjective(KillAlied4)
		Multi0.MarkFailedObjective(KillAlied)
		Multi3.MarkFailedObjective(KillAlied)
	end
	
	if Multi1.HasNoRequiredUnits() and  Ordos.HasNoRequiredUnits() and not Multi0.IsObjectiveCompleted(KillOrdos) and not Multi3.IsObjectiveCompleted(KillOrdos1) then
		Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.DisplayMessage("Ordos Destroyed!", "Mentat")
			Multi0.MarkCompletedObjective(KillOrdos)
			Multi3.MarkCompletedObjective(KillOrdos1)
		end)	
	end
	
	if Multi2.HasNoRequiredUnits() and not Multi0.IsObjectiveCompleted(KillAtreides) and not Multi3.IsObjectiveCompleted(KillAtreides1) then
		Media.DisplayMessage("Atreides Destroyed!", "Mentat")
		Trigger.AfterDelay(DateTime.Seconds(3), function()
			Multi0.MarkCompletedObjective(KillAtreides)
			Multi3.MarkCompletedObjective(KillAtreides1)
		end)	
	end
end

WorldLoaded = function()
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
	Ordos = Player.GetPlayer("Ordos")
	
	InitObjectives(Multi0)
	KillOrdos = Multi0.AddPrimaryObjective("Destroy the Ordos")
	KillOrdos1 = Multi3.AddPrimaryObjective("Destroyed the Ordos")
	KillAtreides = Multi0.AddPrimaryObjective("Destroyed the Atreides")
	KillAtreides1 = Multi3.AddPrimaryObjective("Destroyed the Atreides")
	KillAlied = Multi1.AddPrimaryObjective("Destroyed the Harkonnen")
	KillAlied2 = Multi2.AddPrimaryObjective("Destroyed the Harkonnen")
	KillAlied4 = Ordos.AddPrimaryObjective("Destroyed the Harkonnen")
	
	InitObjectives(Multi3)
	
	Trigger.AfterDelay(DateTime.Minutes(2) + DateTime.Seconds(30), BuildSaboteur)
	Trigger.AfterDelay(DateTime.Minutes(3), BuildSaboteur1)
	
	Trigger.OnObjectiveFailed(Multi3, function()
		Multi3.MarkFailedObjective(KillAlied)
	end)
	
	Trigger.OnObjectiveFailed(Multi0, function()
		Multi0.MarkFailedObjective(KillAlied)
	end)
	
end	