local GameStarted = false

local MicroActorTypes = {
    "dog", "e1", "e1r1", "e2", "e3r1", "e3", "e4", "spy", "spy.england", "e7", "medi", "thf", "mech",
    "shok", "sniper", "zombie", "ant", "scoutant", "warriorant", "fireant", "v2rl", "1tnk", "2tnk", "3tnk", "4tnk",
    "arty", "jeep", "apc", "mnly", "truk", "mgg", "mrj", "ttnk", "ftrk", "dtrk", "ctnk", "qtnk", "stnk",
    "badr", "badr.bomber", "mig", "yak", "tran", "heli", "hind", "u2", "mh60"
}
local MacroActorTypes = { "mcv" }

local BuilderSpawns = { Actor930, Actor931, Actor932, Actor933 }
local FighterSpawns = { Actor1215, Actor1219, Actor1220, Actor1221 }

-- team 1
local Builder0 = Player.GetPlayer("Multi0")
local Fighter0 = Player.GetPlayer("Multi1")
local Builder1 = Player.GetPlayer("Multi2")
local Fighter1 = Player.GetPlayer("Multi3")

-- team 2
local Builder2 = Player.GetPlayer("Multi4")
local Fighter2 = Player.GetPlayer("Multi5")
local Builder3 = Player.GetPlayer("Multi6")
local Fighter3 = Player.GetPlayer("Multi7")

local AllPlayers = { Builder0, Fighter0, Builder1, Fighter1, Builder2, Fighter2, Builder3, Fighter3 }
local PlayerSpawns = { Actor930, Actor1215, Actor931, Actor1219, Actor932, Actor1220, Actor933, Actor1221 }

local Builders = { Builder0, Builder1, Builder2, Builder3 }
local Fighters = { Fighter0, Fighter1, Fighter2, Fighter3 }

function PlaySpeechNotification(notification)
    for i = 1, #AllPlayers do
        Media.PlaySpeechNotification(AllPlayers[i], notification)
    end
end

function PlaySoundNotification(notification)
    for i = 1, #AllPlayers do
        Media.PlaySoundNotification(AllPlayers[i], notification)
    end
end

WorldLoaded = function()
    for i = 1, #AllPlayers do
        if AllPlayers[i].IsLocalPlayer then
            Camera.Position = PlayerSpawns[i].CenterPosition
        end
    end

    

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        PlaySpeechNotification("TimerStarted")
    end)


    Trigger.AfterDelay(DateTime.Seconds(2), function()
        Media.DisplayMessage("Starting game in 5")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage("Starting game in 4")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(4), function()
        Media.DisplayMessage("Starting game in 3")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.DisplayMessage("Starting game in 2")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.DisplayMessage("Starting game in 1")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(7), function()
        GameStarted = true
        Media.DisplayMessage("Game starting!")
        SpawnStartingUnits()
        PlaySpeechNotification("AlliedReinforcementsSouth")
        -- Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
        -- Media.PlaySound("chrono2.aud")
        -- Media.PlaySound("thunder-ambient.aud")
    end)

    Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.DisplayMessage("GL & HF")
    end)
end

function TransferUnits()
    for i = 1, #Builders do
        local microActors = Builders[i].GetActorsByTypes(MicroActorTypes)
        for j = 1, #microActors do
            microActors[j].Owner = Fighters[i]
        end
    end

    for i = 1, #Fighters do
        local macroActors = Fighters[i].GetActorsByTypes(MacroActorTypes)
        for j = 1, #macroActors do
            macroActors[j].Owner = Builders[i]
        end
    end
    -- for _, team in pairs(PlayerTeams) do
    --     team[0]:GetActorsByTypes()
    -- end
end

function SpawnStartingUnits()
    for i = 1, #Builders do
        newmcv = Actor.Create("mcv", true, { Location = BuilderSpawns[i].Location, Owner = Builders[i], Facing = South })
    end

    if Map.LobbyOption("fighterResources") == "low" then
        for i = 1, #Fighters do
            Fighters[i].Cash = 500
        end
    end

    if Map.LobbyOption("fighterResources") == "medium" then
        for i = 1, #Fighters do
            Fighters[i].Cash = 5000
        end
    end

    if Map.LobbyOption("fighterResources") == "high" then
        for i = 1, #Fighters do
            Fighters[i].Cash = 50000
        end
    end

    if Map.LobbyOption("fighterStartingUnits") == "jeep" then
        for i = 1, #Fighters do
            newjeep = Actor.Create("jeep", true,
                { Location = FighterSpawns[i].Location, Owner = Fighters[i], Facing = South })
        end
    end
end

Tick = function()
    if GameStarted then
        TransferUnits()
    end
end
