local GameStarted = false

local MicroActorTypes = {
    "dog", "e1", "e1r1", "e2", "e3r1", "e3", "e4", "spy", "spy.england", "e7", "medi", "thf", "mech",
    "shok", "sniper", "zombie", "ant", "scoutant", "warriorant", "fireant", "v2rl", "1tnk", "2tnk", "3tnk", "4tnk",
    "arty", "jeep", "apc", "mnly", "truk", "mgg", "mrj", "ttnk", "ftrk", "dtrk", "ctnk", "qtnk", "stnk"
}
local MacroActorTypes = { "mcv" }

local PlayerSpawns = { Actor0, Actor1, Actor2, Actor3 }
local BuilderSpawns = { Actor0, Actor2 }
local FighterSpawns = { Actor1, Actor3 }

-- players
local Builder0 = Player.GetPlayer("Builder0")
local Fighter0 = Player.GetPlayer("Fighter0")
local Builder1 = Player.GetPlayer("Builder1")
local Fighter1 = Player.GetPlayer("Fighter1")

local AllPlayers = { Builder0, Fighter0, Builder1, Fighter1 }
local PlayerSpawns = { Actor0, Actor1, Actor2, Actor3 }
local PlayerTeams = {
    {
        Builder0,
        Fighter0,
    },
    {
        Builder1,
        Fighter1,
    }
}
local Builders = { Builder0, Builder1 }
local Fighters = { Fighter0, Fighter1 }

function PlaySpeechNotification(notification)
    for i = 1, #AllPlayers do
        Media.PlaySpeechNotification(AllPlayers[i], notification)
    end
end

function PlaySoundNotification(notification)
    for i = 1, #AllPlayers do
        Media.PlaySoundNotification(AllPlayers[i], notification)
    end
end

WorldLoaded = function()
    for i = 1, #AllPlayers do
        if AllPlayers[i].IsLocalPlayer then
            Camera.Position = PlayerSpawns[i].CenterPosition
        end
    end

    PlaySpeechNotification("TimerStarted")


    Trigger.AfterDelay(DateTime.Seconds(2), function()
        Media.DisplayMessage("Starting game in 5")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage("Starting game in 4")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(4), function()
        Media.DisplayMessage("Starting game in 3")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.DisplayMessage("Starting game in 2")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.DisplayMessage("Starting game in 1")
        PlaySoundNotification("AlertBleep")
    end)

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        GameStarted = true
        Media.DisplayMessage("Game starting!")
        SpawnStartingUnits()
        PlaySpeechNotification("AlliedReinforcementsSouth")
        -- Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
        -- Media.PlaySound("chrono2.aud")
        -- Media.PlaySound("thunder-ambient.aud")
    end)

    Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.DisplayMessage("GL & HF")
    end)
end

function TransferUnits()
    for i = 1, #Builders do
        local microActors = Builders[i].GetActorsByTypes(MicroActorTypes)
        for j = 1, #microActors do
            microActors[j].Owner = Fighters[i]
        end
    end

    for i = 1, #Fighters do
        local macroActors = Fighters[i].GetActorsByTypes(MacroActorTypes)
        for j = 1, #macroActors do
            macroActors[j].Owner = Builders[i]
        end
    end
    -- for _, team in pairs(PlayerTeams) do
    --     team[0]:GetActorsByTypes()
    -- end
end

function SpawnStartingUnits()
    for i = 1, #Builders do
        Media.DisplayMessage(Builders[i].Name .. " is the builder")
        newmcv = Actor.Create("mcv", true, { Location = BuilderSpawns[i].Location, Owner = Builders[i], Facing = South })
        newmcv.Move(BuilderSpawns[i].Location)
    end

    for i = 1, #Fighters do
        Media.DisplayMessage(Fighters[i].Name .. " is the fighter")
        newjeep = Actor.Create("jeep", true,
            { Location = FighterSpawns[i].Location, Owner = Fighters[i], Facing = South })
        newjeep.Move(FighterSpawns[i].Location)
    end
end

Tick = function()
    if GameStarted then
        TransferUnits()
    end
end
