-- TODO: Do something for DQ players
-- TODO: Music

-- These names need updating once the playoffs have happened.
Winners = {'Kav', 'Blackened', 'Fazzar'}
-- creo didn't quite survive... see later.
Survivors = {'creo', 'maceman', 'Ekanim', 'anjew', 'Mo', 'Sigil', 'DukeBones', 'Upps', 'tux', 'MargotHonecker', 'milkman', 'Nilhall', 'BigHALK', 'Rossie', 'spetsnaz84', 'chouchani'}
Strikes = {Blackened = 1, creo = 1, BigHALK = 1}
DqPlayers = {'MrCloudy', 'JustSomeGuy', 'Eugenator', 'toiletbreakbrb'}
PrizeCount = 1
PlayerUnitType = 'e2'
InternalToSurvivorMap = {}
Finishers = {}
Eliminated = {}
MapWidth = 50
MapHeight = 50
Ended = false
WaypointCPos = {}
Barracks = {}
TimeInterval = 5
GameStage = 0
MiddleLocation = nil

PickRandomPlayerUnit = function(callback)
    local allPlayerUnits = {}
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local playerUnits = player.GetActorsByType(PlayerUnitType)
        for j = 1, #playerUnits do
            local playerUnit = playerUnits[j]
            if playerUnit ~= nil and not playerUnit.IsDead then
                allPlayerUnits[#allPlayerUnits + 1] = playerUnit
            end
        end
    end
    return Utils.Random(allPlayerUnits)
end

ForEachLivingPlayerUnit = function(callback)
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local playerUnits = player.GetActorsByType(PlayerUnitType)
        for j = 1, #playerUnits do
            local playerUnit = playerUnits[j]
            if playerUnit ~= nil and not playerUnit.IsDead then
                callback(playerUnit)
            end
        end
    end
end

ForEachWinner = function(callback)
    for i = 1, #Winners do
        local winner = Winners[i]
        local winnerUnitName = "WINNER"..i
        local winnerUnit = Map.NamedActor(winnerUnitName)
        if winnerUnit ~= nil and not winnerUnit.IsDead then
            callback(winnerUnit)
        end
    end
end

Dist2 = function(positionA, positionB)
    local deltaX = positionA.X - positionB.X
    local deltaY = positionA.Y - positionB.Y
    return deltaX * deltaX + deltaY * deltaY
end

DisplayOtherNames = function()
    local creeps = Player.GetPlayer("Creeps")
    for i = 1, #Winners do
        local winner = Winners[i]
        local winnerUnitName = "WINNER"..i
        local winnerUnit = Map.NamedActor(winnerUnitName)
        if winnerUnit ~= nil and not winnerUnit.IsDead then
            Media.FloatingText(winner, winnerUnit.CenterPosition, 30, creeps.Color)
        end
    end

    local creeps2 = Player.GetPlayer("Creeps2")
    if not TTTPPP.IsDead then
        Media.FloatingText("TTTPPP", TTTPPP.CenterPosition, 30, creeps2.Color)
    end

    for i = 1, #DqPlayers do
        local dqPlayer = DqPlayers[i]
        local dqUnit = Map.NamedActor("SF"..i)
        if dqUnit ~= nil and not dqUnit.IsDead then
            Media.FloatingText(dqPlayer, dqUnit.CenterPosition, 30, creeps2.Color)
        end
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        DisplayOtherNames()
    end)
end

DisplayNames = function()
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local playerUnits = player.GetActorsByType(PlayerUnitType)
        for j = 1, #playerUnits do
            local playerUnit = playerUnits[j]
            local survivor = Survivors[i]
            InternalToSurvivorMap[playerName] = survivor
            playerUnit.GrantCondition(survivor)

            Trigger.OnKilled(playerUnit, function(playerUnit)
                if not Ended then
                    local remaining = player.GetActorsByType(PlayerUnitType)
                    if #remaining == 0 then
                        Media.DisplayMessage(survivor.." is dead")
                        Eliminated[#Eliminated + 1] = survivor
                        player.MarkFailedObjective(0)
                    end
                end
            end)
        end
    end
    DisplayOtherNames()
end

CheckForEnded = function()
    local remaining = {}
    for i = 1, #Survivors do
        local internalName = "Multi"..(i-1)
        local player = Player.GetPlayer(internalName)
        local playerUnits = player.GetActorsByType(PlayerUnitType)
        if #playerUnits > 0 then
            remaining[#remaining + 1] = player
        end
    end
    if #remaining < 2 then
        Ended = true
        for i = 1, #remaining do
            local player = remaining[i]
            player.MarkCompletedObjective(0)
            local survivor = InternalToSurvivorMap[player.InternalName]
            Finishers[#Finishers + 1] = survivor
        end
        while #Finishers < PrizeCount do
            Finishers[#Finishers + 1] = Eliminated[#Eliminated - #Finishers + #remaining]
        end
        Media.DisplayMessage("***")
        if PrizeCount == 1 then
            Media.DisplayMessage("*** The prize winner is: "..Finishers[1])
        else
            local winners = Finishers[1]
            for i = 2, PrizeCount do
                winners = winners..", "..Finishers[i]
            end
            Media.DisplayMessage("*** The prize winners are: "..Finishers[1]..", "..Finishers[2]..", "..Finishers[3])
        end
        Media.DisplayMessage("***")
    else
        Trigger.AfterDelay(DateTime.Seconds(1), function()
            CheckForEnded()
        end)
    end
end

DisplayTimerMessages = function()
    for i = 3, TimeInterval do
        Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval - i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval - 2), function()
        Media.DisplayMessage("Pausing!")
    end)
    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        Media.DisplayMessage("Last minute adjustment to season finishers...")
    end)
    Trigger.AfterDelay(DateTime.Seconds(5 * TimeInterval - 1), function()
        Media.DisplayMessage("Resuming!")
    end)
    for i = 1, TimeInterval do
        Trigger.AfterDelay(DateTime.Seconds(6 * TimeInterval - i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(6 * TimeInterval), function()
        Media.DisplayMessage("GO!")
        TechnicianPanic()
    end)
end

CreepAttack = function(creep)
    local playerUnit = PickRandomPlayerUnit()
    creep.Attack(playerUnit)
end

WinnerLoop = function()
    -- Winner 1 attacks furthest from middle.
    local winner1 = Map.NamedActor("WINNER1")
    if winner1 ~= nil and not winner1.IsDead then
        local maxDist2 = 0
        local target = nil
        for i = 1, #Survivors do
            local playerName = "Multi"..(i-1)
            local player = Player.GetPlayer(playerName)
            local playerUnits = player.GetActorsByType(PlayerUnitType)
            for j = 1, #playerUnits do
                local playerUnit = playerUnits[j]
                if playerUnit ~= nil and not playerUnit.IsDead then
                    local dist2 = Dist2(playerUnit.Location, MiddleLocation)
                    if dist2 > maxDist2 then
                        maxDist2 = dist2
                        target = playerUnit
                    end
                end
            end
        end
        winner1.Stop()
        winner1.Attack(target)
    end
    -- Winner 2 attacks automatically.
    -- Winner 3 attacks at random.
    local winner3 = Map.NamedActor("WINNER3")
    if winner3 ~= nil and not winner3.IsDead then
        CreepAttack(winner3)
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        WinnerLoop()
    end)
end

InitGameStages = function()
    MiddleLocation = TTTPPP.Location

    -- Handle strikes
    for i = 1, #Survivors do
        local survivor = Survivors[i]
        if Strikes[survivor] ~= nil then
            local playerName = "Multi"..(i-1)
            local player = Player.GetPlayer(playerName)
            local playerUnits = player.GetActorsByType(PlayerUnitType)
            for j = 1, Strikes[survivor] do
                local playerUnit = playerUnits[j]
                if playerUnit ~= nil and not playerUnit.IsDead then
                    playerUnit.Destroy()
                end
            end
        end
    end

    ForEachLivingPlayerUnit(function(playerUnit)
        playerUnit.Wait(DateTime.Seconds(6 * TimeInterval))
    end)
    ForEachWinner(function(winnerUnit)
        winnerUnit.Stance = "holdfire"
        winnerUnit.Wait(DateTime.Seconds(6 * TimeInterval))
    end)

    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        -- Find creo
        for i = 1, #Survivors do
            local survivor = Survivors[i]
            if survivor == "creo" then
                local playerName = "Multi"..(i-1)
                local player = Player.GetPlayer(playerName)
                local creoUnits = player.GetActorsByType(PlayerUnitType)
                for i = 1, #DqPlayers do
                    local dqUnit = Map.NamedActor("SF"..i)
                    if dqUnit ~= nil and not dqUnit.IsDead then
                        -- Attack random Creo unit.
                        local creoUnit = Utils.Random(creoUnits)
                        dqUnit.Move(creoUnit.Location)
                        Trigger.OnEnteredProximityTrigger(creoUnit.CenterPosition, WDist.New(512), function(actor, id)
                            if actor ~= nil and not actor.IsDead and actor.Type == "xmas_red_elf" then
                                actor.Kill()
                            end
                        end)
                    end
                end
            end
        end
    end)

    Trigger.AfterDelay(DateTime.Seconds(6 * TimeInterval), function()
        -- Start by scattering.
        ForEachLivingPlayerUnit(function(playerUnit)
            playerUnit.Scatter()
            playerUnit.Scatter()
        end)

        ForEachLivingPlayerUnit(function(playerUnit)
            Trigger.OnIdle(playerUnit, function(playerUnit)
                if Utils.RandomInteger(1, 2 + 1) == 1 then
                    -- Throw a snowball.
                    playerUnit.Scatter()
                else
                    -- Randomly move some distance.
                    local x = playerUnit.Location.X + (2 * Utils.RandomInteger(1, 2 + 1) - 3) * Utils.RandomInteger(1, 5 + 1)
                    if x < 3 then
                        x = 3
                    elseif x > MapWidth - 2 then
                        x = MapWidth - 2
                    end
                    local y = playerUnit.Location.Y + (2 * Utils.RandomInteger(1, 2 + 1) - 3) * Utils.RandomInteger(1, 5 + 1)
                    if y < 3 then
                        y = 3
                    elseif y > MapHeight - 2 then
                        y = MapHeight - 2
                    end
                    local newLocation = CPos.New(x, y)
                    playerUnit.Move(newLocation)
                end
            end)
        end)

        ForEachWinner(function(winnerUnit)
            winnerUnit.Stance = "attackanything"
        end)
        WinnerLoop()
    end)
end

TechnicianPanic = function()
    if not TTTPPP.IsDead then
        TTTPPP.Stop()
        TTTPPP.Panic()
        Trigger.AfterDelay(DateTime.Seconds(TimeInterval), TechnicianPanic)
    end
end

WorldLoaded = function()
    Survivors = Utils.Shuffle(Survivors)

    DisplayNames()

    DisplayTimerMessages()

    InitGameStages()

    CheckForEnded()
end
