
-- 25 ticks per second
Intervals = {
	current = 1,
	completes = 0,
	data = {
		{
			name = "RoundStart",
			delay = 2 * 25,
			text = "Army Arrives"
		},{
			name = "Spawning",
			delay = 5 * 25,
			text = "Army Ready"
		},{
			name = "ArmyDelay",
			delay = 0,
			text = "Prepare Army"
		},{
			name = "OuterEngage",
			delay = 5 * 25,
			text = "Outer Defences"
		},{
			name = "ReleaseCreeps",
			delay = 20 * 25,
			text = "Angry Dogs"
        }
	},
}
function Intervals.Reset()
	Intervals.current = 1
	Intervals.completes = DateTime.GameTime + Intervals.data[1].delay
end

function Intervals.Next()
	Intervals.current = Intervals.current + 1
	if Intervals.data[Intervals.current] == nil then
		Intervals.current = nil
	else
		Intervals.completes = DateTime.GameTime + Intervals.data[Intervals.current].delay
	end
end

function Intervals.IsComplete()
	return DateTime.GameTime >= Intervals.completes
end

function Intervals.TicksRemaining()
	return Intervals.completes - DateTime.GameTime
end

function Intervals.HasInterval()
	return Intervals.current ~= nil
end

function Intervals.Name()
	return Intervals.data[Intervals.current].name
end

function Intervals.Text()
	return Intervals.data[Intervals.current].text
end

function Intervals.SetDelay(name, delay)
	for i,v in pairs(Intervals.data) do
		if v.name == name then
			Intervals.data[i].delay = delay
			break
		end
	end
end