Players = {}
Creeps = {}
Defences = {}
Rounds = 3
FlagHoldTime = 30 * 24
FlagHoldRadius = 2048
CreepReleaseInterval = 10
CreepGrowthPerInterval = 50

DefenceCycle = {'pbox'} -- ,'ftur','gun','pbox','tsla'

local neutral
local flag

Round = {
	Number = 1,
	Status = 0, -- 0 = not started, 1 = spawning units, 2 = in progress, 3 = finished
	Times = {},
	TimesStatus = {},
	CreepsReleased = false,
	CreepIntervalRemaining = 0,
	CreepLastValue = 0,
	FlagHolder = nil,
	FlagTime = 0
}

MissionText = {
	Title = "First to " .. Rounds .. " rounds",
	Scores = "",
    FlagHolder = ""
}

GameReady = false

Starts = {
	{
		path = {CPos.New(1,1), CPos.New(5,5)},
		name = 'Top Left'
	},{
		path = {CPos.New(48,48), CPos.New(44,44)},
		name = 'Bottom Right'
	},{
		path = {CPos.New(48,1), CPos.New(44,5)},
		name = 'Top Right'
	},{
		path = {CPos.New(1,48), CPos.New(5,44)},
		name = 'Bottom Left'
	}
}

Positions = {
	DeathCam = CPos.New(24,24),
	Crates = {
						CPos.New(20,10),	CPos.New(28,10),
	CPos.New(10,20),	CPos.New(20,20),	CPos.New(28,20),	CPos.New(38,20),
	CPos.New(10,28),	CPos.New(20,28),	CPos.New(28,28),	CPos.New(38,28),
						CPos.New(20,38),	CPos.New(28,38)
	}
}

OuterDefences = {
	{8,1,9,1}, {24,1,25,1}, {40,1,41,1}, -- T
	{48,10,48,12}, {48,23,48,24}, {48,38,48,42}, -- R
	{40,48,41,48}, {24,48,25,48}, {6,48,10,48}, -- B
	{1,7,1,8}, {1,21,1,24}, {1,39,1,42} --L
}

CreepTypes = {
    {
        value = 1,
        actor = 'dog'
    },
    {
        value = 1,
        actor = 'e2'
    },
    {
        value = 10,
        actor = 'e3'
    },
    {
        value = 10,
        actor = 'zombie'
    },
    {
        value = 50,
        actor = 'ant'
    },
    {
        value = 250,
        actor = '4tnk'
    },
    {
        value = 500,
        actor = 'dtrk'
    }
}
AllCreepTypes = {}

function OnPlayerLost(player_object)
	player_id = PlayerIdFromPlayer(player_object)
	for j, w in pairs(player_object.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Kill()
		end
	end
	Players[player_id].State = 'lost'
	RefreshScores()
end

function InitPlayers()
	local names = {'Multi0', 'Multi1', 'Multi2', 'Multi3'}
	for i,v in pairs(names) do
		local player = Player.GetPlayer(v)
		if player ~= nill then
			Players[#Players+1] = {
				Ref = v,
				Name = player.Name,
				Object = player,
				State = 'alive',
				Squad = nil,
				Start = nil,
				Wins = 0,
				Bonus = 0,
				DeathCam = nil,
				Objective = player.AddPrimaryObjective("Be the last one standing for " .. Rounds .. " rounds.")
			}
			Trigger.OnPlayerLost(player, OnPlayerLost)
		end
	end
	Creeps.Object = Player.GetPlayer('Creeps')
    Defences.Object = Player.GetPlayer('Defences')
    for i,creep_type in pairs(CreepTypes) do
        table.insert(AllCreepTypes, creep_type.actor)
    end
end

function GetFlagHolder()
	local owner = nil
	for j,actor in pairs(Map.ActorsInCircle(flag.CenterPosition, WDist.New(FlagHoldRadius))) do
		if not actor.Owner.IsNonCombatant and actor ~= flag and actor.HasProperty('Health') and not actor.IsDead and actor.HasProperty('IsMobile') then
			if owner == nil then
				owner = actor.Owner
			elseif actor.Owner ~= owner then
				owner = nil
				break
			end
		end
	end
	return owner
end

function SpawnDefences(line_list, cycle)
	local start_pos_x
	local start_pos_y
	local end_pos_x
	local end_pos_y
	local mod_x
	local mod_y
	local x
	local y
	local creeps = Defences.Object
	local cycle_i = 1
	local cycle_length = #cycle
	local cycle_current
	for i,v in pairs(line_list) do
		start_pos_x = v[1]
		start_pos_y = v[2]
		end_pos_x = v[3]
		end_pos_y = v[4]
		
		if start_pos_x <= end_pos_x then
			mod_x = 1
		else
			mod_x = -1
		end
		
		if start_pos_y <= end_pos_y then
			mod_y = 1
		else
			mod_y = -1
		end

		x = start_pos_x
		y = start_pos_y
		while true do
			cycle_current = cycle[cycle_i]
			cycle_i = cycle_i + 1
			if cycle_i > cycle_length then
				cycle_i = 1
			end
			
			Actor.Create(cycle_current, true, {
				Owner = creeps,
				Location = CPos.New(x,y)
			})
			-- maybe should work out a ratio and use that to get a nice even slope but for now just add 1 each time
			if x == end_pos_x and y == end_pos_y then
				break
			end
			if x ~= end_pos_x then
				x = x + mod_x
			end
			if y ~= end_pos_y then
				y = y + mod_y
			end
		end
	end
end

-- A bit fiddly so in its own function until I find a cleaner way
function RandomiseStarts()
	local starts = Utils.Shuffle({1,2,3,4})
	for i,v in pairs(Players) do
		Players[i].Start = starts[i]
	end
end

function PlayerIdFromPlayer(player)
	local ref = player.InternalName
	for i,v in pairs(Players) do
		if v.Ref == ref then
			return i
		end
	end
end

function RefreshScores()
	local buffer = ""
	local first = true
	
	for i,v in pairs(Players) do
		if(first) then
			first = false
		else
			buffer = buffer .. " | "
		end
		buffer = buffer .. v.Name .. ': ' .. v.Wins
		if v.State == 'lost' then
			buffer = buffer .. ' (Lost)'
		end
	end
	
	MissionText.Scores = buffer
	ShowMissionText()
end

function RefreshIntervalMissionText()
    RefreshFlagHolder()
	ShowMissionText()
end

function RefreshFlagHolder()
	local buffer
	if Round.FlagHolder ~= neutral then
        buffer = "Flag: " .. Round.FlagHolder.Name .. " " .. math.ceil(Round.FlagTime / 25) .. "s"
    else
        buffer = "Flag: Unclaimed"
	end
	MissionText.FlagHolder = buffer
end

function ShowMissionText()
	UserInterface.SetMissionText(MissionText.Title .. "\n\n" .. MissionText.Scores .. "\n\n" .. MissionText.FlagHolder)
end

function PrepareRound()

	local creeps = Creeps.Object
	
	Army.RandomiseValues()
	
	Round.CreepsReleased = false
	Round.CreepIntervalRemaining = 0
	Round.CreepLastValue = 0
    
	Intervals.SetDelay("ArmyDelay", Army.GetSizeDelay())
	
	Round.FlagHolder = neutral
	Round.FlagTime = 0
	
	local mirror_text
	if Army.IsMirror() then
		mirror_text = "Mirrored Armies"
	else
		mirror_text = "Different Armies"
	end
    Media.DisplayMessage(mirror_text, 'Round')
	-- Media.DisplayMessage(Round.Number .. ' | Army Value: ' .. Army.GetSizeName() .. ' | ' .. mirror_text, 'Round')
	-- Media.DisplayMessage(Army.GetTechDescription(), 'Tech')
	
	if Round.Number > 1 then
		local buffer = ""
		local first = true
		for i,v in pairs(Players) do
			if Players[i].State ~= "lost" then
				if first then
					first = false
				else
					buffer = buffer .. ' | '
				end
				local bonus = math.floor((Players[i].Object.Cash / 100) * (Army.GetSizeValue() / 100))
				Players[i].Object.Cash = 0
				buffer = buffer .. Players[i].Name .. ': ' .. bonus
				Players[i].State = "alive"
				Players[i].Bonus = bonus
				EnableDeathCam(i)
			end
		end	
		Media.DisplayMessage(buffer, 'Bonus Army')
	end
	
	RandomiseStarts()
	Intervals.Reset()
	
	for i,v in pairs(Positions.Crates) do
		Actor.Create('squishcrate', true, {
			Owner = creeps,
			Location = v
		})
	end
end

function StartRound()
	DisableDeathCams()
	local army
	if Army.IsMirror() then
		army = Army.GenerateArmy()
	end
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			local player_units = {}
			if not Army.IsMirror() then
				player_units = Army.UnitsAddArmy(player_units, Army.GenerateArmy())
			else
				player_units = Army.UnitsAddArmy(player_units, army)
			end
			if Players[i].Bonus > 0 then
				player_units = Army.UnitsAddArmy(player_units, Army.GenerateBonusArmy(Players[i].Bonus))
			end
			Reinforcements.Reinforce(v.Object, player_units, Starts[v.Start].path, 1)
		end
	end
end

function ResetArena() 
	local creeps = Creeps.Object
	for i,v in pairs(creeps.GetActorsByTypes(AllCreepTypes)) do
		if v.IsInWorld and not v.IsDead then
			v.Kill()
		end
	end
    local defences = Defences.Object
	for j, w in pairs(defences.GetActors()) do
		if w.HasProperty('Health') and w.IsInWorld then
			w.Destroy()
		end
	end  
	for i,v in pairs(Players) do
		for j, w in pairs(v.Object.GetActors()) do
			if w.HasProperty('Health') and w.IsInWorld then
				w.Kill()
			end
		end
	end
	for j,w in pairs(Starts) do
		w.taken = false
	end
	flag.Owner = neutral
end

function WorldLoaded()
	neutral = Player.GetPlayer('Neutral')
	flag = neutral.GetActorsByType('ctflag')[1]
	Media.DisplayMessage('Squish v2.0', 'Briefing')  
	Media.DisplayMessage('Last player standing for ' .. Rounds .. ' rounds wins the game.', 'Briefing')
	Media.DisplayMessage('Hold the flag in the middle for 30 seconds to win the round!', 'Briefing')
	Media.DisplayMessage('Get cash from bounties to get a small army bonus next round.', 'Briefing')
	
	InitPlayers()
	PrepareRound()
	RefreshScores()
	RefreshIntervalMissionText()
	GameReady = true
end

function GameWon()
	for i,v in pairs(Players) do
		if v.State == 'winner' then
			v.Object.MarkCompletedObjective(v.Objective)
		else
			v.Object.MarkFailedObjective(v.Objective)
		end
	end
    GameReady = false
end

function EnableDeathCam(player_i)
	if Players[player_i].DeathCam == nil then	
		Players[player_i].DeathCam = Actor.Create("deathcam" , true, {
			Owner = Players[player_i].Object,
			Location = Positions.DeathCam
		})
	end
end

function DisableDeathCams()
	for i,v in pairs(Players) do
		if v.DeathCam ~= nil then
			v.DeathCam.Destroy()
			Players[i].DeathCam = nil
		end
	end
end

function MoveRandomly(actor)
    if actor.IsIdle then
        actor.AttackMove(CPos.New(Utils.RandomInteger(1,48),Utils.RandomInteger(1,48)), 5)
    end
end

function GetAffordableCreeps(value, options)
    affordable = {}
    for i, creep_type in pairs(CreepTypes) do
        if creep_type.value <= value then
            table.insert(affordable, creep_type)
        end
    end
    return affordable
end

function SpawnCreeps(value)
    affordable = GetAffordableCreeps(value, CreepTypes)
    while #affordable > 0 do
        local creep_type = affordable[Utils.RandomInteger(1, #affordable + 1)]
        value = value - creep_type.value
        Reinforcements.Reinforce(Creeps.Object, {creep_type.actor}, Starts[Utils.RandomInteger(1, #Starts + 1)].path, 3)
        affordable = GetAffordableCreeps(value, affordable)
    end
end

function EachSecond()
	for i,v in pairs(Players) do
		if v.State == 'alive' then
			for j,w in pairs(v.Object.GetActorsByType('mnly')) do
				if w.IsInWorld and not w.IsDead then
					if w.AmmoCount() < w.MaximumAmmoCount() then 
						w.Reload()
					end
				end
			end
		end
	end

	if Round.CreepsReleased then
		for i,v in pairs(Creeps.Object.GetActorsByTypes(AllCreepTypes)) do
			if v.IsInWorld and not v.IsDead then
                MoveRandomly(v)
			end
		end
        if Round.CreepIntervalRemaining <= 0 then
            Round.CreepLastValue = Round.CreepLastValue + CreepGrowthPerInterval
            SpawnCreeps(Round.CreepLastValue)
            Round.CreepIntervalRemaining = CreepReleaseInterval
        end
        Round.CreepIntervalRemaining = Round.CreepIntervalRemaining - 1
	end
	
	RefreshIntervalMissionText()
end


Tick = function()
	if GameReady == false then
		return
	end
	local interval_complete = Intervals.HasInterval() and Intervals.IsComplete()
	if interval_complete then
		interval_name = Intervals.Name()
		Intervals.Next()
	end
	if Round.Status == 2 then
		local flagHolder = GetFlagHolder()
		local name
		if flagHolder ~= nil then
			flag.Owner = flagHolder
            if Round.FlagHolder ~= flagHolder then
                Round.FlagHolder = flagHolder
                Round.FlagTime = FlagHoldTime
                Media.DisplayMessage(flagHolder.Name .. ' has the flag.', 'Briefing')
            else
                Round.FlagTime = Round.FlagTime - 1
            end
			name = flagHolder.Name
		else
            if Round.FlagHolder ~= neutral then
                Round.FlagHolder = neutral
                Media.DisplayMessage('Flag lost.', 'Briefing')
            end
			name = 'Neutral'
			flag.Owner = neutral
		end
		local alive = 0
		for i,player in pairs(Players) do
			if player.State == 'alive' then
				local player_alive = false
				for j,actor in pairs(player.Object.GetActors()) do
					if actor.IsInWorld and actor.HasProperty('Health') and not actor.IsDead and actor.HasProperty('IsMobile') then
						player_alive = true
						break
					end
				end
				if player_alive then
					alive = alive + 1
				else
					Media.DisplayMessage(player.Name .. ' has been squished.', 'Briefing')
					Players[i].State = 'dead'
					EnableDeathCam(i)
				end
			end
		end
        local round_winner = nil
        
        if (Round.FlagHolder ~= neutral) and (Round.FlagTime <= 0) then
            for i,player in pairs(Players) do
                if player.Object == Round.FlagHolder then
                    round_winner = i
                end
			end
		elseif alive <= 1 then
			Round.Status = 3
			local won = false
			for i,player in pairs(Players) do
				if player.State == 'alive' then
                    round_winner = i
				end
			end
		end
        
        if round_winner ~= nil then
            local player = Players[round_winner]
            Players[round_winner].Wins = player.Wins + 1
            if player.Wins >= Rounds then
                Players[round_winner].State = 'winner'
                won = true
                Media.DisplayMessage(player.Name .. ' is the match winner!', 'Briefing')
            else
                Media.DisplayMessage(player.Name .. ' is has won the round!', 'Briefing')
            end
            
			RefreshScores()
			if won == true then
				GameWon()
			else
				ResetArena()
				Round.Status = 0
				Round.Number = Round.Number + 1
				PrepareRound()
			end
        end
		
		if interval_complete then
			if interval_name == "OuterEngage" then
				Media.DisplayMessage('Pillboxes Engaged!', 'Briefing')
				SpawnDefences(OuterDefences, DefenceCycle)
			end
			
			if interval_name == "ReleaseCreeps" then
				Media.DisplayMessage('Creeps detected!', 'Briefing')
				Round.CreepsReleased = true
			end
		end

	end
	if interval_complete then
		if Round.Status == 0 and interval_name == "RoundStart" then
			StartRound()
			Round.Status = 1
		end
		if Round.Status == 1 and interval_name == "Spawning" then
			Round.Status = 2
		end
	end
	
	if DateTime.GameTime % 25 == 0 then
		EachSecond()
	end
end