
Army = {
	Values = {
		Techs = {},
		Kill = {},
		RemainMin = {},
		Size = nil,
		Mirror = nil
	},	
	Techs = {
		{
			name = 'rax',
			chance = 7,
			text = 'Barracks'
		},{
			name = 'wf',
			chance = 9,
			text = 'War Factory'
		},{
			name = 'sd',
			chance = 5,
			text = 'Service Depot'
		},{
			name = 'rd',
			chance = 5,
			text = 'Radar Dome'
		},{
			name = 'tc',
			chance = 5,
			text = 'Tech Center'
		}
	},	
	ProductionTechs = {'rax', 'wf'},
	Types = {
		{
			name = 'infantry',
			tech = 'rax'
		},{
			name = 'heavy',
			tech = 'wf'
		},{
			name = 'light',
			tech = 'wf'
		},{
			name = 'ranged',
			tech = 'rd'
		}
	},
	Sizes = {
		{
			name = "Very Low",
			value = 40,
			delay = 5
		},{
			name = "Low",
			value = 65,
			delay = 10 * 25
		},{
			name = "Medium",
			value = 80,
			delay = 15 * 25
		},{	
			name = "High",
			value = 100,
			delay = 25 * 25
		},{
			name = "Huge",
			value = 120,
			delay = 35 * 25
		},{
			name = "Epic",
			value = 150,
			delay = 45 * 25
		}
	}
}

function Army.RandomiseValues()
	local techs = {}
	local has_production = false
	for i,v in pairs(Army.Techs) do
		if Utils.RandomInteger(1, 11) <= v.chance then
			techs[#techs + 1] = v.name
			if not has_production then
				for j,w in pairs(Army.ProductionTechs) do
					if v.name == w then
						has_production = true
						break
					end
				end
			end
		end
	end
	if not has_production then
		techs[#techs + 1] = Army.ProductionTechs[Utils.RandomInteger(1, #Army.ProductionTechs+1)]
	end
	
	Army.Values.Techs = techs
	
	local kill_keys = {}
	for i,v in pairs(Army.Types) do
		for j,w in pairs(techs) do
			if w == v.tech then
				kill_keys[v.name] = true
			end
		end
	end
	
	local kill = {}
	for i,v in pairs(kill_keys) do
		kill[#kill + 1] = i
	end
	
	kill = Utils.Shuffle(kill)
		
	Army.Values.Kill = kill

	local min_values = {}

	for i,v in pairs(kill) do
		min_values[v] = 0
	end
	for i,v in pairs(Squads) do
		for j,w in pairs(v.kills) do
			if v.support == false and in_table(w, kill) and (v.value < min_values[w] or min_values[w] == 0) then
				min_values[w] = v.value
			end
		end
	end
	local i = #kill
	local total = 0
	while i > 0 do
		local army_type = kill[i]
		Army.Values.RemainMin[army_type] = total
		total = total + min_values[army_type]
		i = i - 1
	end	
	
	Army.Values.Size = Utils.RandomInteger(1, #Army.Sizes + 1)
	Army.Values.Mirror = Utils.RandomInteger(1, 3) == 1
end

function Army.ArmyDescription(army)
	local buffer = ""
	local first = true
	for i,v in pairs(army) do
		if first then
			first = false
		else
			if i == #army then
				buffer = buffer .. " and "
			else
				buffer = buffer .. ", "
			end
		end
		buffer = buffer .. Squads[v].name
	end
	return buffer
end

function Army.RandomSquad(max_value, must_kill, max_support)
	local available = {}
	for i,v in pairs(Squads) do
		if v.value <= max_value and (v.support == false or v.value <= max_support) then
			local matches = must_kill == nil
			if not matches then
				matches = in_table(must_kill, v.kills)
			end
			if matches then
				local tech = true
				for j,w in pairs(v.tech) do
					if not in_table(w, Army.Values.Techs) then
						tech = false
					end
				end
				if tech then
					available[#available + 1] = i
				end
			end
		end
	end
	
	if #available == 0 then
		return nil
	end
	return available[Utils.RandomInteger(1, #available + 1)]
end

-- An army must be able to kill every type available depending on tech
function Army.GenerateArmy()
	local size = Army.Sizes[Army.Values.Size].value
	local remaining = size
	local support_remaining = math.floor(size / 5)
	local army = {}
	
	if(#Army.Values.Kill > 0 and size >= Army.Values.RemainMin[Army.Values.Kill[1]]) then
		for i,v in pairs(Army.Values.Kill) do
			local squad_id = Army.RandomSquad(remaining - Army.Values.RemainMin[v], v, support_remaining)
			if squad_id ~= nil then
				remaining = remaining - Squads[squad_id].value
				if Squads[squad_id].support then
					support_remaining = support_remaining - Squads[squad_id].value
				end
				army[#army+1] = squad_id
			end
		end
	end
	
	while remaining > 0 do
		local squad_id = Army.RandomSquad(remaining, nil, support_remaining)
		if squad_id == nil then
			break
		end
		remaining = remaining - Squads[squad_id].value
		if Squads[squad_id].support then
			support_remaining = support_remaining - Squads[squad_id].value
		end
		army[#army+1] = squad_id
	end
	
	return army;
end

function Army.GenerateBonusArmy(size)
	local remaining = size
	-- Bonus armys can be up to 50% support
	local support_remaining = math.floor(size / 2)
	local army = {}
	
	-- Don't try to balance
	while remaining > 0 do
		local squad_id = Army.RandomSquad(remaining, nil, support_remaining)
		if squad_id == nil then
			break
		end
		remaining = remaining - Squads[squad_id].value
		if Squads[squad_id].support then
			support_remaining = support_remaining - Squads[squad_id].value
		end
		army[#army+1] = squad_id
	end
	
	return army;
end

function Army.UnitsAddArmy(units, army)
	for i,v in pairs(army) do
		for j,w in pairs(Squads[v].units) do
			units[#units+1] = w
		end
	end
	return units
end

function Army.GetSizeDelay()
	return Army.Sizes[Army.Values.Size].delay
end

function Army.GetSizeName()
	return Army.Sizes[Army.Values.Size].name
end

function Army.GetSizeValue()
	return Army.Sizes[Army.Values.Size].value
end

function Army.IsMirror()
	return Army.Values.Mirror
end

function Army.GetTechDescription()
	local buffer = ""
	local first = true
	for i,v in pairs(Army.Values.Techs) do
		if first then
			first = false
		else
			if i == #Army.Values.Techs then
				buffer = buffer .. " and "
			else
				buffer = buffer .. ", "
			end
		end
		buffer = buffer .. Army.GetTechName(v)
	end
	return buffer
end

function Army.GetTechName(tech)
	for i,v in pairs(Army.Techs) do
		if v.name == tech then
			return v.text
		end
	end
	return ""
end