

Creeps = Player.GetPlayer("Creeps")
CreepTimer = DateTime.Minutes(10)
CreepsUnleashed = false


WorldLoaded = function()
end

Tick = function()
    -- If creeps are already loose, skip the rest of the function.
    if CreepsUnleashed then
        return
    end
    -- Remove a tick from our timer whenever this function runs.
    CreepTimer = CreepTimer - 1
    SetTimerText(CreepTimer)

    if CreepTimer < 1 then
        UnleashCreeps()
        -- Clear the timer message with blank text.
        UserInterface.SetMissionText("The nightmare has spawned!!", HSLColor.Cyan)
    end
end

SetTimerText = function(timer)
    local color = HSLColor.White
    if timer < DateTime.Seconds(30) then
        color = HSLColor.Red
    elseif timer < DateTime.Minutes(1) then
        color = HSLColor.OrangeRed
    elseif timer < DateTime.Minutes(5) then
        color = HSLColor.Yellow
    end
    UserInterface.SetMissionText("Nightmare begins in " .. Utils.FormatTime(timer), color)
end

UnleashCreeps = function()
    CreepsUnleashed = true
    -- create 50 e1 actors
    for j = 1, 7 do
        for i = 1, 7 do
            Actor.Create("e1", true, {UnitStance = AttackAnything, Location = CPos.New(29+(i-1),29+(j-1)), Owner = Creeps})
            i = i + 1
        end
        j=j+1
    end
    for j = 1, 7 do
        for i = 1, 7 do
            Actor.Create("e3", true, {UnitStance = AttackAnything, Location = CPos.New(29+(i-1),29+(j-1)), Owner = Creeps})
            i = i + 1
        end
        j=j+1
    end

    Actor.Create("e7", true, {UnitStance = AttackAnything, Location = CPos.New(32,32), Owner = Creeps})
    Actor.Create("e7", true, {UnitStance = AttackAnything, Location = CPos.New(32,32), Owner = Creeps})
    Actor.Create("e7", true, {UnitStance = AttackAnything, Location = CPos.New(32,32), Owner = Creeps})
    Actor.Create("e7", true, {UnitStance = AttackAnything, Location = CPos.New(32,32), Owner = Creeps})
    Actor.Create("e7", true, {UnitStance = AttackAnything, Location = CPos.New(32,32), Owner = Creeps})

    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(32,30),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(31,31),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(33,31),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(30,32),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(32,32),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(34,32),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(31,33),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(33,33),  Owner = Creeps})
    Actor.Create("4tnk", true, {UnitStance = AttackAnything,  Location = CPos.New(32,34),  Owner = Creeps})

    

end
